/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.servlet.Status;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.scene.Scene;
import com.composum.sling.nodes.scene.SceneConfigurations;
import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Restricted(key="nodes/components/scenes")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Scene Servlet", "sling.servlet.paths=/bin/cpm/nodes/scene", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.auth.requirements=/bin/cpm/nodes/scene"})
public class SceneServlet
extends AbstractServiceServlet {
    public static final String SERVLET_PATH = "/bin/cpm/nodes/scene";
    public static final String SERVICE_KEY = "nodes/components/scenes";
    public static final String PARAM_SCENE = "scene";
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    protected NodesConfiguration nodesConfig;
    protected BundleContext bundleContext;
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);

    @NotNull
    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.data, (ServletOperation)new SceneDataOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.prepare, (ServletOperation)new PrepareSceneOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.remove, (ServletOperation)new RemoveSceneOperation());
    }

    protected class RemoveSceneOperation
    extends SceneOperation {
        protected RemoveSceneOperation() {
        }

        @Override
        protected void applyScene(@NotNull Status status, @NotNull BeanContext context, @NotNull Scene scene, @NotNull String toolId) throws IOException {
            Resource sceneResource = scene.getContentResource();
            if (!ResourceUtil.isNonExistingResource((Resource)sceneResource)) {
                SlingHttpServletRequest request = context.getRequest();
                ResourceResolver resolver = request.getResourceResolver();
                resolver.delete(sceneResource);
                resolver.commit();
            }
            this.answer(status, scene, toolId);
        }
    }

    protected class PrepareSceneOperation
    extends SceneOperation {
        protected PrepareSceneOperation() {
        }

        @Override
        protected void applyScene(@NotNull Status status, @NotNull BeanContext context, @NotNull Scene scene, @NotNull String toolId) throws IOException {
            SlingHttpServletRequest request = context.getRequest();
            boolean reset = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"reset", (Boolean)Boolean.FALSE);
            Resource sceneContent = scene.prepareContent(reset);
            if (sceneContent != null) {
                request.getResourceResolver().commit();
                this.answer(status, scene, toolId);
            } else {
                status.error("no content available ({})", new Object[]{scene.getContentPath()});
            }
        }
    }

    protected class SceneDataOperation
    extends SceneOperation {
        protected SceneDataOperation() {
        }

        @Override
        protected void applyScene(@NotNull Status status, @NotNull BeanContext context, @NotNull Scene scene, @NotNull String toolId) {
            this.answer(status, scene, toolId);
        }
    }

    protected abstract class SceneOperation
    implements ServletOperation {
        protected SceneOperation() {
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @Nullable ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            Status status;
            block5: {
                status = new Status(request, response);
                String sceneId = request.getParameter(SceneServlet.PARAM_SCENE);
                if (resource != null && StringUtils.isNotBlank((CharSequence)sceneId)) {
                    try {
                        String sceneKey = StringUtils.substringBefore((String)sceneId, (String)"/");
                        String toolId = StringUtils.substringAfter((String)sceneId, (String)"/");
                        SceneConfigurations.Config sceneConfig = SceneConfigurations.instance(request).getSceneConfig(sceneKey);
                        if (sceneConfig != null) {
                            BeanContext.Servlet context = new BeanContext.Servlet(SceneServlet.this.getServletContext(), SceneServlet.this.bundleContext, request, response);
                            Scene scene = new Scene((BeanContext)context, sceneConfig, resource.getPath());
                            this.applyScene(status, (BeanContext)context, scene, toolId);
                            break block5;
                        }
                        status.error("scene not available ({})", new Object[]{sceneId});
                    }
                    catch (IOException ex) {
                        status.error("an error has been occured", (Throwable)ex);
                    }
                } else {
                    status.error("values missed (path={},scene={})", new Object[]{request.getRequestPathInfo().getSuffix(), sceneId});
                }
            }
            status.sendJson();
        }

        protected abstract void applyScene(@NotNull Status var1, @NotNull BeanContext var2, @NotNull Scene var3, @NotNull String var4) throws IOException;

        protected void answer(@NotNull Status status, @NotNull Scene scene, @NotNull String toolId) {
            SceneConfigurations.Config config = scene.getConfig();
            SceneConfigurations.Config.Tool tool = config.getTool(toolId);
            status.data("tool").put("name", toolId);
            if (scene.isContentPrepared()) {
                status.data(SceneServlet.PARAM_SCENE).put("prepared", true);
                status.data(SceneServlet.PARAM_SCENE).put("contentPath", scene.getContentPath());
                status.data(SceneServlet.PARAM_SCENE).put("elementPath", scene.getElementPath());
            }
            if (tool != null) {
                status.data("tool").put("frameUrl", scene.getFrameUrl(toolId));
            }
            status.data("config").put("key", config.getKey());
            status.data("config").put("path", config.getPath());
        }
    }

    public static enum Operation {
        data,
        prepare,
        remove;

    }

    public static enum Extension {
        json;

    }
}

