/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.servlet;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.NodesConfiguration;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import com.composum.sling.nodes.mount.ExtendedResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.jcr.Binary;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/repository/source")
public class SourceModel
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SourceModel.class);
    public static final StringFilter EXCLUDED_PROPS = new StringFilter.WhiteList(new String[]{"^jcr:baseVersion$", "^jcr:predecessors$", "^jcr:versionHistory$", "^jcr:isCheckedOut$", "^jcr:created", "^jcr:lastModified", "^jcr:uuid$", "^jcr:data$", "^cq:lastModified", "^cq:lastReplicat"});
    public static final StringFilter EXCLUDED_MIXINS = new StringFilter.WhiteList("^rep:AccessControllable$");
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final String BASIC_INDENT = "    ";
    protected static final Pattern PATH_WITHIN_JCR_CONTENT = Pattern.compile(".*/jcr:content/.*$");
    protected final NodesConfiguration config;
    protected transient List<Property> propertyList;
    protected transient List<Resource> subnodeList;
    protected transient Boolean[] hasOrderableSiblings;
    protected transient Boolean[] hasOrderableChildren;
    protected transient Comparator<Property> propertyComparator;
    protected transient List<String> nonExistingNamespaces = new ArrayList<String>();

    public SourceModel(NodesConfiguration config, BeanContext context, Resource resource) {
        this.config = config;
        this.initialize(context, resource);
    }

    @NotNull
    public String getExportRootPath() {
        String resolverRootPath;
        String exportRootPath = "/";
        ResourceResolver resolver = this.getResolver();
        if (resolver instanceof ExtendedResolver && (resolverRootPath = ((ExtendedResolver)resolver).getResolverRootPath()) != null) {
            exportRootPath = resolverRootPath;
        }
        return exportRootPath;
    }

    @NotNull
    public String getExportPath(@NotNull String path) {
        String exportPath = path;
        String exportRootPath = this.getExportRootPath();
        if (!"/".equals(exportRootPath)) {
            if (path.equals(exportRootPath)) {
                exportPath = "/";
            } else if (path.startsWith(exportRootPath + "/")) {
                exportPath = path.substring(exportRootPath.length());
            }
        }
        return exportPath;
    }

    public boolean isRootPath(@NotNull String aPath) {
        return this.getExportRootPath().equals(aPath);
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getPrimaryType() {
        return StringUtils.defaultString((String)ResourceUtil.getPrimaryType((Resource)this.resource));
    }

    public FileTime getLastModified(Resource rawResource) {
        ResourceHandle someResource = ResourceHandle.use((Resource)rawResource);
        Calendar timestamp = (Calendar)someResource.getProperties().get("jcr:lastModified", Calendar.class);
        if (timestamp == null) {
            timestamp = (Calendar)someResource.getProperties().get("jcr:created", Calendar.class);
        }
        if (timestamp == null) {
            timestamp = (Calendar)someResource.getContentResource().getProperties().get("jcr:lastModified", Calendar.class);
        }
        if (timestamp == null) {
            timestamp = (Calendar)someResource.getContentResource().getProperties().get("jcr:created", Calendar.class);
        }
        if (timestamp == null) {
            timestamp = (Calendar)someResource.getInherited("jcr:lastModified", Calendar.class);
        }
        if (timestamp == null) {
            timestamp = (Calendar)someResource.getInherited("jcr:created", Calendar.class);
        }
        return timestamp != null ? FileTime.from(timestamp.getTimeInMillis(), TimeUnit.MILLISECONDS) : null;
    }

    public List<Property> getPropertyList() {
        if (this.propertyList == null) {
            this.propertyList = new ArrayList<Property>();
            Node jcrNode = (Node)this.resource.adaptTo(Node.class);
            for (Map.Entry entry : this.resource.getProperties().entrySet()) {
                Property property;
                Integer type = null;
                if (jcrNode != null) {
                    try {
                        javax.jcr.Property jcrProp = jcrNode.getProperty((String)entry.getKey());
                        type = jcrProp.getType();
                        if ("jcr:primaryType".equals(entry.getKey()) || "jcr:mixinTypes".equals(entry.getKey()) || jcrProp.getDefinition().getRequiredType() != 0) {
                            type = null;
                        }
                    }
                    catch (RepositoryException e) {
                        LOG.debug("Error reading property {}/{} : {}", new Object[]{this.resource.getPath(), entry.getValue(), e.toString()});
                    }
                } else {
                    Object value = entry.getValue();
                    if (value != null) {
                        if (value instanceof String || value instanceof String[]) {
                            type = 1;
                        } else if (value instanceof Long || value instanceof Long[]) {
                            type = 3;
                        } else if (value instanceof Boolean || value instanceof Boolean[]) {
                            type = 6;
                        } else if (value instanceof Double || value instanceof Double[]) {
                            type = 4;
                        } else if (value instanceof Calendar || value instanceof Calendar[]) {
                            type = 5;
                        } else if (value instanceof InputStream) {
                            type = 2;
                        }
                    }
                }
                if (this.isExcluded(property = new Property((String)entry.getKey(), entry.getValue(), type))) continue;
                this.propertyList.add(property);
            }
            Collections.sort(this.propertyList, this.getPropertyComparator());
        }
        return this.propertyList;
    }

    protected boolean isExcluded(Property property) {
        return EXCLUDED_PROPS.accept(property.getName());
    }

    public boolean hasSubnodes() {
        return !this.getSubnodeList().isEmpty();
    }

    public List<Resource> getSubnodeList() {
        if (this.subnodeList == null) {
            this.subnodeList = new ArrayList<Resource>();
            Resource jcrcontent = null;
            Iterator iterator = this.resource.listChildren();
            while (iterator.hasNext()) {
                Resource subnode = (Resource)iterator.next();
                if (!this.config.getSourceNodesFilter().accept(subnode) || ResourceUtil.isSyntheticResource((Resource)subnode)) continue;
                if (subnode.getName().equals("jcr:content")) {
                    jcrcontent = subnode;
                    continue;
                }
                this.subnodeList.add(subnode);
            }
            if (jcrcontent != null) {
                this.subnodeList.add(0, jcrcontent);
            }
        }
        return this.subnodeList;
    }

    protected void determineNamespaces(List<String> keys, boolean inFullCoverage) {
        this.addNameNamespace(keys, this.getPrimaryType());
        List<Property> properties = this.getPropertyList();
        for (Property property : properties) {
            String ns = property.getNs();
            this.addNamespace(keys, ns);
        }
        this.addNameNamespace(keys, this.resource.getName());
        boolean subnodeInFullCoverage = inFullCoverage || this.isFullCoverageNode();
        for (Resource subnode : this.getSubnodeList()) {
            this.addNameNamespace(keys, subnode.getName());
            SourceModel subnodeModel = new SourceModel(this.config, this.context, subnode);
            if (subnodeModel.getRenderingType((Resource)subnodeModel.getResource(), subnodeInFullCoverage) != RenderingType.EMBEDDED) continue;
            subnodeModel.determineNamespaces(keys, subnodeInFullCoverage);
        }
    }

    protected void addNameNamespace(List<String> keys, String aName) {
        String ns = this.getNamespace(aName);
        this.addNamespace(keys, ns);
    }

    protected void addNamespace(List<String> keys, String ns) {
        if (StringUtils.isNotBlank((CharSequence)ns) && !keys.contains(ns)) {
            keys.add(ns);
        }
    }

    protected String getNamespace(String aName) {
        int delim = aName.indexOf(58);
        return delim < 0 ? "" : aName.substring(0, delim);
    }

    public void writePackage(OutputStream output, String group, String packageName, String version) throws IOException, IOErrorOnCloseException, RepositoryException {
        String root = "jcr_root";
        ZipOutputStream zipStream = new ZipOutputStream(output);
        this.writePackageProperties(zipStream, group, packageName, version);
        this.writeFilterXml(zipStream);
        if ("jcr:content".equals(this.getName())) {
            ResourceHandle parent = this.resource.getParent();
            if (parent != null) {
                SourceModel parentModel = new SourceModel(this.config, this.context, (Resource)parent);
                this.writeParents(zipStream, root, (Resource)parentModel.getResource().getParent());
                parentModel.writeIntoZip(zipStream, root, DepthMode.DEEP);
            }
        } else {
            this.writeParents(zipStream, root, (Resource)this.resource.getParent());
            this.writeIntoZip(zipStream, root, DepthMode.DEEP);
        }
        zipStream.flush();
        try {
            zipStream.close();
        }
        catch (IOException e) {
            throw new IOErrorOnCloseException(e);
        }
    }

    public boolean hasOrderableSiblings() {
        Boolean result = null;
        try {
            ResourceHandle parent = this.getResource().getParent();
            if (this.hasOrderableSiblings == null) {
                result = this.hasOrderableChildren(parent);
                this.hasOrderableSiblings = new Boolean[]{result};
            } else {
                result = this.hasOrderableSiblings[0];
            }
        }
        catch (RuntimeException ex) {
            LOG.warn(ex.toString());
        }
        return result != null ? result : false;
    }

    public boolean hasOrderableChildren() {
        if (this.hasOrderableChildren == null) {
            Boolean determined = this.hasOrderableChildren(this.resource);
            this.hasOrderableChildren = new Boolean[]{determined != null ? determined : Boolean.FALSE};
        }
        return this.hasOrderableChildren[0];
    }

    protected Boolean hasOrderableChildren(ResourceHandle aResource) {
        try {
            Node node = (Node)Objects.requireNonNull(aResource).adaptTo(Node.class);
            if (node != null) {
                return node.getPrimaryNodeType().hasOrderableChildNodes();
            }
            String primaryType = this.resource.getPrimaryType();
            if (primaryType != null && primaryType.equals("sling:OrderedFolder")) {
                return true;
            }
        }
        catch (RuntimeException | RepositoryException e) {
            LOG.warn("Can't determine orderability of {}", (Object)this.getPath(), (Object)e);
        }
        return null;
    }

    protected void writePackageProperties(ZipOutputStream zipStream, String group, String aName, String version) throws IOException {
        ZipEntry entry = new ZipEntry("META-INF/vault/properties.xml");
        zipStream.putNextEntry(entry);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipStream, StandardCharsets.UTF_8);
        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>\n").append("<!DOCTYPE properties SYSTEM \"http://java.sun.com/dtd/properties.dtd\">\n").append("<properties>\n").append("<comment>FileVault Package Properties</comment>\n").append("<entry key=\"packageType\">content</entry> ").append("<entry key=\"name\">").append(Property.escapeXmlAttribute(aName)).append("</entry>\n").append("<entry key=\"buildCount\">1</entry>\n").append("<entry key=\"version\">").append(Property.escapeXmlAttribute(version)).append("</entry>\n").append("<entry key=\"packageFormatVersion\">2</entry>\n").append("<entry key=\"group\">").append(Property.escapeXmlAttribute(group)).append("</entry>\n").append("<entry key=\"description\">created from source download</entry>\n").append("<entry key=\"createdBy\">");
        String userId = this.getResolver().getUserID();
        if (userId != null) {
            ((Writer)writer).append(Property.escapeXmlAttribute(userId));
        }
        ((Writer)writer).append("</entry>\n").append("<entry key=\"created\">").append(ZonedDateTime.now().format(DateTimeFormatter.ISO_INSTANT)).append("</entry>\n").append("</properties>");
        ((Writer)writer).flush();
        zipStream.closeEntry();
    }

    protected void writeFilterXml(ZipOutputStream zipStream) throws IOException {
        String path = this.getExportPath(this.resource.getPath());
        ZipEntry entry = new ZipEntry("META-INF/vault/filter.xml");
        zipStream.putNextEntry(entry);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipStream, StandardCharsets.UTF_8);
        ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n").append("<workspaceFilter version=\"1.0\">\n").append("    <filter root=\"").append(Property.escapeXmlAttribute(path)).append("\"/>\n").append("</workspaceFilter>\n");
        ((Writer)writer).flush();
        zipStream.closeEntry();
    }

    protected void writeParents(@NotNull ZipOutputStream zipStream, @NotNull String root, @Nullable Resource parent) throws IOException, RepositoryException {
        if (parent != null && !this.isRootPath(parent.getPath())) {
            this.writeParents(zipStream, root, parent.getParent());
            SourceModel parentModel = new SourceModel(this.config, this.context, parent);
            parentModel.writeIntoZip(zipStream, root, DepthMode.PROPERTIESONLY);
        }
    }

    public void writeArchive(@NotNull OutputStream output) throws IOException, RepositoryException {
        ZipOutputStream zipStream = new ZipOutputStream(output);
        this.writeIntoZip(zipStream, this.resource.getPath(), DepthMode.DEEP);
        zipStream.flush();
        zipStream.close();
    }

    protected void writeIntoZip(@NotNull ZipOutputStream zipStream, @NotNull String root, @NotNull DepthMode depthMode) throws IOException, RepositoryException {
        if (this.resource == null || ResourceUtil.isNonExistingResource((Resource)this.resource)) {
            return;
        }
        if (ResourceUtil.isResourceType((Resource)this.resource, (String)"nt:resource") && ResourceUtil.isResourceType((Resource)this.resource.getParent(), (String)"nt:file")) {
            new SourceModel(this.config, this.context, (Resource)this.resource.getParent()).writeIntoZip(zipStream, root, depthMode);
            return;
        }
        RenderingType renderingType = this.getRenderingType((Resource)this.resource, false);
        if (renderingType == RenderingType.BINARYFILE) {
            if (DepthMode.DEEP == depthMode) {
                this.writeFile(zipStream, root, this.resource);
            }
            return;
        }
        String zipName = this.getZipName(root);
        ZipEntry entry = new ZipEntry(zipName);
        FileTime lastModified = this.getLastModified((Resource)this.resource);
        LOG.debug("Writing entry {} ({})", (Object)entry.getName(), (Object)root);
        if (lastModified != null) {
            entry.setLastModifiedTime(lastModified);
        }
        zipStream.putNextEntry(entry);
        ArrayDeque<String> binaryProperties = new ArrayDeque<String>();
        ArrayDeque<SourceModel> additionalFiles = new ArrayDeque<SourceModel>();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipStream, StandardCharsets.UTF_8);
        this.writeXmlFile(writer, depthMode, binaryProperties, additionalFiles);
        ((Writer)writer).flush();
        zipStream.closeEntry();
        this.writeBinaryProperties(zipStream, root, binaryProperties);
        for (SourceModel binaryFile : additionalFiles) {
            binaryFile.writeIntoZip(zipStream, root, depthMode);
        }
    }

    protected void writeFile(@NotNull ZipOutputStream zipStream, @NotNull String root, @NotNull ResourceHandle file) throws IOException, RepositoryException {
        boolean contentNodeIsNonstandard;
        ZipEntry entry;
        InputStream fileContent;
        ResourceHandle origFile = file;
        if (file.getName().equals("jcr:content")) {
            file = file.getParent();
        }
        FileTime lastModified = this.getLastModified((Resource)file);
        String path = Objects.requireNonNull(file).getPath();
        Binary binaryData = ResourceUtil.getBinaryData((Resource)file);
        if (binaryData != null) {
            fileContent = binaryData.getStream();
        } else {
            Resource content;
            fileContent = (InputStream)file.getProperty("jcr:data", InputStream.class);
            if (fileContent == null && (content = file.getChild("jcr:content")) != null) {
                fileContent = (InputStream)content.getValueMap().get("jcr:data", InputStream.class);
            }
        }
        if (fileContent != null) {
            entry = new ZipEntry(this.getZipName(root, path));
            LOG.debug("Writing entry {}", (Object)entry.getName());
            if (lastModified != null) {
                entry.setLastModifiedTime(lastModified);
            }
            InputStream writeContent = fileContent;
            this.putEntry(zipStream, entry, () -> IOUtils.copy((InputStream)writeContent, (OutputStream)zipStream), () -> writeContent.close());
        } else {
            LOG.warn("Can't get binary data for {}", (Object)path);
        }
        boolean fileIsNonstandard = ((String[])file.getProperty("jcr:mixinTypes", (Object)new String[0])).length > 0 || !"nt:file".equals(file.getProperty("jcr:primaryType", String.class));
        boolean bl = contentNodeIsNonstandard = ((String[])file.getContentResource().getProperty("jcr:mixinTypes", (Object)new String[0])).length > 0 || !"nt:resource".equals(file.getContentResource().getProperty("jcr:primaryType", String.class));
        if (fileIsNonstandard || contentNodeIsNonstandard) {
            ArrayDeque<String> binaryProperties = new ArrayDeque<String>();
            ArrayDeque binaryFiles = new ArrayDeque();
            entry = new ZipEntry(this.getZipName(root, file.getPath() + ".dir/.content.xml"));
            LOG.debug("Writing entry {}", (Object)entry.getName());
            if (lastModified != null) {
                entry.setLastModifiedTime(lastModified);
            }
            SourceModel fileModel = new SourceModel(this.config, this.context, (Resource)file);
            this.putEntry(zipStream, entry, () -> {
                @NotNull OutputStreamWriter writer = new OutputStreamWriter((OutputStream)zipStream, StandardCharsets.UTF_8);
                fileModel.writeXmlFile(writer, DepthMode.DEEP, binaryProperties, binaryFiles);
                ((Writer)writer).flush();
            }, null);
            this.writeBinaryProperties(zipStream, root, binaryProperties);
            for (SourceModel binaryFile : binaryFiles) {
                binaryFile.writeIntoZip(zipStream, root, DepthMode.DEEP);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putEntry(@NotNull ZipOutputStream zipStream, @NotNull ZipEntry entry, @NotNull IOExceptionRunnable writeAction, @Nullable IOExceptionRunnable finalAction) throws IOException, RepositoryException {
        try {
            zipStream.putNextEntry(entry);
            writeAction.run();
        }
        catch (ZipException e) {
            if (!e.getMessage().contains("duplicate entry")) {
                throw e;
            }
            LOG.warn("Duplicated entry for {} - skipping duplicate", (Object)entry.getName(), (Object)e);
        }
        finally {
            zipStream.closeEntry();
            if (finalAction != null) {
                finalAction.run();
            }
        }
    }

    protected void writeBinaryProperties(@NotNull ZipOutputStream zipStream, @NotNull String root, @Nullable Queue<String> binaryProperties) throws IOException {
        if (binaryProperties == null || binaryProperties.isEmpty()) {
            return;
        }
        for (String binPropPath : binaryProperties) {
            Resource propertyResource = this.resolver.getResource(binPropPath);
            InputStream inputStream = propertyResource != null ? (InputStream)propertyResource.adaptTo(InputStream.class) : null;
            try {
                if (inputStream != null) {
                    FileTime lastModified = this.getLastModified((Resource)ResourceHandle.use((Resource)propertyResource));
                    ZipEntry entry = new ZipEntry(this.getZipName(root, binPropPath) + ".binary");
                    LOG.debug("Writing entry {}", (Object)entry.getName());
                    if (lastModified != null) {
                        entry.setLastModifiedTime(lastModified);
                    }
                    zipStream.putNextEntry(entry);
                    IOUtils.copy((InputStream)inputStream, (OutputStream)zipStream);
                    zipStream.closeEntry();
                    continue;
                }
                LOG.warn("Can't get binary data for binary property {}", (Object)binPropPath);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
    }

    protected String getZipName(@NotNull String root, @NotNull String resourcePath) {
        String exportRoot;
        String name = this.getExportPath(resourcePath);
        name = name.startsWith(exportRoot = this.getExportPath(root)) ? name.substring(exportRoot.length() + 1) : exportRoot + name;
        return this.filesystemName(name);
    }

    protected String getZipName(@NotNull String root) {
        String zipName;
        RenderingType renderingType = this.getRenderingType((Resource)this.resource, false);
        switch (renderingType) {
            case FOLDER: {
                zipName = this.getZipName(root, this.getPath() + "/.content.xml");
                break;
            }
            case BINARYFILE: {
                zipName = this.getZipName(root, this.getPath());
                break;
            }
            case EMBEDDED: 
            case XMLFILE: {
                if ("jcr:content".equals(this.getName())) {
                    zipName = this.getZipName(root, this.resource.getParentPath() + "/.content.xml");
                    break;
                }
                zipName = this.getZipName(root, this.getPath() + ".xml");
                break;
            }
            default: {
                throw new IllegalArgumentException("Impossible rendering type " + (Object)((Object)renderingType));
            }
        }
        return zipName;
    }

    protected String filesystemName(String aName) {
        return PlatformNameFormat.getPlatformPath((String)aName);
    }

    public void writeXmlFile(@NotNull Writer writer, boolean writeDeep) throws IOException, RepositoryException {
        DepthMode depthMode = writeDeep ? DepthMode.DEEP : DepthMode.PROPERTIESONLY;
        this.writeXmlFile(writer, depthMode, null, null);
    }

    protected void writeXmlFile(@NotNull Writer writer, @NotNull DepthMode depthMode, @Nullable Queue<String> binaryProperties, @Nullable Queue<SourceModel> additionalFiles) throws IOException, RepositoryException {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add("jcr");
        this.determineNamespaces(namespaces, this.isFullCoverageNode());
        Collections.sort(namespaces);
        writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.append("<jcr:root");
        this.writeNamespaceAttributes(writer, namespaces);
        this.writeProperties(writer, "        ", binaryProperties);
        writer.append(">\n");
        switch (depthMode) {
            case DEEP: {
                this.writeSubnodesAsXml(writer, BASIC_INDENT, this.isFullCoverageNode(), binaryProperties, additionalFiles);
                break;
            }
            case CONTENTNODE: {
                Resource contentNode = this.resource.getChild("jcr:content");
                if (contentNode != null) {
                    SourceModel contentNodeModel = new SourceModel(this.config, this.context, contentNode);
                    contentNodeModel.writeXmlSubnode(writer, BASIC_INDENT, this.isFullCoverageNode(), binaryProperties, additionalFiles);
                }
                this.writeSubnodeOrder(writer, BASIC_INDENT, true);
                break;
            }
            default: {
                this.writeSubnodeOrder(writer, BASIC_INDENT, false);
            }
        }
        writer.append("</jcr:root>\n");
    }

    protected void writeSubnodesAsXml(@NotNull Writer writer, @NotNull String indent, boolean inFullCoverageNode, @Nullable Queue<String> binaryProperties, @Nullable Queue<SourceModel> additionalFiles) throws IOException {
        for (Resource subnode : this.getSubnodeList()) {
            SourceModel subnodeModel = new SourceModel(this.config, this.context, subnode);
            subnodeModel.writeXmlSubnode(writer, indent, inFullCoverageNode, binaryProperties, additionalFiles);
        }
    }

    protected void writeXmlSubnode(@NotNull Writer writer, @NotNull String indent, boolean inFullCoverageNode, @Nullable Queue<String> binaryProperties, @Nullable Queue<SourceModel> additionalFiles) throws IOException {
        String name = this.escapeXmlName(this.getName());
        RenderingType renderingType = this.getRenderingType((Resource)this.resource, inFullCoverageNode);
        boolean fullCoverage = inFullCoverageNode || this.isFullCoverageNode();
        switch (renderingType) {
            case EMBEDDED: {
                writer.append(indent).append("<").append(name);
                this.writeProperties(writer, indent + "        ", binaryProperties);
                if (this.hasSubnodes()) {
                    writer.append(">\n");
                    this.writeSubnodesAsXml(writer, indent + BASIC_INDENT, fullCoverage, binaryProperties, additionalFiles);
                    writer.append(indent).append("</").append(name).append(">\n");
                    break;
                }
                writer.append("/>\n");
                break;
            }
            case FOLDER: 
            case BINARYFILE: 
            case XMLFILE: {
                if (additionalFiles != null) {
                    additionalFiles.add(this);
                }
                if (!this.hasOrderableSiblings()) break;
                writer.append(indent).append("<").append(name).append("/>\n");
                break;
            }
            default: {
                throw new IllegalArgumentException("Impossible rendering type " + (Object)((Object)renderingType));
            }
        }
    }

    protected void writeSubnodeOrder(Writer writer, String indent, boolean skipContentNode) throws IOException {
        if (this.hasOrderableChildren() && this.getSubnodeList().size() > 1) {
            for (Resource subnode : this.getSubnodeList()) {
                if (skipContentNode && "jcr:content".equals(subnode.getName())) continue;
                writer.append(indent).append("<").append(this.escapeXmlName(subnode.getName())).append("/>\n");
            }
        }
    }

    protected void writeProperties(@NotNull Writer writer, @NotNull String indent, @Nullable Queue<String> binaryProperties) throws IOException {
        for (Property property : this.getPropertyList()) {
            if (binaryProperties != null && property.isBinary()) {
                binaryProperties.add(this.getPath() + "/" + property.getName());
            }
            this.writeProperty(writer, indent, property.getName(), property.getEscapedString(indent));
        }
    }

    protected void writeProperty(Writer writer, String indent, String propertyName, String escapedValue) throws IOException {
        if (StringUtils.isNotEmpty((CharSequence)escapedValue)) {
            writer.append("\n");
            writer.append(indent);
            writer.append(this.escapeXmlName(propertyName));
            writer.append("=\"");
            writer.append(escapedValue);
            writer.append("\"");
        }
    }

    protected void writeNamespaceAttributes(Writer writer, List<String> namespaces) throws RepositoryException, IOException {
        Session session = this.getSession();
        if (session != null) {
            for (int i = 0; i < namespaces.size(); ++i) {
                String ns = namespaces.get(i);
                try {
                    String url = session.getNamespaceURI(ns);
                    if (!StringUtils.isNotBlank((CharSequence)url)) continue;
                    writer.append(" xmlns:").append(ns).append("=\"").append(url).append("\"");
                    if (i + 1 >= namespaces.size()) continue;
                    writer.append("\n       ");
                    continue;
                }
                catch (NamespaceException nsex) {
                    LOG.debug(nsex.toString());
                    this.nonExistingNamespaces.add(ns);
                }
            }
        }
    }

    public String escapeXmlName(String propertyName) {
        int pos;
        String prefix;
        String encoded = ISO9075.encode((String)propertyName);
        if (encoded.contains(":") && this.nonExistingNamespaces.contains(prefix = encoded.substring(0, pos = encoded.indexOf(58)))) {
            encoded = encoded.replaceAll(":", "_x003A_");
        }
        return encoded;
    }

    protected RenderingType getRenderingType(Resource aResource, boolean inFullCoverageNode) {
        if (ResourceUtil.isNodeType((Resource)aResource, (String)"nt:file") || ResourceUtil.isNodeType((Resource)aResource, (String)"nt:resource") && !ResourceUtil.isNodeType((Resource)aResource.getParent(), (String)"nt:file")) {
            return RenderingType.BINARYFILE;
        }
        if (PATH_WITHIN_JCR_CONTENT.matcher(aResource.getPath()).matches()) {
            return RenderingType.EMBEDDED;
        }
        if (aResource.getChild("jcr:content") != null) {
            return RenderingType.FOLDER;
        }
        if (this.config.getSourceXmlNodesFilter().accept(aResource)) {
            return RenderingType.XMLFILE;
        }
        if (!inFullCoverageNode && this.config.getSourceFolderNodesFilter().accept(aResource)) {
            return RenderingType.FOLDER;
        }
        return RenderingType.EMBEDDED;
    }

    protected boolean isFullCoverageNode() {
        return this.resource.getName().equalsIgnoreCase("jcr:content") || RenderingType.XMLFILE == this.getRenderingType((Resource)this.resource, false);
    }

    protected Comparator<Property> getPropertyComparator() {
        if (this.propertyComparator == null) {
            this.propertyComparator = Comparator.comparing(Property::getNs, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(Property::getName);
            if (this.config.isSourceAdvancedSortAttributes()) {
                this.propertyComparator = Comparator.comparing(Property::getOrderingLevel).thenComparing(this.propertyComparator);
            }
        }
        return this.propertyComparator;
    }

    public static class IOErrorOnCloseException
    extends IOException {
        public IOErrorOnCloseException(IOException e) {
            super(e);
        }
    }

    public static class Property {
        protected final String name;
        protected final Object value;
        protected final Integer jcrType;

        public Property(String name, Object value, Integer jcrType) {
            this.name = name;
            this.value = value;
            this.jcrType = jcrType;
        }

        public Property(String key, Object value) {
            this(key, value, null);
        }

        public String getNs() {
            int ddot = this.name.indexOf(58);
            return ddot > 0 ? this.name.substring(0, ddot) : null;
        }

        public boolean isMultiValue() {
            return this.value instanceof Object[];
        }

        public boolean isBinary() {
            return this.value instanceof InputStream;
        }

        public String getName() {
            return this.name;
        }

        public String getEscapedString(String indent) {
            if (this.isMultiValue()) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(this.getTypePrefix(this.value));
                Object[] array = this.cleanupArray((Object[])this.value);
                if (array == null || array.length == 0) {
                    return null;
                }
                String lineBreak = "";
                if (this.getEscapedString(array[0]).startsWith(" ")) {
                    lineBreak = "\r";
                }
                buffer.append("[").append(lineBreak);
                for (int i = 0; i < array.length; ++i) {
                    String string = this.getEscapedString(array[i]);
                    string = string.replace(",", "\\,");
                    if (StringUtils.isNotEmpty((CharSequence)lineBreak)) {
                        string = string.trim();
                        buffer.append(indent).append(SourceModel.BASIC_INDENT);
                    }
                    buffer.append(string);
                    if (i + 1 >= array.length) continue;
                    buffer.append(',').append(lineBreak);
                }
                if (StringUtils.isNotEmpty((CharSequence)lineBreak)) {
                    buffer.append(lineBreak).append(indent);
                }
                buffer.append("]");
                return buffer.toString();
            }
            String typePrefix = this.getTypePrefix(this.value);
            String valueString = this.getEscapedString(this.value);
            if (StringUtils.startsWith((CharSequence)valueString, (CharSequence)"[")) {
                valueString = "\\" + valueString;
            }
            if (StringUtils.isNotBlank((CharSequence)typePrefix) || !StringUtils.startsWith((CharSequence)valueString, (CharSequence)"{")) {
                return typePrefix + valueString;
            }
            return "\\" + valueString;
        }

        protected Object[] cleanupArray(Object[] value) {
            Object[] result = value;
            if ("jcr:mixinTypes".equals(this.name) && value != null) {
                result = Arrays.stream(value).filter(o -> !EXCLUDED_MIXINS.accept(String.valueOf(o))).toArray();
            }
            return result;
        }

        protected String getEscapedString(Object aValue) {
            if (aValue instanceof Calendar) {
                SimpleDateFormat formatter = new SimpleDateFormat(SourceModel.DATE_FORMAT);
                return Property.escapeXmlAttribute(formatter.format(((Calendar)aValue).getTime()));
            }
            if (aValue instanceof InputStream) {
                return "";
            }
            return aValue != null ? Property.escapeXmlAttribute(aValue.toString()) : "";
        }

        public static String escapeXmlAttribute(String attrValue) {
            return attrValue.replace("&", "&amp;").replace("<", "&lt;").replace("\"", "&quot;").replace("\t", "&#x9;").replace("\n", "&#xa;").replace("\r", "&#xd;").replace("\\", "\\\\");
        }

        protected int getOrderingLevel() {
            if (this.name.equals("jcr:primaryType")) {
                return 1;
            }
            if (this.name.equals("jcr:mixinTypes")) {
                return 2;
            }
            if (this.name.startsWith("sling:")) {
                return 3;
            }
            return 4;
        }

        protected String getTypePrefix(Object aValue) {
            if (this.jcrType != null && this.jcrType != 1) {
                return "{" + PropertyType.nameFromValue((int)this.jcrType) + "}";
            }
            if (aValue instanceof String || aValue instanceof String[]) {
                return "";
            }
            if (aValue instanceof Boolean || aValue instanceof Boolean[]) {
                return "{Boolean}";
            }
            if (aValue instanceof BigDecimal || aValue instanceof BigDecimal[]) {
                return "{Decimal}";
            }
            if (aValue instanceof Long || aValue instanceof Long[]) {
                return "{Long}";
            }
            if (aValue instanceof Double || aValue instanceof Double[]) {
                return "{Double}";
            }
            if (aValue instanceof Calendar || aValue instanceof Calendar[]) {
                return "{Date}";
            }
            if (aValue instanceof InputStream) {
                return "{Binary}";
            }
            return "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            return Objects.equals(this.name, property.name) && Objects.equals(this.value, property.value) && Objects.equals(this.jcrType, property.jcrType);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public String toString() {
            return this.name + "=" + this.getEscapedString("");
        }
    }

    public static enum DepthMode {
        PROPERTIESONLY,
        CONTENTNODE,
        DEEP;

    }

    protected static enum RenderingType {
        XMLFILE,
        FOLDER,
        BINARYFILE,
        EMBEDDED;

    }

    @FunctionalInterface
    private static interface IOExceptionRunnable {
        public void run() throws IOException, RepositoryException;
    }
}

