/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.tools;

import com.composum.sling.core.AbstractSlingBean;
import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.nodes.tools.OsgiBundleModel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Restricted(key="system/osgi/bundles")
public class OsgiBundlesModel
extends AbstractSlingBean {
    private transient Map<String, OsgiBundleModel> bundles;
    private transient BundleContext bundleContext;

    public int getCountTotal() {
        return this.getBundles().size();
    }

    public int getCountActive() {
        int active = 0;
        for (OsgiBundleModel bundle : this.getBundles()) {
            if (!bundle.isActive()) continue;
            ++active;
        }
        return active;
    }

    @NotNull
    public Collection<OsgiBundleModel> getBundles() {
        if (this.bundles == null) {
            this.bundles = new LinkedHashMap<String, OsgiBundleModel>();
            for (Bundle bundle : this.getBundleContext().getBundles()) {
                OsgiBundleModel model = new OsgiBundleModel(this.context, bundle);
                this.bundles.put(model.getSymbolicName(), model);
            }
        }
        return this.bundles.values();
    }

    protected BundleContext getBundleContext() {
        if (this.bundleContext == null) {
            this.bundleContext = FrameworkUtil.getBundle(BeanContext.class).getBundleContext();
        }
        return this.bundleContext;
    }

    public OsgiBundlesModel(BeanContext context, Resource resource) {
        super(context, resource);
    }

    public OsgiBundlesModel(BeanContext context) {
        super(context);
    }

    public OsgiBundlesModel() {
    }
}

