/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.tools;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.nodes.tools.OsgiBundleModel;
import com.composum.sling.nodes.tools.OsgiBundlesModel;
import com.composum.sling.nodes.tools.OsgiServiceModel;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Tools Bundles Servlet", "sling.servlet.resourceTypes=composum/nodes/system/tools/osgi/bundles", "sling.servlet.methods=GET", "sling.servlet.extensions=json"})
public class OsgiBundlesServlet
extends SlingSafeMethodsServlet
implements RestrictedService {
    public static final String RESOURCE_TYPE = "composum/nodes/system/tools/osgi/bundles";
    public static final String SERVICE_KEY = "system/osgi/bundles";
    @Reference
    protected ServiceRestrictions restrictions;
    private ServiceRestrictions.Permission permission;
    private boolean enabled = false;
    protected BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.permission = this.restrictions.getPermission(this.getServiceKey());
        this.enabled = this.permission != ServiceRestrictions.Permission.none;
    }

    @NotNull
    public ServiceRestrictions.Key getServiceKey() {
        return new ServiceRestrictions.Key(SERVICE_KEY);
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        if (this.enabled) {
            BeanContext.Servlet context = new BeanContext.Servlet(this.getServletContext(), this.bundleContext, request, response);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            OsgiBundleModel bundle = new OsgiBundleModel((BeanContext)context);
            if (bundle.isValid()) {
                this.writeBundle((BeanContext)context, writer, bundle);
            } else {
                this.writeBundles((BeanContext)context, writer);
            }
        } else {
            response.sendError(403);
        }
    }

    protected void writeBundle(@NotNull BeanContext context, @NotNull JsonWriter writer, @NotNull OsgiBundleModel model) throws IOException {
        writer.beginObject();
        this.writeProperties(writer, model);
        writer.name("more").beginObject();
        for (Map.Entry<String, String> entry : model.getHeaders()) {
            writer.name(entry.getKey()).value(entry.getValue());
        }
        writer.endObject();
        writer.name("exported").beginArray();
        for (OsgiBundleModel.Exported exported : model.getExported()) {
            writer.beginObject();
            writer.name("symbolicName").value(exported.symbolicName);
            if (exported.version != null) {
                writer.name("version").value(exported.version.toString());
            }
            writer.endObject();
        }
        writer.endArray();
        writer.name("imported").beginArray();
        for (OsgiBundleModel.Imported imported : model.getImported()) {
            writer.beginObject();
            writer.name("symbolicName").value(imported.symbolicName);
            if (imported.resolved != null) {
                if (imported.version != null) {
                    writer.name("range").value(imported.version.toString());
                }
                if (imported.resolved.version != null) {
                    writer.name("version").value(imported.resolved.version.toString());
                }
                writer.name("bundle").value(imported.resolved.bundle.getBundleId());
                writer.name("active").value(imported.resolved.active);
            } else if (imported.version != null) {
                writer.name("range").value(imported.version.toString());
            }
            writer.name("resolved").value(imported.resolved != null);
            if (imported.optional) {
                writer.name("optional").value(true);
            }
            writer.endObject();
        }
        writer.endArray();
        writer.name("provided");
        this.writeServices(writer, model.getProvidedServices());
        writer.name("used");
        this.writeServices(writer, model.getUsedServices());
        writer.name("headers").beginObject();
        Dictionary headers = model.bundle.getHeaders();
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            writer.name(key).value(((String)headers.get(key)).replaceAll("([,;])([^ )\\]0-9])", "$1 $2"));
        }
        writer.endObject();
        writer.endObject();
    }

    protected void writeBundles(@NotNull BeanContext context, @NotNull JsonWriter writer) throws IOException {
        OsgiBundlesModel model = new OsgiBundlesModel(context);
        Collection<OsgiBundleModel> bundles = model.getBundles();
        writer.beginObject();
        writer.name("total").value((long)model.getCountTotal());
        writer.name("active").value((long)model.getCountActive());
        writer.name("bundles").beginArray();
        for (OsgiBundleModel bundle : bundles) {
            writer.beginObject();
            this.writeProperties(writer, bundle);
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    protected void writeServices(@NotNull JsonWriter writer, @NotNull Iterator<OsgiServiceModel> iterator) throws IOException {
        writer.beginArray();
        while (iterator.hasNext()) {
            OsgiServiceModel service = iterator.next();
            writer.beginObject();
            writer.name("id").value((long)service.serviceId);
            if (service.description != null) {
                writer.name("description").value(service.description);
            }
            writer.name("short").beginArray();
            for (String string : service.objectClass) {
                writer.value(StringUtils.substringAfterLast((String)string, (String)"."));
            }
            writer.endArray();
            writer.name("classes").beginArray();
            for (String string : service.objectClass) {
                writer.value(string);
            }
            writer.endArray();
            if (service.servicePid != null) {
                writer.name("servicePid").value(service.servicePid);
            }
            writer.name("bundle").value((long)service.bundleId);
            if (service.componentName != null) {
                writer.name("component").beginObject();
                writer.name("id").value((long)service.componentId);
                writer.name("name").value(service.componentName);
                writer.endObject();
            }
            writer.name("properties").beginObject();
            for (Map.Entry entry : service.getProperties().entrySet()) {
                writer.name((String)entry.getKey());
                Object value = entry.getValue();
                if (value instanceof Object[]) {
                    writer.beginArray();
                    for (Object val : (Object[])value) {
                        writer.value(val != null ? val.toString() : null);
                    }
                    writer.endArray();
                    continue;
                }
                writer.value(value != null ? value.toString() : null);
            }
            writer.endObject();
            writer.endObject();
        }
        writer.endArray();
    }

    protected void writeProperties(@NotNull JsonWriter writer, @NotNull OsgiBundleModel model) throws IOException {
        writer.name("id").value((Number)model.getBundleId());
        writer.name("name").value(model.getName());
        writer.name("symbolicName").value(model.getSymbolicName());
        writer.name("location").value(model.getLocation());
        writer.name("version").value(model.getVersion());
        writer.name("lastModified").value(model.getLastModified());
        writer.name("category").value(model.getCategory());
        writer.name("state").value(model.getState().name());
        writer.name("active").value(model.isActive());
    }
}

