/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.nodes.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;

public class OsgiServiceModel {
    protected final ServiceReference<?> service;
    protected final Map<String, Object> properties = new TreeMap<String, Object>();
    protected List<String> objectClass = new ArrayList<String>();
    protected int componentId;
    protected String componentName;
    protected int serviceId;
    protected String servicePid;
    protected int bundleId;
    protected String description;

    public OsgiServiceModel(@NotNull ServiceReference<?> service) {
        this.service = service;
        block20: for (String key : service.getPropertyKeys()) {
            Object value = service.getProperty(key);
            if (value == null) continue;
            switch (key) {
                case "objectClass": {
                    this.objectClass.addAll(Arrays.asList((String[])value));
                    continue block20;
                }
                case "component.id": {
                    this.componentId = Integer.parseInt(value.toString());
                    continue block20;
                }
                case "component.name": {
                    this.componentName = value.toString();
                    continue block20;
                }
                case "service.id": {
                    this.serviceId = Integer.parseInt(value.toString());
                    continue block20;
                }
                case "service.pid": {
                    this.servicePid = value.toString();
                    continue block20;
                }
                case "service.bundleid": {
                    this.bundleId = Integer.parseInt(value.toString());
                    continue block20;
                }
                case "service.description": {
                    this.description = value.toString();
                    continue block20;
                }
                case "service.scope": {
                    continue block20;
                }
                default: {
                    this.properties.put(key, value);
                }
            }
        }
    }

    public List<String> getObjectClass() {
        return this.objectClass;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public int getServiceId() {
        return this.serviceId;
    }

    public String getServicePid() {
        return this.servicePid;
    }

    public int getBundleId() {
        return this.bundleId;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

