/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr;

import com.composum.sling.core.concurrent.AbstractJobExecutor;
import com.composum.sling.core.concurrent.JobFailureException;
import com.composum.sling.core.concurrent.SequencerService;
import com.composum.sling.core.pckgmgr.util.PackageProgressTracker;
import com.composum.sling.core.pckgmgr.util.PackageUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class, EventHandler.class}, property={"service.description=Composum Nodes Package Job Executor Service", "job.topics=com/composum/sling/core/pckgmgr/PackageJobExecutor", "event.topics=org/apache/sling/event/notification/job/*"}, immediate=true)
@Designate(ocd=Configuration.class)
public class PackageJobExecutor
extends AbstractJobExecutor<String> {
    private static final Logger LOG = LoggerFactory.getLogger(PackageJobExecutor.class);
    public static final String JOB_PROPERTY_DRY_RUN = "dryRun";
    public static final String JOB_PROPERTY_SAVE_THRESHOLD = "saveThreshold";
    public static final String JOB_PROPERTY_IMPORT_MODE = "importMode";
    public static final String TOPIC = "com/composum/sling/core/pckgmgr/PackageJobExecutor";
    public static final String AUDIT_BASE_PATH = "/var/audit/jobs/" + PackageJobExecutor.class.getName();
    protected final Lock lock = new ReentrantLock(true);
    @Reference
    private Packaging packaging;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private SequencerService<SequencerService.Token> sequencer;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private volatile Configuration config;

    @Nonnull
    protected ResourceResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }

    @Nonnull
    protected SequencerService<SequencerService.Token> getSequencer() {
        return this.sequencer;
    }

    @Nonnull
    protected DynamicClassLoaderManager getDynamicClassLoaderManager() {
        return this.dynamicClassLoaderManager;
    }

    @Activate
    @Modified
    protected void activate(Configuration configuration) {
        this.config = configuration;
    }

    @Deactivate
    protected void deactivate() {
        this.config = null;
    }

    @Nonnull
    protected String getJobTopic() {
        return TOPIC;
    }

    protected String getAuditBasePath() {
        return AUDIT_BASE_PATH;
    }

    protected boolean jobExecutionEnabled(Job job) {
        return !Boolean.getBoolean("composum.never.start.pckgsvc");
    }

    protected Callable<String> createCallable(Job job, JobExecutionContext context, ResourceResolver serviceResolver, PrintWriter out) throws Exception {
        return new PackageManagerCallable(job, context, serviceResolver, out);
    }

    @ObjectClassDefinition(name="Composum Package Job Executor Service", description="Provides the execution of package operations the repository context.")
    public static @interface Configuration {
        @AttributeDefinition(name="save threshold", description="the auto-save threshold for the package import")
        public int package_save_threshold() default 1024;

        @AttributeDefinition(name="track idle time", description="idle time in seconds for the progress tracker to check the operations end")
        public int package_progress_wait() default 10;
    }

    protected class PackageManagerCallable
    extends AbstractJobExecutor.UserContextCallable {
        public PackageManagerCallable(Job job, JobExecutionContext context, ResourceResolver serviceResolver, PrintWriter out) throws RepositoryException, LoginException {
            super((AbstractJobExecutor)PackageJobExecutor.this, job, context, serviceResolver, out);
        }

        public String call() throws Exception {
            PackageJobExecutor.this.lock.lock();
            try {
                JcrPackageManager manager = PackageJobExecutor.this.packaging.getPackageManager(this.session);
                JcrPackage jcrPckg = this.getJcrPackage(this.job, manager);
                String operation = (String)this.job.getProperty("operation");
                if (StringUtils.isNotBlank((CharSequence)operation)) {
                    switch (operation.toLowerCase()) {
                        case "install": {
                            String name = jcrPckg.getPackage().getId().getName();
                            LOG.info("start of installation of package '{}'", (Object)name);
                            String call = new InstallOperation(manager, jcrPckg).call();
                            LOG.info("installation of package '{}' done", (Object)name);
                            String string = call;
                            return string;
                        }
                        case "assemble": {
                            String string = new AssembleOperation(manager, jcrPckg).call();
                            return string;
                        }
                        case "uninstall": {
                            String string = new UninstallOperation(manager, jcrPckg).call();
                            return string;
                        }
                    }
                    throw new Exception("Unsupported operation: " + operation);
                }
                throw new Exception("No operation requested!");
            }
            finally {
                PackageJobExecutor.this.lock.unlock();
                this.close();
            }
        }

        protected ImportOptions createImportOptions() {
            ImportOptions options = new ImportOptions();
            options.setDryRun(((Boolean)PackageJobExecutor.this.getProperty(this.job, PackageJobExecutor.JOB_PROPERTY_DRY_RUN, false)).booleanValue());
            options.setAutoSaveThreshold(((Integer)PackageJobExecutor.this.getProperty(this.job, PackageJobExecutor.JOB_PROPERTY_SAVE_THRESHOLD, PackageJobExecutor.this.config.package_save_threshold())).intValue());
            options.setImportMode((ImportMode)PackageJobExecutor.this.getProperty(this.job, PackageJobExecutor.JOB_PROPERTY_IMPORT_MODE, ImportMode.REPLACE));
            options.setHookClassLoader(PackageJobExecutor.this.getDynamicClassLoaderManager().getDynamicClassLoader());
            options.setDependencyHandling(DependencyHandling.BEST_EFFORT);
            return options;
        }

        protected JcrPackage getJcrPackage(Job job, JcrPackageManager manager) throws RepositoryException {
            JcrPackage jcrPackage = null;
            Node pckgRoot = manager.getPackageRoot();
            if (pckgRoot != null) {
                String reference = (String)job.getProperty("reference");
                while (reference.startsWith("/")) {
                    reference = reference.substring(1);
                }
                Node pckgNode = pckgRoot.getNode(reference);
                if (pckgNode != null) {
                    jcrPackage = manager.open(pckgNode, true);
                }
            }
            return jcrPackage;
        }

        protected class OperationDoneTracker
        extends PackageProgressTracker.TextWriterTracking {
            protected boolean operationDone;
            protected int waitLoopCount;

            public OperationDoneTracker(PrintWriter writer, Pattern finalizedIndicator) {
                super(writer, finalizedIndicator);
            }

            public boolean isOperationDone() {
                return this.operationDone || ++this.waitLoopCount > PackageJobExecutor.this.config.package_progress_wait() * 2;
            }

            @Override
            public void writeEpilogue() throws IOException {
                super.writeEpilogue();
                this.operationDone = true;
            }

            @Override
            protected void writeItem(PackageProgressTracker.Item item) throws IOException {
                super.writeItem(item);
                this.waitLoopCount = 0;
            }
        }

        protected abstract class TrackedOperation
        extends Operation {
            public TrackedOperation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                super(manager, jcrPckg);
            }

            @Override
            protected void track() {
                while (!this.tracker.isOperationDone()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException iex) {
                        LOG.info("Operation track interrupted: " + iex.getMessage());
                    }
                }
            }
        }

        protected abstract class Operation
        implements Callable<String> {
            public final JcrPackageManager manager;
            public final JcrPackage jcrPckg;
            public final ImportOptions options;
            public final OperationDoneTracker tracker;

            public Operation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                this.manager = manager;
                this.jcrPckg = jcrPckg;
                this.tracker = new OperationDoneTracker(PackageManagerCallable.this.out, PackageUtil.IMPORT_DONE);
                this.options = PackageManagerCallable.this.createImportOptions();
                this.options.setListener((ProgressTrackerListener)this.tracker);
            }

            protected abstract void doIt() throws PackageException, IOException, RepositoryException;

            protected void track() {
            }

            protected String done() throws IOException {
                return "done.";
            }

            @Override
            public String call() throws IOException, RepositoryException {
                this.tracker.writePrologue();
                try {
                    this.doIt();
                    this.track();
                    return this.done();
                }
                catch (PackageException pex) {
                    LOG.error(pex.getMessage(), (Throwable)pex);
                    throw new RepositoryException((Throwable)pex);
                }
            }
        }

        protected class UninstallOperation
        extends TrackedOperation {
            public UninstallOperation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                super(manager, jcrPckg);
            }

            @Override
            protected void doIt() throws PackageException, IOException, RepositoryException {
                this.jcrPckg.uninstall(this.options);
            }

            @Override
            protected String done() throws IOException {
                return "Package uninstall done.";
            }
        }

        protected class AssembleOperation
        extends Operation {
            public AssembleOperation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                super(manager, jcrPckg);
            }

            @Override
            protected void doIt() throws PackageException, IOException, RepositoryException {
                this.manager.assemble(this.jcrPckg, (ProgressTrackerListener)this.tracker);
            }

            @Override
            protected String done() throws IOException {
                return "Package assembled.";
            }
        }

        protected class InstallOperation
        extends TrackedOperation {
            public InstallOperation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                super(manager, jcrPckg);
            }

            @Override
            protected void doIt() throws PackageException, IOException, RepositoryException {
                this.jcrPckg.install(this.options);
            }

            @Override
            protected String done() throws IOException {
                if (this.tracker.getErrorDetected()) {
                    throw new JobFailureException("install done with errors");
                }
                return super.done();
            }
        }
    }
}

