/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.concurrent.JobFacade;
import com.composum.sling.core.concurrent.JobMonitor;
import com.composum.sling.core.concurrent.JobUtil;
import com.composum.sling.core.pckgmgr.util.PackageProgressTracker;
import com.composum.sling.core.pckgmgr.util.PackageUtil;
import com.composum.sling.core.service.RestrictedService;
import com.composum.sling.core.service.ServiceRestrictions;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.util.RequestUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.NodesConfiguration;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.Filter;
import org.apache.jackrabbit.vault.fs.api.FilterSet;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.fs.filter.DefaultPathFilter;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.JobManager;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
@Component(service={Servlet.class, RestrictedService.class}, property={"service.description=Composum Nodes Package Servlet", "sling.servlet.paths=/bin/cpm/package", "sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.methods=PUT", "sling.servlet.methods=DELETE", "sling.auth.requirements=/bin/cpm/package"})
@Designate(ocd=Configuration.class)
public class PackageServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PackageServlet.class);
    public static final String SERVICE_KEY = "nodes/packages/manager";
    public static final String SERVLET_PATH = "/bin/cpm/package";
    public static final String PARAM_GROUP = "group";
    public static final String PARAM_FORCE = "force";
    private volatile long jobIdleTimeout;
    public static final String ZIP_CONTENT_TYPE = "application/zip";
    public static final boolean AUTO_SAVE = true;
    @Reference
    private ServiceRestrictions restrictions;
    @Reference
    private NodesConfiguration nodesConfig;
    @Reference
    private JobManager jobManager;
    @Reference
    private Packaging packaging;
    protected PackageOperationSet operations = new PackageOperationSet();

    @Activate
    @Modified
    protected void activate(Configuration configuration) {
        this.jobIdleTimeout = configuration.package_job_timeout();
    }

    protected ServletOperationSet getOperations() {
        return this.operations;
    }

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.list, new ListOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.tree, new TreeOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.query, new QueryOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.filterList, new ListFiltersOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.coverage, new CoverageOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.zip, Operation.download, new DownloadOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.html, Operation.download, new DownloadOperation());
        this.operations.setOperation(ServletOperationSet.Method.GET, Extension.json, Operation.cleanup, new CleanupOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.service, new ServiceOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.create, new CreateOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.update, new UpdateOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.upload, new UploadOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.install, new InstallOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.uninstall, new UninstallOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.json, Operation.deploy, new ServiceOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterChange, new ChangeFilterOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterAdd, new AddFilterOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterRemove, new RemoveFilterOperation());
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterMoveUp, new MoveFilterOperation(true));
        this.operations.setOperation(ServletOperationSet.Method.POST, Extension.html, Operation.filterMoveDown, new MoveFilterOperation(false));
        this.operations.setOperation(ServletOperationSet.Method.PUT, Extension.json, Operation.update, new JsonUpdateOperation());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, Extension.json, Operation.delete, new DeleteOperation());
    }

    protected static void jsonAnswer(JsonWriter writer, String operation, String status, JcrPackageManager pckgMgr, JcrPackage jcrPackage) throws IOException, RepositoryException {
        writer.beginObject();
        writer.name("operation").value(operation);
        writer.name("status").value(status);
        writer.name("path").value(PackageUtil.getPackagePath(pckgMgr, jcrPackage));
        writer.name("package");
        PackageUtil.toJson(writer, jcrPackage, null);
        writer.endObject();
    }

    protected static void fromJson(JsonReader reader, JcrPackage jcrPackage) throws RepositoryException, IOException {
        reader.beginObject();
        block6: while (reader.hasNext() && reader.peek() == JsonToken.NAME) {
            String name;
            switch (name = reader.nextName()) {
                case "definition": {
                    PackageServlet.fromJson(reader, jcrPackage.getDefinition());
                    continue block6;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    protected static void fromJson(JsonReader reader, JcrPackageDefinition definition) throws IOException {
        reader.beginObject();
        block10: while (reader.hasNext() && reader.peek() == JsonToken.NAME) {
            String name;
            switch (name = reader.nextName()) {
                case "filter": {
                    DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
                    PathFilterSet pathFilterSet = new PathFilterSet();
                    filter.add(pathFilterSet);
                    continue block10;
                }
            }
            switch (reader.peek()) {
                case STRING: {
                    String strVal = reader.nextString();
                    definition.set(name, strVal, true);
                    continue block10;
                }
                case BOOLEAN: {
                    boolean boolVal = reader.nextBoolean();
                    definition.set(name, boolVal, true);
                    continue block10;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
    }

    @ObjectClassDefinition(name="Composum Nodes Package Servlet")
    public static @interface Configuration {
        @AttributeDefinition(name="package job timeout", description="Time in milliseconds a package job can be idle")
        public long package_job_timeout() default 60000L;
    }

    protected class MoveFilterOperation
    implements ServletOperation {
        public final boolean up;

        public MoveFilterOperation(boolean up) {
            this.up = up;
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            int index = filterRequest.index;
            if (index >= 0 && index < filterRequest.filters.size()) {
                if (this.up) {
                    if (index > 0) {
                        this.move(filterRequest, index - 1);
                    }
                } else if (index < filterRequest.filters.size() - 1) {
                    this.move(filterRequest, index + 1);
                }
                response.setStatus(200);
                response.setContentLength(0);
            } else {
                response.sendError(400, "invalid filter index '" + index + "'");
            }
        }

        protected void move(FilterRequest filterRequest, int newIndex) {
            PathFilterSet filter = filterRequest.filters.remove(filterRequest.index);
            filterRequest.filters.add(newIndex, filter);
            filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
        }
    }

    protected class RemoveFilterOperation
    implements ServletOperation {
        protected RemoveFilterOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            int index = filterRequest.index;
            if (index >= 0 && index < filterRequest.filters.size()) {
                filterRequest.filters.remove(index);
                filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
                PackageUtil.setLastModified(filterRequest.definition);
                response.setStatus(200);
                response.setContentLength(0);
            } else {
                response.sendError(400, "invalid filter index '" + index + "'");
            }
        }
    }

    protected class AddFilterOperation
    implements ServletOperation {
        protected AddFilterOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            if (filterRequest.filter != null) {
                int index = filterRequest.index;
                if (index < 0 || index > filterRequest.filters.size()) {
                    index = filterRequest.filters.size();
                }
                filterRequest.filters.add(index, filterRequest.filter);
                filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
                PackageUtil.setLastModified(filterRequest.definition);
                response.setStatus(200);
                response.setContentLength(0);
            } else {
                response.sendError(400, "invalid filter");
            }
        }
    }

    protected class ChangeFilterOperation
    implements ServletOperation {
        protected ChangeFilterOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            FilterRequest filterRequest = new FilterRequest(request, (Resource)resource);
            if (filterRequest.filter != null) {
                int index = filterRequest.index;
                if (index >= 0 && index < filterRequest.filters.size()) {
                    filterRequest.filters.set(index, filterRequest.filter);
                    filterRequest.definition.setFilter(filterRequest.workspaceFilter, true);
                    PackageUtil.setLastModified(filterRequest.definition);
                    response.setStatus(200);
                    response.setContentLength(0);
                } else {
                    response.sendError(400, "invalid filter index '" + index + "'");
                }
            } else {
                response.sendError(400, "invalid filter");
            }
        }
    }

    protected class FilterRequest {
        public final SlingHttpServletRequest request;
        public final JcrPackageManager manager;
        public final JcrPackage jcrPackage;
        public final JcrPackageDefinition definition;
        public final MetaInf metaInf;
        public final WorkspaceFilter workspaceFilter;
        public final List<PathFilterSet> filters;
        public final int index;
        public final PathFilterSet filter;

        public FilterRequest(SlingHttpServletRequest request, Resource resource) throws RepositoryException {
            this.request = request;
            this.manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            this.jcrPackage = PackageUtil.getJcrPackage(this.manager, resource);
            this.definition = this.jcrPackage.getDefinition();
            this.metaInf = this.definition.getMetaInf();
            this.workspaceFilter = this.metaInf.getFilter();
            this.filters = this.workspaceFilter.getFilterSets();
            this.index = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)"index", (Integer)-1);
            String root = XSS.filter((String)request.getParameter("root"));
            if (StringUtils.isNotBlank((CharSequence)root)) {
                this.filter = new PathFilterSet(root);
                String importMode = XSS.filter((String)request.getParameter("importMode"));
                if (StringUtils.isNotBlank((CharSequence)importMode)) {
                    ImportMode mode = ImportMode.valueOf((String)importMode.toUpperCase());
                    this.filter.setImportMode(mode);
                }
                String[] ruleTypes = XSS.filter((String[])request.getParameterValues("ruleType"));
                String[] ruleExpressions = XSS.filter((String[])request.getParameterValues("ruleExpression"));
                if (ruleTypes != null && ruleExpressions != null && ruleTypes.length == ruleExpressions.length) {
                    block8: for (int i = 0; i < ruleTypes.length; ++i) {
                        if (!StringUtils.isNotBlank((CharSequence)ruleExpressions[i])) continue;
                        switch (ruleTypes[i]) {
                            case "include": {
                                this.filter.addInclude((Filter)new DefaultPathFilter(ruleExpressions[i]));
                                continue block8;
                            }
                            case "exclude": {
                                this.filter.addExclude((Filter)new DefaultPathFilter(ruleExpressions[i]));
                            }
                        }
                    }
                }
            } else {
                this.filter = null;
            }
        }
    }

    protected class ListFiltersOperation
    implements ServletOperation {
        protected ListFiltersOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            Session session = RequestUtil.getSession((SlingHttpServletRequest)request);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            List<PathFilterSet> filters = PackageUtil.getFilterList(jcrPackage.getDefinition());
            for (PathFilterSet filter : filters) {
                List filterRules;
                writer.beginObject();
                writer.name("root").value(filter.getRoot());
                ImportMode importMode = filter.getImportMode();
                if (importMode != null) {
                    writer.name("importMode").value(importMode.name());
                }
                if (!(filterRules = filter.getEntries()).isEmpty()) {
                    writer.name("rules").beginArray();
                    for (FilterSet.Entry entry : filterRules) {
                        writer.beginObject();
                        writer.name("type").value(entry.isInclude() ? "include" : "exclude");
                        writer.name("pattern").value(((DefaultPathFilter)entry.getFilter()).getPattern());
                        writer.endObject();
                    }
                    writer.endArray();
                }
                writer.endObject();
            }
            writer.endArray();
        }
    }

    protected class CoverageOperation
    implements ServletOperation {
        protected CoverageOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            Session session = RequestUtil.getSession((SlingHttpServletRequest)request);
            PackageProgressTracker.JsonTracking tracker = new PackageProgressTracker.JsonTracking(response, null);
            ((PackageProgressTracker)tracker).writePrologue();
            PackageUtil.getCoverage(jcrPackage.getDefinition(), session, tracker);
            ((PackageProgressTracker)tracker).writeEpilogue();
        }
    }

    protected class ServiceOperation
    extends InstallOperation {
        protected ServiceOperation() {
        }

        @Override
        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            RequestParameterMap parameters = request.getRequestParameterMap();
            RequestParameter cmd = parameters.getValue("cmd");
            if (cmd != null && !StringUtils.isBlank((CharSequence)cmd.getString())) {
                switch (cmd.getString()) {
                    case "ls": {
                        new LsCommand().doCommand(request, response, parameters);
                        break;
                    }
                    case "rm": {
                        new RmCommand().doCommand(request, response, parameters);
                        break;
                    }
                    case "build": {
                        new BuildCommand().doCommand(request, response, parameters);
                        break;
                    }
                    case "uninst": {
                        new UninstCommand().doCommand(request, response, parameters);
                        break;
                    }
                    default: {
                        LOG.warn("unsupported command '{}' received. will ignore it.", (Object)cmd);
                        break;
                    }
                }
            } else {
                RequestParameter file = parameters.getValue("file");
                if (file != null) {
                    InputStream input = file.getInputStream();
                    boolean force = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)PackageServlet.PARAM_FORCE, (Boolean)true);
                    JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                    JcrPackage jcrPackage = manager.upload(input, force);
                    this.installPackage(request, response, manager, jcrPackage);
                } else {
                    response.sendError(400, "no package file accessible");
                }
            }
        }

        @Override
        protected void installationDone(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage, JobMonitor jobMonitor) throws RepositoryException, IOException {
            response.setStatus(200);
            try (PrintWriter writer = response.getWriter();){
                ((Writer)writer).append("<repo>");
                ((Writer)writer).append("<response>");
                ((Writer)writer).append("<data>");
                ((Writer)writer).append(PackageUtil.packageToXMLResponse(jcrPackage));
                ((Writer)writer).append("</data>");
                if (jobMonitor.succeeded()) {
                    ((Writer)writer).append(this.createStatusElement("200", "ok"));
                } else {
                    JobFacade jobFacade = jobMonitor.getJob();
                    String msg = jobFacade != null ? jobFacade.getResultMessage() : "no job found";
                    ((Writer)writer).append(this.createStatusElement("500", msg));
                }
                ((Writer)writer).append("</response>");
                ((Writer)writer).append("</repo>");
            }
        }

        private String createRequestElement(String cmd, String name, String group) {
            return "<request>" + this.createParameterElement("cmd", cmd) + (StringUtils.isBlank((CharSequence)name) ? "" : this.createParameterElement("name", name)) + (StringUtils.isBlank((CharSequence)group) ? "" : this.createParameterElement(PackageServlet.PARAM_GROUP, group)) + "</request>";
        }

        private String createParameterElement(String name, String value) {
            return "<param name=\"" + name + "\" value=\"" + value + "\"/>";
        }

        private String createResponseElement(String code, String message) {
            return "<response>" + this.createStatusElement(code, message) + "</response>";
        }

        private String createStatusElement(String code, String message) {
            return "<status code=\"" + code + "\">" + message + "</status>";
        }

        class UninstCommand
        extends BuildUninstCommand {
            UninstCommand() {
            }

            @Override
            String getCommand() {
                return "uninst";
            }

            @Override
            String getOperation() {
                return "uninstall";
            }
        }

        class BuildCommand
        extends BuildUninstCommand {
            BuildCommand() {
            }

            @Override
            String getCommand() {
                return "build";
            }

            @Override
            String getOperation() {
                return "assemble";
            }
        }

        abstract class BuildUninstCommand
        extends ServiceCommand {
            BuildUninstCommand() {
            }

            abstract String getCommand();

            abstract String getOperation();

            @Override
            void doCommand(SlingHttpServletRequest request, SlingHttpServletResponse response, RequestParameterMap parameters) throws RepositoryException, IOException {
                ResourceResolver resolver = request.getResourceResolver();
                Session session = (Session)resolver.adaptTo(Session.class);
                String name = this.getName(parameters);
                String group = this.getGroup(parameters);
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, group, name);
                if (jcrPackage != null) {
                    String root;
                    String path = jcrPackage.getNode().getPath();
                    if (path.startsWith(root = manager.getPackageRoot().getPath())) {
                        path = path.substring(root.length());
                    }
                    HashMap<String, String> jobProperties = new HashMap<String, String>();
                    jobProperties.put("reference", path);
                    jobProperties.put("operation", this.getOperation());
                    jobProperties.put("userid", session.getUserID());
                    JobUtil.buildOutfileName(jobProperties);
                    Job job = PackageServlet.this.jobManager.addJob("com/composum/sling/core/pckgmgr/PackageJobExecutor", jobProperties);
                    JobMonitor.IsDone isDone = new JobMonitor.IsDone(PackageServlet.this.jobManager, resolver, job.getId(), PackageServlet.this.jobIdleTimeout);
                    if (isDone.call().booleanValue()) {
                        response.setStatus(200);
                        try (PrintWriter writer = response.getWriter();){
                            ((Writer)writer).append("<repo>");
                            ((Writer)writer).append(ServiceOperation.this.createRequestElement(this.getCommand(), name, group));
                            if (isDone.succeeded()) {
                                ((Writer)writer).append(ServiceOperation.this.createResponseElement("200", "ok"));
                            } else {
                                ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", this.getOperation() + " does not succeed"));
                            }
                            ((Writer)writer).append("</repo>");
                        }
                    } else {
                        response.setStatus(200);
                        try (PrintWriter writer = response.getWriter();){
                            ((Writer)writer).append("<repo>");
                            ((Writer)writer).append(ServiceOperation.this.createRequestElement(this.getCommand(), name, group));
                            ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", "nok"));
                            ((Writer)writer).append("</repo>");
                        }
                    }
                } else {
                    response.setStatus(200);
                    try (PrintWriter writer = response.getWriter();){
                        ((Writer)writer).append("<repo>");
                        ((Writer)writer).append(ServiceOperation.this.createRequestElement(this.getCommand(), name, group));
                        ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", "Package '" + group + ":" + name + "' does not exist"));
                        ((Writer)writer).append("</repo>");
                    }
                }
            }
        }

        class RmCommand
        extends ServiceCommand {
            RmCommand() {
            }

            @Override
            void doCommand(SlingHttpServletRequest request, SlingHttpServletResponse response, RequestParameterMap parameters) throws RepositoryException, IOException {
                String name = this.getName(parameters);
                String group = this.getGroup(parameters);
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                List jcrPackages = manager.listPackages();
                boolean found = false;
                for (JcrPackage jcrPackage : jcrPackages) {
                    String packageName = jcrPackage.getDefinition().get("name");
                    String packageGroup = jcrPackage.getDefinition().get(PackageServlet.PARAM_GROUP);
                    if (StringUtils.isBlank((CharSequence)packageName) || !packageName.equals(name)) continue;
                    if (!StringUtils.isBlank((CharSequence)group) && group.equals(packageGroup)) {
                        manager.remove(jcrPackage);
                        found = true;
                        break;
                    }
                    if (!StringUtils.isBlank((CharSequence)group) || !StringUtils.isBlank((CharSequence)packageGroup)) continue;
                    manager.remove(jcrPackage);
                    found = true;
                    break;
                }
                response.setStatus(200);
                try (PrintWriter writer = response.getWriter();){
                    ((Writer)writer).append("<repo>");
                    ((Writer)writer).append(ServiceOperation.this.createRequestElement("rm", name, group));
                    if (found) {
                        ((Writer)writer).append(ServiceOperation.this.createResponseElement("200", "ok"));
                    } else {
                        ((Writer)writer).append(ServiceOperation.this.createResponseElement("500", "Package '" + group + ":" + name + "' does not exist."));
                    }
                    ((Writer)writer).append("</repo>");
                }
            }
        }

        class LsCommand
        extends ServiceCommand {
            LsCommand() {
            }

            @Override
            void doCommand(SlingHttpServletRequest request, SlingHttpServletResponse response, RequestParameterMap parameters) throws RepositoryException, IOException {
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                List jcrPackages = manager.listPackages();
                response.setStatus(200);
                try (PrintWriter writer = response.getWriter();){
                    ((Writer)writer).append("<repo>");
                    ((Writer)writer).append(ServiceOperation.this.createRequestElement("ls", "", ""));
                    ((Writer)writer).append("<response>");
                    ((Writer)writer).append("<data>");
                    ((Writer)writer).append("<packages>");
                    for (JcrPackage jcrPackage : jcrPackages) {
                        ((Writer)writer).append(PackageUtil.packageToXMLResponse(jcrPackage));
                    }
                    ((Writer)writer).append("</packages>");
                    ((Writer)writer).append("</data>");
                    ((Writer)writer).append(ServiceOperation.this.createStatusElement("200", "ok"));
                    ((Writer)writer).append("</response>");
                    ((Writer)writer).append("</repo>");
                }
            }
        }

        abstract class ServiceCommand {
            ServiceCommand() {
            }

            abstract void doCommand(SlingHttpServletRequest var1, SlingHttpServletResponse var2, RequestParameterMap var3) throws RepositoryException, IOException;

            String getGroup(RequestParameterMap parameters) throws UnsupportedEncodingException {
                RequestParameter groupParameter = parameters.getValue(PackageServlet.PARAM_GROUP);
                String group = null;
                if (groupParameter != null) {
                    group = groupParameter.getString("UTF-8");
                }
                return group;
            }

            String getName(RequestParameterMap parameters) throws UnsupportedEncodingException {
                RequestParameter nameParameter = parameters.getValue("name");
                String name = "";
                if (nameParameter != null) {
                    name = nameParameter.getString("UTF-8");
                }
                return name;
            }
        }
    }

    protected class UninstallOperation
    implements ServletOperation {
        protected UninstallOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            this.uninstallPackage(request, response, manager, jcrPackage);
        }

        protected void uninstallPackage(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage) throws RepositoryException, IOException {
            String root;
            ResourceResolver resolver = request.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            String path = jcrPackage.getNode().getPath();
            if (path.startsWith(root = manager.getPackageRoot().getPath())) {
                path = path.substring(root.length());
            }
            HashMap<String, String> jobProperties = new HashMap<String, String>();
            jobProperties.put("reference", path);
            jobProperties.put("operation", "uninstall");
            jobProperties.put("userid", session.getUserID());
            JobUtil.buildOutfileName(jobProperties);
            Job job = PackageServlet.this.jobManager.addJob("com/composum/sling/core/pckgmgr/PackageJobExecutor", jobProperties);
            JobMonitor.IsDone isDone = new JobMonitor.IsDone(PackageServlet.this.jobManager, resolver, job.getId(), PackageServlet.this.jobIdleTimeout);
            if (isDone.call().booleanValue()) {
                this.uninstallationDone(request, response, manager, jcrPackage, (JobMonitor)isDone);
            } else {
                response.sendError(500, "Package uninstall not started!");
            }
        }

        protected void uninstallationDone(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage, JobMonitor jobMonitor) throws RepositoryException, IOException {
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            PackageServlet.jsonAnswer(writer, "uninstallation", "done", manager, jcrPackage);
        }
    }

    protected class InstallOperation
    implements ServletOperation {
        protected InstallOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            this.installPackage(request, response, manager, jcrPackage);
        }

        protected void installPackage(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage) throws RepositoryException, IOException {
            String root;
            ResourceResolver resolver = request.getResourceResolver();
            Session session = (Session)resolver.adaptTo(Session.class);
            String path = jcrPackage.getNode().getPath();
            if (path.startsWith(root = manager.getPackageRoot().getPath())) {
                path = path.substring(root.length());
            }
            HashMap<String, String> jobProperties = new HashMap<String, String>();
            jobProperties.put("reference", path);
            jobProperties.put("operation", "install");
            jobProperties.put("userid", session.getUserID());
            JobUtil.buildOutfileName(jobProperties);
            Job job = PackageServlet.this.jobManager.addJob("com/composum/sling/core/pckgmgr/PackageJobExecutor", jobProperties);
            JobMonitor.IsDone isDone = new JobMonitor.IsDone(PackageServlet.this.jobManager, resolver, job.getId(), PackageServlet.this.jobIdleTimeout);
            if (isDone.call().booleanValue()) {
                this.installationDone(request, response, manager, jcrPackage, (JobMonitor)isDone);
            } else {
                LOG.error("Job was not yet executed: {}", (Object)job);
                response.sendError(500, "Package install not started!");
            }
        }

        protected void installationDone(SlingHttpServletRequest request, SlingHttpServletResponse response, JcrPackageManager manager, JcrPackage jcrPackage, JobMonitor jobMonitor) throws RepositoryException, IOException {
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            PackageServlet.jsonAnswer(writer, "installation", "done", manager, jcrPackage);
        }
    }

    protected class CleanupOperation
    implements ServletOperation {
        protected CleanupOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            LOG.warn("package service cleanup...");
            JsonWriter writer = new JsonWriter((Writer)response.getWriter());
            writer.beginObject();
            writer.name("removedJobs").beginArray();
            for (Job job : PackageServlet.this.jobManager.findJobs(JobManager.QueryType.ALL, "com/composum/sling/core/pckgmgr/PackageJobExecutor", 0L, new Map[0])) {
                String created = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss").format(job.getCreated().getTime());
                LOG.warn("package service cleanup: remove job: {}, {}, {}, '{}', {}, {}", new Object[]{job.getId(), job.getTopic(), created, job.getResultMessage(), job.getRetryCount(), job.getQueueName()});
                writer.beginObject();
                writer.name("id").value(job.getId());
                writer.name("topic").value(job.getTopic());
                writer.name("created").value(created);
                writer.name("result").value(job.getResultMessage());
                writer.name("retryCount").value((long)job.getRetryCount());
                writer.name("queue").value(job.getQueueName());
                writer.endObject();
                PackageServlet.this.jobManager.removeJobById(job.getId());
            }
            writer.endArray();
            LOG.warn("package service cleanup ends.");
        }
    }

    protected class UploadOperation
    implements ServletOperation {
        protected UploadOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            RequestParameterMap parameters = request.getRequestParameterMap();
            RequestParameter file = parameters.getValue("file");
            if (file != null) {
                InputStream input = file.getInputStream();
                boolean force = RequestUtil.getParameter((SlingHttpServletRequest)request, (String)PackageServlet.PARAM_FORCE, (Boolean)false);
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                JcrPackage jcrPackage = manager.upload(input, force);
                JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                PackageServlet.jsonAnswer(writer, "upload", "successful", manager, jcrPackage);
            } else {
                response.sendError(400, "no package file accessible");
            }
        }
    }

    protected class DownloadOperation
    implements ServletOperation {
        protected DownloadOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            if (jcrPackage != null) {
                InputStream stream;
                Binary binary;
                Property data = jcrPackage.getData();
                if (data != null && (binary = data.getBinary()) != null && (stream = binary.getStream()) != null) {
                    PackageUtil.PackageItem item = new PackageUtil.PackageItem(jcrPackage);
                    response.setHeader("Content-Disposition", "inline; filename=" + item.getFilename());
                    Calendar lastModified = item.getLastModified();
                    if (lastModified != null) {
                        response.setDateHeader("Last-Modified", lastModified.getTimeInMillis());
                    }
                    response.setContentType(PackageServlet.ZIP_CONTENT_TYPE);
                    ServletOutputStream output = response.getOutputStream();
                    IOUtils.copy((InputStream)stream, (OutputStream)output);
                } else {
                    response.sendError(400, PackageUtil.getPath(request) + " is not a package or has no content");
                }
            } else {
                response.sendError(400, PackageUtil.getPath(request) + " can not be found in the repository");
            }
        }
    }

    protected class DeleteOperation
    implements ServletOperation {
        protected DeleteOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
            if (jcrPackage != null) {
                manager.remove(jcrPackage);
                JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                PackageServlet.jsonAnswer(writer, "delete", "successful", manager, jcrPackage);
            }
        }
    }

    protected class JsonUpdateOperation
    extends UpdateOperation {
        protected JsonUpdateOperation() {
        }

        @Override
        protected Map<String, Object> getParameters(SlingHttpServletRequest request) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)request.getInputStream(), StandardCharsets.UTF_8));
            reader.setLenient(true);
            reader.beginObject();
            while (reader.peek() != JsonToken.END_OBJECT) {
                String key = reader.nextName();
                PackageUtil.DefinitionSetter setter = PackageUtil.DEFINITION_SETTERS.get(key);
                if (setter != null) {
                    result.put(key, setter.get(reader));
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            reader.close();
            return result;
        }
    }

    protected class UpdateOperation
    implements ServletOperation {
        protected UpdateOperation() {
        }

        protected Map<String, Object> getParameters(SlingHttpServletRequest request) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            RequestParameterMap parameters = request.getRequestParameterMap();
            for (Map.Entry parameter : parameters.entrySet()) {
                String[] value;
                String key = (String)parameter.getKey();
                RequestParameter[] param = (RequestParameter[])parameter.getValue();
                if (param.length > 1) {
                    String[] values = new String[param.length];
                    for (int i = 0; i < param.length; ++i) {
                        values[i] = XSS.filter((String)param[i].getString());
                    }
                    value = values;
                } else {
                    value = param.length < 1 ? Boolean.TRUE : XSS.filter((String)param[0].getString());
                }
                result.put(key, value);
            }
            return result;
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            try {
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, (Resource)resource);
                if (jcrPackage != null) {
                    JcrPackageDefinition pckgDef = jcrPackage.getDefinition();
                    String group = XSS.filter((String)request.getParameter(PackageServlet.PARAM_GROUP));
                    String name = XSS.filter((String)request.getParameter("name"));
                    String version = XSS.filter((String)request.getParameter("version"));
                    if (!(!StringUtils.isNotBlank((CharSequence)name) || PackageUtil.isGroup(pckgDef, group) && PackageUtil.isName(pckgDef, name) && PackageUtil.isVersion(pckgDef, version))) {
                        manager.rename(jcrPackage, group, name, version);
                    }
                    Map<String, Object> parameters = this.getParameters(request);
                    parameters.put("includeVersions", parameters.containsKey("includeVersions"));
                    for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
                        String key = parameter.getKey();
                        PackageUtil.DefinitionSetter setter = PackageUtil.DEFINITION_SETTERS.get(key);
                        if (setter == null) continue;
                        Object value = parameter.getValue();
                        try {
                            setter.set(pckgDef, key, value, true);
                        }
                        catch (ParseException ex) {
                            LOG.error("can't parse '" + key + "'='" + value + "' (" + ex.toString() + ")");
                        }
                    }
                    JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
                    PackageServlet.jsonAnswer(writer, "update", "successful", manager, jcrPackage);
                } else {
                    response.sendError(404, "Package not found: " + PackageUtil.getPath(request));
                }
            }
            catch (PackageException pex) {
                LOG.error(pex.getMessage(), (Throwable)pex);
                throw new RepositoryException((Throwable)pex);
            }
        }
    }

    protected class CreateOperation
    implements ServletOperation {
        protected CreateOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            String group = XSS.filter((String)request.getParameter(PackageServlet.PARAM_GROUP));
            String name = XSS.filter((String)request.getParameter("name"));
            String version = XSS.filter((String)request.getParameter("version"));
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            JcrPackage jcrPackage = manager.create(group, name, version);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            PackageServlet.jsonAnswer(writer, "create", "successful", manager, jcrPackage);
        }
    }

    protected class QueryOperation
    implements ServletOperation {
        protected QueryOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            String suffix = XSS.filter((String)request.getRequestPathInfo().getSuffix());
            if (suffix.startsWith("/")) {
                suffix = suffix.substring(1);
            }
            suffix = suffix.replaceAll("[ '\"]", "").trim();
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            if (suffix.length() > 1) {
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                ResourceResolver resolver = request.getResourceResolver();
                String rootPath = manager.getPackageRoot().getPath();
                Iterator found = resolver.findResources("/jcr:root" + rootPath + "//element(*,vlt:PackageDefinition)[jcr:contains(.,'" + suffix + "')]/../..", "xpath");
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
                while (found.hasNext()) {
                    JcrPackageDefinition pckgDef;
                    String group;
                    JcrPackage jcrPckg = PackageUtil.getJcrPackage(manager, (Resource)found.next());
                    if (jcrPckg == null || (group = (pckgDef = jcrPckg.getDefinition()).get(PackageServlet.PARAM_GROUP)).endsWith("/.snapshot")) continue;
                    writer.beginObject();
                    writer.name("state").beginObject();
                    writer.name("installed").value(jcrPckg.isInstalled() ? "on" : "off");
                    writer.name("sealed").value(jcrPckg.isSealed() ? "on" : "off");
                    writer.name("valid").value(jcrPckg.isValid() ? "on" : "off");
                    writer.endObject();
                    writer.name(PackageServlet.PARAM_GROUP).value(group);
                    writer.name("name").value(pckgDef.get("name"));
                    writer.name("version").value(pckgDef.get("version"));
                    writer.name("lastModified").value(dateFormat.format(PackageUtil.getLastModified(jcrPckg).getTime()));
                    writer.name("path").value(PackageUtil.getPackagePath(manager, jcrPckg));
                    writer.endObject();
                }
            }
            writer.endArray();
        }
    }

    protected class TreeOperation
    implements ServletOperation {
        protected TreeOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            PackageUtil.TreeNode treeNode = PackageUtil.getTreeNode(manager, request);
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            treeNode.sort();
            treeNode.toJson(writer);
        }
    }

    protected class ListOperation
    implements ServletOperation {
        protected ListOperation() {
        }

        public void doIt(SlingHttpServletRequest request, SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
            List jcrPackages = manager.listPackages();
            JsonWriter writer = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);
            writer.beginArray();
            for (JcrPackage jcrPackage : jcrPackages) {
                new PackageUtil.PackageItem(jcrPackage).toJson(writer);
            }
            writer.endArray();
        }
    }

    public class PackageOperationSet
    extends ServletOperationSet<Extension, Operation> {
        public PackageOperationSet() {
            super((Enum)Extension.json);
        }

        public ResourceHandle getResource(SlingHttpServletRequest request) {
            Resource resource = null;
            try {
                String path = PackageUtil.getPath(request);
                JcrPackageManager manager = PackageUtil.getPackageManager(PackageServlet.this.packaging, request);
                resource = PackageUtil.getResource(manager, request, path);
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
            return ResourceHandle.use(resource);
        }
    }

    public static enum Operation {
        create,
        update,
        delete,
        download,
        upload,
        install,
        uninstall,
        deploy,
        service,
        list,
        tree,
        view,
        query,
        coverage,
        filterList,
        filterChange,
        filterAdd,
        filterRemove,
        filterMoveUp,
        filterMoveDown,
        cleanup;

    }

    public static enum Extension {
        html,
        json,
        zip;

    }
}

