/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.util;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.util.JsonUtil;
import com.composum.sling.core.util.XSS;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.el.PropertyNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.MetaInf;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PackageUtil.class);
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String THUMBNAIL_PNG = "thumbnail.png";
    public static final String DEF_AC_HANDLING = "acHandling";
    public static final String DEF_DEPENDENCIES = "dependencies";
    public static final String DEF_DESCRIPTION = "jcr:description";
    public static final String DEF_DISABLE_INTERMEDIATE_SAVE = "noIntermediateSaves";
    public static final String DEF_PROVIDER_LINK = "providerLink";
    public static final String DEF_PROVIDER_NAME = "providerName";
    public static final String DEF_PROVIDER_URL = "providerUrl";
    public static final String DEF_REPLACES = "replaces";
    public static final String DEF_REQUIRES_RESTART = "requiresRestart";
    public static final String DEF_REQUIRES_ROOT = "requiresRoot";
    public static final String DEF_TESTED_WITH = "testedWith";
    public static final String DEF_INCLUDE_VERSIONS = "includeVersions";
    public static final Pattern IMPORT_DONE = Pattern.compile("^Package imported\\.$");
    public static final Map<String, DefinitionSetter> DEFINITION_SETTERS = new HashMap<String, DefinitionSetter>();

    @Nonnull
    public static JcrPackageManager getPackageManager(@Nonnull Packaging packaging, @Nonnull SlingHttpServletRequest request) throws RepositoryException {
        ResourceResolver resolver = request.getResourceResolver();
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session != null) {
            return packaging.getPackageManager(session);
        }
        throw new RepositoryException("can't adapt resolver to session");
    }

    public static String getPath(SlingHttpServletRequest request) {
        RequestPathInfo reqPathInfo = request.getRequestPathInfo();
        String path = XSS.filter((String)reqPathInfo.getSuffix());
        if (StringUtils.isBlank((CharSequence)path)) {
            String pathParam = XSS.filter((String)request.getParameter("path"));
            path = StringUtils.isBlank((CharSequence)pathParam) ? "/" : pathParam;
        } else {
            while (path.endsWith("/") && !"/".equals(path)) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public static Resource getResource(JcrPackageManager manager, SlingHttpServletRequest request, String path) throws RepositoryException {
        Resource resource = null;
        Node node = manager.getPackageRoot(true);
        if (node != null) {
            ResourceResolver resolver = request.getResourceResolver();
            String resourcePath = node.getPath() + path;
            resource = resolver.getResource(resourcePath);
        }
        return resource;
    }

    public static JcrPackage getJcrPackage(JcrPackageManager manager, String group, String name) throws RepositoryException {
        List jcrPackages = manager.listPackages(group, false);
        for (JcrPackage jcrPackage : jcrPackages) {
            String packageName = jcrPackage.getDefinition().get("name");
            if (!packageName.equals(name)) continue;
            return jcrPackage;
        }
        return null;
    }

    public static JcrPackage getJcrPackage(JcrPackageManager manager, Resource resource) throws RepositoryException {
        Node node;
        JcrPackage jcrPackage = null;
        if (ResourceHandle.isValid((Resource)resource) && (node = (Node)resource.adaptTo(Node.class)) != null) {
            jcrPackage = manager.open(node, true);
        }
        return jcrPackage;
    }

    public static String getPackagePath(JcrPackageManager pckgMgr, JcrPackage pckg) {
        String path = "";
        if (pckg != null) {
            try {
                Node node = pckg.getNode();
                path = node.getPath();
                Node rootNode = pckgMgr.getPackageRoot(true);
                String root = rootNode.getPath();
                if (path.startsWith(root)) {
                    path = path.substring(root.length());
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return path;
    }

    public static TreeType getTreeType(JcrPackageManager manager, SlingHttpServletRequest request, String path) {
        TreeType type = TreeType.group;
        try {
            Resource resource = PackageUtil.getResource(manager, request, path);
            JcrPackage jcrPackage = PackageUtil.getJcrPackage(manager, resource);
            if (jcrPackage != null) {
                type = TreeType.jcrpckg;
            } else {
                String lowercase = path.toLowerCase();
                if (lowercase.endsWith(".zip") || lowercase.endsWith(".jar")) {
                    type = TreeType.jcrpckg;
                }
            }
        }
        catch (RepositoryException rex) {
            LOG.error(rex.toString());
        }
        return type;
    }

    public static String getGroupPath(JcrPackage pckg) throws RepositoryException {
        return PackageUtil.getGroupPath(pckg.getDefinition());
    }

    public static String getGroupPath(JcrPackageDefinition pckgDef) {
        String group = pckgDef.get("group");
        group = StringUtils.isNotBlank((CharSequence)group) ? "/" + group + "/" : "/";
        return group;
    }

    public static boolean isGroup(JcrPackageDefinition pckgDef, String group) {
        return PackageUtil.equals(pckgDef, "group", group);
    }

    public static boolean isName(JcrPackageDefinition pckgDef, String name) {
        return PackageUtil.equals(pckgDef, "name", name);
    }

    public static boolean isVersion(JcrPackageDefinition pckgDef, String version) {
        return PackageUtil.equals(pckgDef, "version", version);
    }

    public static boolean equals(JcrPackageDefinition pckgDef, String key, String value) {
        String current = pckgDef.get(key);
        return StringUtils.isNotBlank((CharSequence)current) ? current.equals(value) : StringUtils.isBlank((CharSequence)value);
    }

    public static String getFilename(JcrPackage pckg) {
        StringBuilder filename = new StringBuilder();
        if (pckg != null) {
            try {
                JcrPackageDefinition pckgDef = pckg.getDefinition();
                if (pckgDef != null) {
                    filename.append(pckgDef.get("name"));
                    String version = pckgDef.get("version");
                    if (version != null) {
                        filename.append('-').append(version);
                    }
                    filename.append(".zip");
                } else {
                    Node node = pckg.getNode();
                    filename.append(node.getName());
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return filename.toString();
    }

    public static String getDownloadUrl(JcrPackage pckg) {
        StringBuilder downloadUrl = new StringBuilder();
        if (pckg != null) {
            try {
                JcrPackageDefinition pckgDef = pckg.getDefinition();
                if (pckgDef != null) {
                    downloadUrl.append("/bin/cpm/package.download.zip/").append(pckgDef.get("group")).append("/").append(PackageUtil.getFilename(pckg));
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return downloadUrl.toString();
    }

    public static <T> T getDefAttr(JcrPackageDefinition pckgDef, String key, T defaultValue) {
        Object value = null;
        if (pckgDef != null) {
            Class type = defaultValue != null ? defaultValue.getClass() : String.class;
            value = Calendar.class.isAssignableFrom(type) ? pckgDef.getCalendar(key) : pckgDef.get(key);
        }
        return (T)(value != null ? value : (Object)defaultValue);
    }

    public static Calendar getLastModified(JcrPackage pckg) {
        Calendar result = null;
        if (pckg != null) {
            try {
                Node node;
                JcrPackageDefinition pckgDef = pckg.getDefinition();
                if (pckgDef != null) {
                    result = pckgDef.getLastModified();
                }
                if (result == null && (node = pckg.getNode()) != null && (node = node.getNode("jcr:content")) != null && node.hasProperty("jcr:lastModified")) {
                    Property property = node.getProperty("jcr:lastModified");
                    result = property.getDate();
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return result;
    }

    public static void setLastModified(JcrPackageDefinition pckgDef, Calendar time) {
        if (pckgDef != null) {
            pckgDef.set("jcr:lastModified", time, true);
        }
    }

    public static void setLastModified(JcrPackageDefinition pckgDef) {
        Calendar now = Calendar.getInstance();
        PackageUtil.setLastModified(pckgDef, now);
    }

    public static String getLastModifiedBy(JcrPackage pckg) {
        String result = null;
        if (pckg != null) {
            try {
                Node node;
                JcrPackageDefinition pckgDef = pckg.getDefinition();
                if (pckgDef != null) {
                    result = pckgDef.getLastModifiedBy();
                }
                if (result == null && (node = pckg.getNode()) != null && (node = node.getNode("jcr:content")) != null && node.hasProperty("jcr:lastModifiedBy")) {
                    Property property = node.getProperty("jcr:lastModifiedBy");
                    result = property.getString();
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return result;
    }

    public static Calendar getCreated(JcrPackage pckg) {
        Calendar result = null;
        if (pckg != null) {
            try {
                Node node;
                JcrPackageDefinition pckgDef = pckg.getDefinition();
                if (pckgDef != null) {
                    result = pckgDef.getCreated();
                }
                if (result == null && (node = pckg.getNode()) != null && node.hasProperty("jcr:created")) {
                    Property property = node.getProperty("jcr:created");
                    result = property.getDate();
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return result;
    }

    public static String getCreatedBy(JcrPackage pckg) {
        String result = null;
        if (pckg != null) {
            try {
                Node node;
                JcrPackageDefinition pckgDef = pckg.getDefinition();
                if (pckgDef != null) {
                    result = pckgDef.getCreatedBy();
                }
                if (result == null && (node = pckg.getNode()) != null && node.hasProperty("jcr:createdBy")) {
                    Property property = node.getProperty("jcr:createdBy");
                    result = property.getString();
                }
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
            }
        }
        return result;
    }

    public static void getCoverage(JcrPackageDefinition pckgDef, Session session, ProgressTrackerListener listener) {
        if (pckgDef != null) {
            try {
                pckgDef.dumpCoverage(listener);
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
                listener.onError(ProgressTrackerListener.Mode.TEXT, "exception thrown", (Exception)((Object)rex));
            }
        }
    }

    public static WorkspaceFilter getFilter(JcrPackageDefinition pckgDef) throws RepositoryException {
        WorkspaceFilter filter = null;
        if (pckgDef != null) {
            MetaInf metaInf = pckgDef.getMetaInf();
            filter = metaInf.getFilter();
        }
        return filter;
    }

    public static List<PathFilterSet> getFilterList(JcrPackageDefinition pckgDef) throws RepositoryException {
        WorkspaceFilter filter = PackageUtil.getFilter(pckgDef);
        return filter != null ? filter.getFilterSets() : new ArrayList();
    }

    public static String getThumbnailPath(JcrPackageDefinition pckgDef) throws RepositoryException {
        Node pckgDefNode;
        if (pckgDef != null && (pckgDefNode = pckgDef.getNode()).hasNode(THUMBNAIL_PNG)) {
            return pckgDefNode.getPath() + "/" + THUMBNAIL_PNG;
        }
        return "";
    }

    public static void setThumbnail(JcrPackageDefinition pckgDef, ResourceResolver resolver, InputStream pngStream) throws PersistenceException, RepositoryException {
        Resource pckgDefRes = resolver.getResource(pckgDef.getNode().getPath());
        Resource thumbnail = pckgDefRes.getChild(THUMBNAIL_PNG);
        if (thumbnail != null) {
            resolver.delete(thumbnail);
            resolver.commit();
        }
        if (pngStream != null) {
            HashMap<String, String> fileProps = new HashMap<String, String>();
            fileProps.put("jcr:primaryType", "nt:file");
            Resource fileRes = resolver.create(pckgDefRes, THUMBNAIL_PNG, fileProps);
            HashMap<String, Object> contentProps = new HashMap<String, Object>();
            contentProps.put("jcr:primaryType", "nt:resource");
            contentProps.put("jcr:mimeType", "image/png");
            contentProps.put("jcr:data", pngStream);
            resolver.create(fileRes, "jcr:content", contentProps);
            resolver.commit();
        }
    }

    public static TreeNode getTreeNode(JcrPackageManager manager, SlingHttpServletRequest request) throws RepositoryException {
        JcrPackage jcrPackage;
        String path = PackageUtil.getPath(request);
        List jcrPackages = manager.listPackages();
        TreeNode treeNode = new TreeNode(path);
        Iterator iterator = jcrPackages.iterator();
        while (iterator.hasNext() && !treeNode.addPackage(jcrPackage = (JcrPackage)iterator.next())) {
        }
        return treeNode;
    }

    public static void toJson(JsonWriter writer, JcrPackage jcrPackage, Map<String, Object> additionalAttributes) throws RepositoryException, IOException {
        writer.beginObject();
        writer.name("definition");
        PackageUtil.toJson(writer, jcrPackage.getDefinition());
        JsonUtil.jsonMapEntries((JsonWriter)writer, additionalAttributes);
        writer.endObject();
    }

    public static void toJson(JsonWriter writer, JcrPackageDefinition definition) throws IOException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        String version = definition.get("version");
        String description = definition.get(DEF_DESCRIPTION);
        Calendar lastModified = definition.getCalendar("jcr:lastModified");
        Calendar lastUnpacked = definition.getCalendar("lastUnpacked");
        boolean includeVersions = definition.getBoolean(DEF_INCLUDE_VERSIONS);
        writer.beginObject();
        writer.name("group").value(definition.get("group"));
        writer.name("name").value(definition.get("name"));
        if (version != null) {
            writer.name("version").value(version);
        }
        if (description != null) {
            writer.name(DEF_DESCRIPTION).value(description);
        }
        if (lastModified != null) {
            writer.name("jcr:lastModified").value(dateFormat.format(lastModified.getTime()));
        }
        if (lastUnpacked != null) {
            writer.name("lastUnpacked").value(dateFormat.format(lastUnpacked.getTime()));
        }
        writer.name(DEF_INCLUDE_VERSIONS).value(includeVersions);
        writer.endObject();
    }

    public static String packageToXMLResponse(JcrPackage jcrPackage) throws RepositoryException {
        JcrPackageDefinition definition = jcrPackage.getDefinition();
        String group = definition.get("group");
        String name = definition.get("name");
        String version = definition.get("version");
        String filename = PackageUtil.getFilename(jcrPackage);
        long size = jcrPackage.getSize();
        String createdBy = definition.getCreatedBy();
        Calendar created = definition.getCreated();
        Calendar lastModified = definition.getLastModified();
        String lastModifiedBy = definition.getLastModifiedBy();
        Calendar lastUnpacked = definition.getLastUnpacked();
        String lastUnpackedBy = definition.getLastUnpackedBy();
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        String response = "<package><group>" + group + "</group><name>" + name + "</name><version>" + version + "</version><downloadName>" + filename + "</downloadName><size>" + size + "</size>" + (created != null ? "<created>" + dateFormat.format(created.getTime()) + "</created>" : "") + "<createdBy>" + createdBy + "</createdBy>" + (lastModified != null ? "<lastModified>" + dateFormat.format(lastModified.getTime()) + "</lastModified>" : "") + "<lastModifiedBy>" + lastModifiedBy + "</lastModifiedBy>" + (lastUnpacked != null ? "<lastUnpacked>" + dateFormat.format(lastUnpacked.getTime()) + "</lastUnpacked>" : "") + "<lastUnpackedBy>" + lastUnpackedBy + "</lastUnpackedBy></package>";
        return response;
    }

    public static String[] getMultiProperty(JcrPackageDefinition pckgDef, String key) {
        String[] result = new String[]{};
        try {
            Property property = pckgDef.getNode().getProperty(key);
            Value[] values = property.getValues();
            result = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                result[i] = values[i].getString();
            }
        }
        catch (PropertyNotFoundException | PathNotFoundException property) {
        }
        catch (RepositoryException rex) {
            LOG.error(rex.getMessage(), (Throwable)rex);
        }
        return result;
    }

    static {
        DEFINITION_SETTERS.put(DEF_AC_HANDLING, DefinitionSetter.STRING);
        DEFINITION_SETTERS.put(DEF_DEPENDENCIES, DefinitionSetter.MULTI_STRING);
        DEFINITION_SETTERS.put(DEF_DESCRIPTION, DefinitionSetter.STRING);
        DEFINITION_SETTERS.put(DEF_DISABLE_INTERMEDIATE_SAVE, DefinitionSetter.BOOLEAN);
        DEFINITION_SETTERS.put(DEF_PROVIDER_LINK, DefinitionSetter.STRING);
        DEFINITION_SETTERS.put(DEF_PROVIDER_NAME, DefinitionSetter.STRING);
        DEFINITION_SETTERS.put(DEF_PROVIDER_URL, DefinitionSetter.STRING);
        DEFINITION_SETTERS.put(DEF_REPLACES, DefinitionSetter.MULTI_STRING);
        DEFINITION_SETTERS.put(DEF_REQUIRES_RESTART, DefinitionSetter.BOOLEAN);
        DEFINITION_SETTERS.put(DEF_REQUIRES_ROOT, DefinitionSetter.BOOLEAN);
        DEFINITION_SETTERS.put(DEF_TESTED_WITH, DefinitionSetter.STRING);
        DEFINITION_SETTERS.put(DEF_INCLUDE_VERSIONS, DefinitionSetter.BOOLEAN);
    }

    public static interface DefinitionSetter<T> {
        public static final BooleanSetter BOOLEAN = new BooleanSetter();
        public static final StringSetter STRING = new StringSetter();
        public static final MultiStringSetter MULTI_STRING = new MultiStringSetter();

        public T get(JsonReader var1) throws IOException;

        public void set(JcrPackageDefinition var1, String var2, Object var3, boolean var4) throws RepositoryException, ParseException;

        public static class MultiStringSetter
        implements DefinitionSetter<String[]> {
            @Override
            public String[] get(JsonReader reader) throws IOException {
                ArrayList<String> set = new ArrayList<String>();
                if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                    reader.beginArray();
                    while (reader.peek() != JsonToken.END_ARRAY) {
                        set.add(XSS.filter((String)reader.nextString()));
                    }
                    reader.endArray();
                } else {
                    set.add(XSS.filter((String)reader.nextString()));
                }
                return set.toArray(new String[set.size()]);
            }

            @Override
            public void set(JcrPackageDefinition pckgDef, String key, Object value, boolean save) throws RepositoryException {
                Node node = pckgDef.getNode();
                node.setProperty(key, (String[])value);
                if (save) {
                    node.getSession().save();
                }
            }
        }

        public static class StringSetter
        implements DefinitionSetter<String> {
            @Override
            public String get(JsonReader reader) throws IOException {
                return XSS.filter((String)reader.nextString());
            }

            @Override
            public void set(JcrPackageDefinition pckgDef, String key, Object value, boolean save) {
                pckgDef.set(key, value.toString(), save);
            }
        }

        public static class BooleanSetter
        implements DefinitionSetter<Boolean> {
            @Override
            public Boolean get(JsonReader reader) throws IOException {
                Boolean value;
                block2: {
                    value = true;
                    try {
                        value = reader.nextBoolean();
                    }
                    catch (IllegalStateException ex) {
                        String string = reader.nextString();
                        if (!StringUtils.isNotBlank((CharSequence)string)) break block2;
                        value = Boolean.valueOf(string);
                    }
                }
                return value;
            }

            @Override
            public void set(JcrPackageDefinition pckgDef, String key, Object value, boolean save) {
                pckgDef.set(key, Boolean.valueOf(value.toString()).booleanValue(), save);
            }
        }
    }

    public static class TreeNode
    extends ArrayList<TreeItem> {
        private final String path;
        private boolean isLeaf;

        public TreeNode(String path) {
            this.path = path;
        }

        public boolean addPackage(JcrPackage jcrPackage) throws RepositoryException {
            String groupUri = this.path.endsWith("/") ? this.path : this.path + "/";
            String groupPath = PackageUtil.getGroupPath(jcrPackage);
            if (groupPath.startsWith(groupUri)) {
                TreeItem item;
                if (groupPath.equals(groupUri)) {
                    item = new PackageItem(jcrPackage);
                } else {
                    int nextDelimiter;
                    String name = groupPath.substring(this.path.length());
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if ((nextDelimiter = name.indexOf("/")) > 0) {
                        name = name.substring(0, nextDelimiter);
                    }
                    item = new FolderItem(groupUri + name, name);
                }
                if (!this.contains(item)) {
                    this.add(item);
                }
                return false;
            }
            PackageItem item = new PackageItem(jcrPackage);
            if (this.path.equals(groupPath + item.getFilename())) {
                this.isLeaf = true;
                this.add(item);
                return true;
            }
            return false;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void sort() {
            Collections.sort(this, new Comparator<TreeItem>(){

                @Override
                public int compare(TreeItem o1, TreeItem o2) {
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
        }

        public void toJson(JsonWriter writer) throws IOException, RepositoryException {
            if (this.isLeaf()) {
                ((TreeItem)this.get(0)).toJson(writer);
            } else {
                int lastPathSegment = this.path.lastIndexOf("/");
                String name = this.path.substring(lastPathSegment + 1);
                if (StringUtils.isBlank((CharSequence)name)) {
                    name = "packages ";
                }
                FolderItem myself = new FolderItem(this.path, name);
                writer.beginObject();
                JsonUtil.jsonMapEntries((JsonWriter)writer, (Map)myself);
                writer.name("children");
                writer.beginArray();
                for (TreeItem item : this) {
                    item.toJson(writer);
                }
                writer.endArray();
                writer.endObject();
            }
        }
    }

    public static class PackageItem
    implements TreeItem {
        private final JcrPackage jcrPackage;
        private final JcrPackageDefinition definition;

        public PackageItem(JcrPackage jcrPackage) throws RepositoryException {
            this.jcrPackage = jcrPackage;
            this.definition = jcrPackage.getDefinition();
        }

        @Override
        public String getName() {
            return this.definition.get("name");
        }

        @Override
        public String getPath() {
            try {
                String name = this.getFilename();
                String groupPath = PackageUtil.getGroupPath(this.jcrPackage);
                String path = groupPath + name;
                return path;
            }
            catch (RepositoryException rex) {
                LOG.error(rex.getMessage(), (Throwable)rex);
                return "";
            }
        }

        public JcrPackageDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public void toJson(JsonWriter writer) throws RepositoryException, IOException {
            String name = this.getFilename();
            String path = this.getPath();
            LinkedHashMap<String, Boolean> treeState = new LinkedHashMap<String, Boolean>();
            treeState.put("loaded", Boolean.TRUE);
            LinkedHashMap<String, Object> additionalAttributes = new LinkedHashMap<String, Object>();
            additionalAttributes.put("id", path);
            additionalAttributes.put("path", path);
            additionalAttributes.put("name", name);
            additionalAttributes.put("text", name);
            additionalAttributes.put("type", "package");
            additionalAttributes.put("state", treeState);
            additionalAttributes.put("file", this.getFilename());
            PackageUtil.toJson(writer, this.jcrPackage, additionalAttributes);
        }

        public String getFilename() {
            return PackageUtil.getFilename(this.jcrPackage);
        }

        public Calendar getLastModified() {
            Calendar lastModified = PackageUtil.getLastModified(this.jcrPackage);
            if (lastModified != null) {
                return lastModified;
            }
            return PackageUtil.getCreated(this.jcrPackage);
        }

        public boolean equals(Object other) {
            return other instanceof PackageItem && this.getName().equals(((PackageItem)other).getName()) && this.definition.get("version").equals(((PackageItem)other).definition.get("version"));
        }

        public int hashCode() {
            return 31 * this.getName().hashCode() + this.definition.get("version").hashCode();
        }
    }

    public static class FolderItem
    extends LinkedHashMap<String, Object>
    implements TreeItem {
        public FolderItem(String path, String name) {
            this.put("id", path);
            this.put("path", path);
            this.put("name", name);
            this.put("text", name);
            this.put("type", "/".equals(path) ? "root" : "folder");
            LinkedHashMap<String, Boolean> treeState = new LinkedHashMap<String, Boolean>();
            treeState.put("loaded", Boolean.FALSE);
            this.put("state", treeState);
        }

        @Override
        public String getName() {
            return (String)this.get("text");
        }

        @Override
        public String getPath() {
            return (String)this.get("path");
        }

        @Override
        public void toJson(JsonWriter writer) throws IOException {
            JsonUtil.jsonMap((JsonWriter)writer, (Map)this);
        }

        @Override
        public boolean equals(Object other) {
            return other instanceof TreeItem && this.getName().equals(((TreeItem)other).getName());
        }

        @Override
        public int hashCode() {
            return this.getName().hashCode();
        }
    }

    public static interface TreeItem {
        public String getName();

        public String getPath();

        public void toJson(JsonWriter var1) throws RepositoryException, IOException;
    }

    public static enum TreeType {
        group,
        jcrpckg;

    }
}

