/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.view;

import com.composum.sling.core.Restricted;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.pckgmgr.util.PackageUtil;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
public class PackageManagerBean
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PackageManagerBean.class);
    private transient String path;
    private transient PackageUtil.TreeType type;
    private transient String downloadUrl;

    public String getPath() {
        if (this.path == null) {
            this.path = PackageUtil.getPath((SlingHttpServletRequest)this.getRequest());
        }
        return this.path;
    }

    public String getViewType() {
        if (this.type == null) {
            JcrPackageManager manager = null;
            try {
                manager = PackageUtil.getPackageManager((Packaging)this.context.getService(Packaging.class), (SlingHttpServletRequest)this.getRequest());
                this.type = PackageUtil.getTreeType(manager, (SlingHttpServletRequest)this.getRequest(), this.getPath());
            }
            catch (RepositoryException rex) {
                LOG.error(rex.toString());
            }
        }
        return this.type != null ? this.type.name() : "";
    }

    public String getTabType() {
        String selector = this.getRequest().getSelectors((StringFilter)new StringFilter.BlackList("^tab$"));
        return StringUtils.isNotBlank((CharSequence)selector) ? selector.substring(1) : "general";
    }

    public List<PackageUtil.PackageItem> getCurrentGroupPackages() {
        ArrayList<PackageUtil.PackageItem> items = new ArrayList<PackageUtil.PackageItem>();
        try {
            JcrPackageManager manager = PackageUtil.getPackageManager((Packaging)this.context.getService(Packaging.class), (SlingHttpServletRequest)this.getRequest());
            PackageUtil.TreeNode treeNode = PackageUtil.getTreeNode(manager, (SlingHttpServletRequest)this.getRequest());
            for (PackageUtil.TreeItem item : treeNode) {
                if (!(item instanceof PackageUtil.PackageItem) || ((PackageUtil.PackageItem)item).getDefinition() == null) continue;
                items.add((PackageUtil.PackageItem)item);
            }
        }
        catch (RepositoryException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return items;
    }
}

