/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.jcrpckg.service.impl;

import com.composum.sling.core.concurrent.AbstractJobExecutor;
import com.composum.sling.core.concurrent.JobFailureException;
import com.composum.sling.core.concurrent.SequencerService;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageProgressTracker;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageUtil;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.jackrabbit.vault.fs.io.ImportOptions;
import org.apache.jackrabbit.vault.packaging.DependencyHandling;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlan;
import org.apache.jackrabbit.vault.packaging.registry.ExecutionPlanBuilder;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.PackageTask;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.event.jobs.consumer.JobExecutionContext;
import org.apache.sling.event.jobs.consumer.JobExecutor;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.EventHandler;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={JobExecutor.class, EventHandler.class}, property={"service.description=Composum Nodes Package Job Executor Service", "job.topics=com/composum/sling/core/pckgmgr/PackageJobExecutor", "event.topics=org/apache/sling/event/notification/job/*"}, immediate=true)
@Designate(ocd=Configuration.class)
public class PackageJobExecutor
extends AbstractJobExecutor<String> {
    private static final Logger LOG = LoggerFactory.getLogger(PackageJobExecutor.class);
    public static final String JOB_PROPERTY_DRY_RUN = "dryRun";
    public static final String JOB_PROPERTY_SAVE_THRESHOLD = "saveThreshold";
    public static final String JOB_PROPERTY_IMPORT_MODE = "importMode";
    public static final String TOPIC = "com/composum/sling/core/pckgmgr/PackageJobExecutor";
    public static final String AUDIT_BASE_PATH = "/var/audit/jobs/" + PackageJobExecutor.class.getName();
    protected final Lock lock = new ReentrantLock(true);
    @Reference
    private Packaging packaging;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    private volatile PackageRegistries packageRegistries;
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private SequencerService<SequencerService.Token> sequencer;
    @Reference
    private DynamicClassLoaderManager dynamicClassLoaderManager;
    private volatile Configuration config;

    @Nonnull
    protected ResourceResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }

    @Nonnull
    protected SequencerService<SequencerService.Token> getSequencer() {
        return this.sequencer;
    }

    @Nonnull
    protected DynamicClassLoaderManager getDynamicClassLoaderManager() {
        return this.dynamicClassLoaderManager;
    }

    @Activate
    @Modified
    protected void activate(Configuration configuration) {
        this.config = configuration;
    }

    @Deactivate
    protected void deactivate() {
        this.config = null;
    }

    @Nonnull
    protected String getJobTopic() {
        return TOPIC;
    }

    protected String getAuditBasePath() {
        return AUDIT_BASE_PATH;
    }

    protected boolean jobExecutionEnabled(Job job) {
        return !Boolean.getBoolean("composum.never.start.pckgsvc");
    }

    protected Callable<String> createCallable(Job job, JobExecutionContext context, ResourceResolver serviceResolver, PrintWriter out) throws Exception {
        return new PackageManagerCallable(job, context, serviceResolver, out);
    }

    @ObjectClassDefinition(name="Composum Package Job Executor Service", description="Provides the execution of package operations the repository context.")
    public static @interface Configuration {
        @AttributeDefinition(name="save threshold", description="the auto-save threshold for the package import")
        public int package_save_threshold() default 1024;

        @AttributeDefinition(name="track idle time", description="idle time in seconds for the progress tracker to check the operations end")
        public int package_progress_wait() default 10;
    }

    protected class PackageManagerCallable
    extends AbstractJobExecutor.UserContextCallable {
        public PackageManagerCallable(Job job, JobExecutionContext context, ResourceResolver serviceResolver, PrintWriter out) throws RepositoryException, LoginException {
            super((AbstractJobExecutor)PackageJobExecutor.this, job, context, serviceResolver, out);
        }

        public String call() throws Exception {
            PackageJobExecutor.this.lock.lock();
            try {
                String reference = (String)this.job.getProperty("reference");
                String operation = Objects.requireNonNull((String)this.job.getProperty("operation"), "No operation requested!");
                if (RegistryUtil.isRegistryBasedPath(reference)) {
                    String string = new RegistryOperation(reference, operation).call();
                    return string;
                }
                JcrPackageManager manager = PackageJobExecutor.this.packaging.getPackageManager(this.session);
                JcrPackage jcrPckg = this.getJcrPackage(manager, reference);
                switch (operation.toLowerCase()) {
                    case "install": {
                        String name = jcrPckg.getPackage().getId().getName();
                        LOG.info("start of installation of package '{}'", (Object)name);
                        String call = new InstallOperation(manager, jcrPckg).call();
                        LOG.info("installation of package '{}' done", (Object)name);
                        String string = call;
                        return string;
                    }
                    case "assemble": {
                        String string = new AssembleOperation(manager, jcrPckg).call();
                        return string;
                    }
                    case "uninstall": {
                        String string = new UninstallOperation(manager, jcrPckg).call();
                        return string;
                    }
                }
                throw new Exception("Unsupported operation: " + operation);
            }
            finally {
                PackageJobExecutor.this.lock.unlock();
                this.close();
            }
        }

        protected ImportOptions createImportOptions() {
            ImportOptions options = new ImportOptions();
            options.setDryRun(((Boolean)PackageJobExecutor.this.getProperty(this.job, PackageJobExecutor.JOB_PROPERTY_DRY_RUN, false)).booleanValue());
            options.setAutoSaveThreshold(((Integer)PackageJobExecutor.this.getProperty(this.job, PackageJobExecutor.JOB_PROPERTY_SAVE_THRESHOLD, PackageJobExecutor.this.config.package_save_threshold())).intValue());
            options.setImportMode((ImportMode)PackageJobExecutor.this.getProperty(this.job, PackageJobExecutor.JOB_PROPERTY_IMPORT_MODE, ImportMode.REPLACE));
            options.setHookClassLoader(PackageJobExecutor.this.getDynamicClassLoaderManager().getDynamicClassLoader());
            options.setDependencyHandling(DependencyHandling.BEST_EFFORT);
            return options;
        }

        protected JcrPackage getJcrPackage(JcrPackageManager manager, String reference) throws RepositoryException {
            JcrPackage jcrPackage = null;
            Node pckgRoot = manager.getPackageRoot();
            if (pckgRoot != null) {
                while (reference.startsWith("/")) {
                    reference = reference.substring(1);
                }
                Node pckgNode = pckgRoot.getNode(reference);
                if (pckgNode != null) {
                    jcrPackage = manager.open(pckgNode, true);
                }
            }
            return jcrPackage;
        }

        protected class OperationDoneTracker
        extends PackageProgressTracker.TextWriterTracking {
            protected boolean operationDone;
            protected int waitLoopCount;

            public OperationDoneTracker(PrintWriter writer, Pattern finalizedIndicator) {
                super(writer, finalizedIndicator);
            }

            public boolean isOperationDone() {
                return this.operationDone || ++this.waitLoopCount > PackageJobExecutor.this.config.package_progress_wait() * 2;
            }

            @Override
            public void writeEpilogue() throws IOException {
                super.writeEpilogue();
                this.operationDone = true;
            }

            @Override
            protected void writeItem(PackageProgressTracker.Item item) throws IOException {
                super.writeItem(item);
                this.waitLoopCount = 0;
            }
        }

        protected abstract class JcrPackageOperation
        extends AbstractPackageOperation {
            public final JcrPackageManager manager;
            public final JcrPackage jcrPckg;
            public final ImportOptions options;

            protected JcrPackageOperation(JcrPackageManager manager, JcrPackage jcrPckg, boolean isTracked) {
                super(isTracked);
                this.manager = manager;
                this.jcrPckg = jcrPckg;
                this.options = PackageManagerCallable.this.createImportOptions();
                this.options.setListener((ProgressTrackerListener)this.tracker);
            }
        }

        protected abstract class AbstractPackageOperation
        implements Callable<String> {
            protected final OperationDoneTracker tracker;
            protected final boolean hasFinishLogMessage;

            protected AbstractPackageOperation(boolean hasFinishLogMessage) {
                this.tracker = new OperationDoneTracker(PackageManagerCallable.this.out, PackageUtil.IMPORT_DONE);
                this.hasFinishLogMessage = hasFinishLogMessage;
            }

            protected abstract void doIt() throws PackageException, IOException, RepositoryException;

            protected void track() {
                while (!this.isDone()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException iex) {
                        LOG.info("Operation track interrupted: {}", (Object)iex.getMessage());
                    }
                }
            }

            protected boolean isDone() {
                return !this.hasFinishLogMessage || this.tracker.isOperationDone();
            }

            protected String done() throws IOException {
                return "done.";
            }

            @Override
            public String call() throws IOException, RepositoryException, PackageException {
                this.tracker.writePrologue();
                this.doIt();
                this.track();
                return this.done();
            }
        }

        protected class RegistryOperation
        extends AbstractPackageOperation {
            protected final String reference;
            protected final PackageTask.Type type;
            protected ExecutionPlan plan;

            public RegistryOperation(String reference, String operation) throws IllegalArgumentException {
                super(false);
                this.reference = reference;
                this.type = this.convertOperation(operation);
            }

            protected PackageTask.Type convertOperation(String operation) {
                switch (operation.toLowerCase()) {
                    case "install": {
                        return PackageTask.Type.INSTALL;
                    }
                    case "uninstall": {
                        return PackageTask.Type.UNINSTALL;
                    }
                    case "extract": {
                        return PackageTask.Type.EXTRACT;
                    }
                    case "remove": {
                        return PackageTask.Type.REMOVE;
                    }
                }
                throw new IllegalArgumentException("Unsupported operation: " + operation);
            }

            @Override
            protected void doIt() throws PackageException, IOException, RepositoryException {
                PackageRegistries.Registries registries = PackageJobExecutor.this.packageRegistries.getRegistries(PackageManagerCallable.this.serviceResolver);
                Pair<String, PackageId> pckgid = Objects.requireNonNull(registries.resolve(this.reference), "Can't find package " + this.reference);
                PackageRegistry registry = registries.getRegistry((String)pckgid.getLeft());
                PackageTask.Type taskType = this.fixTaskType(pckgid, registry, this.type);
                taskType = this.fixTaskType(pckgid, registry, taskType);
                ExecutionPlanBuilder builder = registry.createExecutionPlan().with(PackageManagerCallable.this.session).with((ProgressTrackerListener)this.tracker).addTask().with((PackageId)pckgid.getRight()).with(taskType);
                builder.validate();
                this.plan = builder.execute();
                this.evaluatePlan(this.plan);
            }

            private PackageTask.Type fixTaskType(Pair<String, PackageId> pckgid, PackageRegistry registry, PackageTask.Type taskType) throws IOException {
                RegisteredPackage regpckg;
                if (this.type == PackageTask.Type.INSTALL && (regpckg = registry.open((PackageId)pckgid.getRight())) != null && regpckg.getPackage() != null && regpckg.getPackage().getFile() != null) {
                    LOG.info("We are assuming this is a FSPackageRegistry and that supports EXTRACT but not INSTALL for {}", pckgid);
                    taskType = PackageTask.Type.EXTRACT;
                }
                return taskType;
            }

            protected void evaluatePlan(ExecutionPlan plan) throws PackageException, IOException, RepositoryException {
                if (plan.isExecuted()) {
                    String msg = plan.hasErrors() ? "with errors" : "without errors";
                    this.tracker.onMessage(ProgressTrackerListener.Mode.TEXT, plan.getId(), "Plan was executed " + msg);
                }
                Throwable throwable = null;
                if (plan.hasErrors()) {
                    for (PackageTask task : plan.getTasks()) {
                        if (task.getError() == null) continue;
                        this.tracker.onError(ProgressTrackerListener.Mode.TEXT, task.getError().getMessage(), (Exception)task.getError());
                        if (throwable != null) continue;
                        throwable = task.getError();
                    }
                }
                if (throwable instanceof PackageException) {
                    throw (PackageException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RepositoryException) {
                    throw (RepositoryException)throwable;
                }
                if (throwable != null) {
                    throw new PackageException(throwable);
                }
            }

            @Override
            protected boolean isDone() {
                return this.plan != null && this.plan.isExecuted() && !this.plan.hasErrors() || super.isDone();
            }
        }

        protected class UninstallOperation
        extends JcrPackageOperation {
            public UninstallOperation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                super(manager, jcrPckg, true);
            }

            @Override
            protected void doIt() throws PackageException, IOException, RepositoryException {
                this.jcrPckg.uninstall(this.options);
            }

            @Override
            protected String done() throws IOException {
                return "Package uninstall done.";
            }
        }

        protected class AssembleOperation
        extends JcrPackageOperation {
            public AssembleOperation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                super(manager, jcrPckg, false);
            }

            @Override
            protected void doIt() throws PackageException, IOException, RepositoryException {
                this.manager.assemble(this.jcrPckg, (ProgressTrackerListener)this.tracker);
            }

            @Override
            protected String done() throws IOException {
                return "Package assembled.";
            }
        }

        protected class InstallOperation
        extends JcrPackageOperation {
            public InstallOperation(JcrPackageManager manager, JcrPackage jcrPckg) throws IOException {
                super(manager, jcrPckg, true);
            }

            @Override
            protected void doIt() throws PackageException, IOException, RepositoryException {
                this.jcrPckg.install(this.options);
            }

            @Override
            protected String done() throws IOException {
                if (this.tracker.getErrorDetected()) {
                    throw new JobFailureException("install done with errors");
                }
                return super.done();
            }
        }
    }
}

