/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.jcrpckg.util;

import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageUtil;
import com.composum.sling.core.util.ResponseUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.ProgressTrackerListener;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PackageProgressTracker
implements ProgressTrackerListener {
    private static final Logger LOG = LoggerFactory.getLogger(PackageUtil.class);
    public static final String PLAIN_TEXT_SHORT_ACTION_SPACE = "   ";
    protected int actionCount;
    protected int itemCount;
    protected int errorCount;

    public boolean getErrorDetected() {
        return this.errorCount > 0;
    }

    public void onMessage(ProgressTrackerListener.Mode mode, String action, String path) {
        try {
            Item item = new Item(mode, action, path, null);
            this.writeItem(item);
            if (item.actionOnly) {
                ++this.actionCount;
            } else {
                ++this.itemCount;
            }
        }
        catch (IOException ex) {
            ++this.errorCount;
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public void onError(ProgressTrackerListener.Mode mode, String path, Exception ex) {
        LOG.warn("Received error for mode {} path {}", new Object[]{mode, path, ex});
        ++this.errorCount;
        try {
            this.writeItem(new Item(mode, "E", path, ex));
        }
        catch (IOException ioex) {
            ++this.errorCount;
            LOG.error(ioex.getMessage(), (Throwable)ioex);
        }
    }

    protected abstract void writeItem(Item var1) throws IOException;

    public abstract void writePrologue() throws IOException;

    public abstract void writeEpilogue() throws IOException;

    public static class HtmlTracking
    extends HtmlStreamTracking {
        public HtmlTracking(SlingHttpServletResponse response, Pattern finalizedIndicator) throws IOException {
            super(response, finalizedIndicator);
        }

        public HtmlTracking(Writer writer, Pattern finalizedIndicator) {
            super(writer, finalizedIndicator);
        }

        @Override
        public void writePrologue() throws IOException {
            this.writer.append("<table>\n");
            super.writePrologue();
        }

        @Override
        public void writeEpilogue() throws IOException {
            super.writeEpilogue();
            this.writer.append("</table>\n");
        }
    }

    public static class HtmlStreamTracking
    extends PackageProgressTracker {
        protected final Writer writer;
        protected final Pattern finalizedIndicator;

        public HtmlStreamTracking(SlingHttpServletResponse response, Pattern finalizedIndicator) throws IOException {
            this(response.getWriter(), finalizedIndicator);
        }

        public HtmlStreamTracking(Writer writer, Pattern finalizedIndicator) {
            this.writer = writer;
            this.finalizedIndicator = finalizedIndicator;
        }

        @Override
        public void writePrologue() throws IOException {
        }

        @Override
        public void writeEpilogue() throws IOException {
            this.writer.append("<tr class=\"summary ");
            this.writer.append(this.getErrorDetected() ? "with-errors" : "successful");
            this.writer.append("\"><td colspan=\"3\">");
            this.writer.append("Finished ").append(this.getErrorDetected() ? "with errors" : "successfully");
            this.writer.append(" - items: ").append(Integer.toString(this.itemCount));
            this.writer.append(", actions: ").append(Integer.toString(this.actionCount));
            this.writer.append(", errors: ").append(Integer.toString(this.errorCount));
            this.writer.append("</td></tr>\n");
        }

        @Override
        protected void writeItem(Item item) throws IOException {
            this.writer.append("<tr class=\"").append(item.errorDetected ? "error" : "success").append("\">");
            this.writer.append("<td class=\"action");
            if (item.actionOnly) {
                this.writer.append(" no-message\" colspan=\"").append(item.errorDetected ? "2" : "3");
            }
            this.writer.append("\">").append(item.action).append("</td>");
            if (!item.actionOnly) {
                this.writer.append("<td class=\"value\"");
                if (!item.errorDetected) {
                    this.writer.append(" colspan=\"2\"");
                }
                this.writer.append(">").append(item.path != null ? item.path : item.message).append("</td>");
            }
            if (item.errorDetected) {
                this.writer.append("<td class=\"errmsg\">").append(item.error).append("</td>");
            }
            this.writer.append("</tr>\n");
            if (this.finalizedIndicator != null && item.action != null && this.finalizedIndicator.matcher(item.action).matches()) {
                this.writeEpilogue();
            }
        }
    }

    public static class JsonTracking
    extends JsonStreamTracking {
        public JsonTracking(SlingHttpServletResponse response, Pattern finalizedIndicator) throws IOException {
            super(response, finalizedIndicator);
        }

        public JsonTracking(JsonWriter writer, Pattern finalizedIndicator) {
            super(writer, finalizedIndicator);
        }

        @Override
        public void writePrologue() throws IOException {
            this.writer.beginArray();
            super.writePrologue();
        }

        @Override
        public void writeEpilogue() throws IOException {
            super.writeEpilogue();
            this.writer.endArray();
        }
    }

    public static class JsonStreamTracking
    extends PackageProgressTracker {
        protected final JsonWriter writer;
        protected final Pattern finalizedIndicator;

        public JsonStreamTracking(SlingHttpServletResponse response, Pattern finalizedIndicator) throws IOException {
            this(ResponseUtil.getJsonWriter((SlingHttpServletResponse)response), finalizedIndicator);
        }

        public JsonStreamTracking(JsonWriter writer, Pattern finalizedIndicator) {
            this.writer = writer;
            this.finalizedIndicator = finalizedIndicator;
        }

        @Override
        public void writePrologue() throws IOException {
        }

        @Override
        public void writeEpilogue() throws IOException {
        }

        @Override
        protected void writeItem(Item item) throws IOException {
            this.writer.beginObject();
            this.writer.name("action").value(item.action);
            this.writer.name("value").value(item.path != null ? item.path : item.message);
            this.writer.name("error").value(item.error);
            this.writer.endObject();
            if (this.finalizedIndicator != null && item.action != null && this.finalizedIndicator.matcher(item.action).matches()) {
                this.writeEpilogue();
            }
        }
    }

    public static class TextWriterTracking
    extends PackageProgressTracker {
        protected final PrintWriter writer;
        protected final Pattern finalizedIndicator;

        public TextWriterTracking(SlingHttpServletResponse response, Pattern finalizedIndicator) throws IOException {
            this(response.getWriter(), finalizedIndicator);
        }

        public TextWriterTracking(PrintWriter writer, Pattern finalizedIndicator) {
            this.writer = writer;
            this.finalizedIndicator = finalizedIndicator;
        }

        @Override
        public void writePrologue() {
        }

        @Override
        public void writeEpilogue() throws IOException {
        }

        @Override
        protected void writeItem(Item item) throws IOException {
            if (item.action != null) {
                int len = item.action.length();
                if (len < PackageProgressTracker.PLAIN_TEXT_SHORT_ACTION_SPACE.length()) {
                    this.writer.append("  ");
                    this.writer.append(item.action);
                    this.writer.append(PackageProgressTracker.PLAIN_TEXT_SHORT_ACTION_SPACE.substring(len));
                } else {
                    this.writer.append(item.action);
                    this.writer.append(' ');
                }
            } else {
                this.writer.append(PackageProgressTracker.PLAIN_TEXT_SHORT_ACTION_SPACE);
            }
            this.writer.append(item.path != null ? item.path : item.message);
            if (item.errorDetected) {
                this.writer.append("\n  ! ");
                this.writer.append(item.error);
            }
            this.writer.append('\n');
            if (this.finalizedIndicator != null && item.action != null && this.finalizedIndicator.matcher(item.action).matches()) {
                this.writeEpilogue();
            }
        }
    }

    public static class LogOnlyTracking
    extends PackageProgressTracker {
        protected final String label;

        public LogOnlyTracking(String label) {
            this.label = label;
        }

        @Override
        public void writePrologue() {
        }

        @Override
        public void writeEpilogue() {
        }

        @Override
        protected void writeItem(Item item) {
            if (LOG.isDebugEnabled()) {
                StringBuilder builder = new StringBuilder(this.label);
                builder.append(" - [ action: ").append(item.action);
                builder.append(", ").append(item.path != null ? "path: " + item.path : "message: " + item.message);
                if (item.errorDetected) {
                    builder.append(", error: ").append(item.error);
                }
                LOG.debug(builder.toString());
            }
        }
    }

    public static class Item {
        public final String action;
        public final String path;
        public final String message;
        public final String error;
        public final boolean actionOnly;
        public final boolean errorDetected;

        public Item(ProgressTrackerListener.Mode mode, String action, String path, Exception ex) {
            this.action = action;
            if (mode == ProgressTrackerListener.Mode.TEXT) {
                this.message = path;
                this.path = null;
            } else {
                this.message = null;
                this.path = path;
            }
            this.error = ex != null ? ex.toString() : null;
            this.actionOnly = StringUtils.isBlank((CharSequence)path) && StringUtils.isBlank((CharSequence)this.message);
            this.errorDetected = StringUtils.isNotBlank((CharSequence)this.error);
        }
    }
}

