/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.service.impl;

import com.composum.sling.core.pckgmgr.Packages;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.pckgmgr.regpckg.util.VersionComparator;
import com.composum.sling.core.util.ResourceUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.packaging.Dependency;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.Version;
import org.apache.jackrabbit.vault.packaging.VersionRange;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.jackrabbit.vault.packaging.registry.RegisteredPackage;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={PackageRegistries.class}, immediate=true)
public class PackageRegistriesImpl
implements PackageRegistries {
    private static final Logger LOG = LoggerFactory.getLogger(PackageRegistriesImpl.class);
    protected final List<PackageRegistry> registryServices = new ArrayList<PackageRegistry>();
    @Reference
    protected Packaging packaging;
    @Reference
    private ResourceResolverFactory resolverFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(service=PackageRegistry.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    protected void bindPackageRegistry(PackageRegistry registry) {
        List<PackageRegistry> list = this.registryServices;
        synchronized (list) {
            this.registryServices.add(registry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindPackageRegistry(PackageRegistry registry) {
        List<PackageRegistry> list = this.registryServices;
        synchronized (list) {
            this.registryServices.remove(registry);
        }
    }

    @Override
    @Nonnull
    public PackageRegistries.Registries getRegistries(@Nonnull ResourceResolver resolver) {
        return new RegistriesImpl(resolver);
    }

    protected PackageRegistry getJcrPackageRegistry(@Nonnull ResourceResolver resolver) {
        PackageRegistry registry = null;
        try {
            JcrPackageManager manager = this.packaging.getPackageManager(Objects.requireNonNull((Session)resolver.adaptTo(Session.class)));
            Class<?> managerType = manager.getClass();
            Method getRegistry = managerType.getMethod("getRegistry", new Class[0]);
            registry = (PackageRegistry)getRegistry.invoke((Object)manager, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            LOG.warn(ex.toString());
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return registry;
    }

    public class RegistriesImpl
    implements PackageRegistries.Registries {
        protected final ResourceResolver resolver;
        protected final Map<String, PackageRegistry> registries;

        public RegistriesImpl(ResourceResolver resolver) {
            this.resolver = resolver;
            this.registries = new TreeMap<String, PackageRegistry>();
            for (PackageRegistry registry : PackageRegistriesImpl.this.registryServices) {
                this.add(registry);
            }
            this.add(PackageRegistriesImpl.this.getJcrPackageRegistry(resolver));
        }

        @Override
        @Nonnull
        public Collection<PackageRegistry> iterable() {
            return Collections.unmodifiableCollection(this.registries.values());
        }

        @Override
        @Nonnull
        public Collection<String> getNamespaces() {
            return Collections.unmodifiableCollection(this.registries.keySet());
        }

        @Override
        @Nullable
        public PackageRegistry getRegistry(@Nonnull String namespaceOrPath) {
            String namespace = namespaceOrPath;
            if (namespaceOrPath.startsWith("/")) {
                Matcher matcher = Packages.REGISTRY_BASED_PATH.matcher(namespaceOrPath);
                if (matcher.matches()) {
                    namespace = matcher.group("ns");
                } else {
                    Pair<String, PackageId> resolved = null;
                    try {
                        resolved = this.resolve(namespaceOrPath);
                    }
                    catch (IOException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                    }
                    if (resolved != null) {
                        namespace = (String)resolved.getLeft();
                    }
                }
            }
            return this.registries.get(namespace);
        }

        @Override
        @Nullable
        public Pair<String, PackageId> resolve(@Nullable String rawPath) throws IOException {
            Pair result = null;
            if (StringUtils.startsWith((CharSequence)rawPath, (CharSequence)"/")) {
                Matcher matcher = Packages.REGISTRY_BASED_PATH.matcher(rawPath);
                String path = rawPath;
                ArrayList<Pair> searchRegistries = new ArrayList<Pair>();
                if (matcher.matches()) {
                    String namespace = matcher.group("ns");
                    path = matcher.group("path");
                    if (this.getRegistry(namespace) != null) {
                        searchRegistries.add(Pair.of((Object)namespace, (Object)this.getRegistry(namespace)));
                    }
                } else {
                    this.registries.entrySet().forEach(e -> searchRegistries.add(Pair.of((Object)((String)e.getKey()), (Object)((PackageRegistry)e.getValue()))));
                }
                for (Pair registryEntry : searchRegistries) {
                    for (PackageId id : ((PackageRegistry)registryEntry.getValue()).packages()) {
                        if (path.equals(RegistryUtil.toPath((String)null, id))) {
                            result = Pair.of((Object)((String)registryEntry.getKey()), (Object)id);
                            continue;
                        }
                        if (!path.equals(RegistryUtil.toPackagePath(null, id)) || result != null && new VersionComparator().compare(((PackageId)result.getRight()).getVersionString(), id.getVersionString()) >= 0) continue;
                        result = Pair.of((Object)((String)registryEntry.getKey()), (Object)id);
                    }
                }
            }
            return result;
        }

        @Nullable
        protected Dependency pathToDependency(@Nonnull String path) {
            String lastSegment = ResourceUtil.getName((String)path);
            String parent = ResourceUtil.getParent((String)path);
            if (lastSegment == null || parent == null) {
                return null;
            }
            Version version = null;
            if (lastSegment.matches("^[0-9].*")) {
                version = Version.create((String)lastSegment);
                lastSegment = ResourceUtil.getName((String)parent);
                parent = ResourceUtil.getParent((String)path);
            }
            if (lastSegment == null || parent == null) {
                return null;
            }
            return new Dependency(parent, lastSegment, new VersionRange(version));
        }

        @Override
        @Nullable
        public Pair<PackageRegistry, PackageId> resolve(@Nonnull Dependency dependency, boolean onlyInstalled) throws IOException {
            PackageRegistry candidateRegistry = null;
            PackageId candidate = null;
            for (PackageRegistry registry : this.iterable()) {
                PackageId pckg = registry.resolve(dependency, onlyInstalled);
                if (pckg == null || candidate != null && new VersionComparator().compare(candidate.getVersionString(), pckg.getVersionString()) >= 0) continue;
                candidate = pckg;
                candidateRegistry = registry;
            }
            return candidate != null ? Pair.of(candidateRegistry, candidate) : null;
        }

        @Override
        @Nullable
        public Pair<String, RegisteredPackage> open(@Nonnull PackageId id) throws IOException {
            String namespace = null;
            RegisteredPackage pckg = null;
            for (Map.Entry<String, PackageRegistry> entry : this.registries.entrySet()) {
                pckg = entry.getValue().open(id);
                if (pckg == null) continue;
                namespace = entry.getKey();
                break;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("open({}): {}", (Object)id, pckg);
            }
            return pckg != null ? Pair.of(namespace, pckg) : null;
        }

        @Override
        @Nullable
        public Pair<String, PackageId> resolve(@Nullable String namespace, @Nullable PackageId packageId) throws IOException {
            Pair result = null;
            for (PackageRegistry registry : this.iterable()) {
                String regNamespace = RegistryUtil.namespace(registry);
                if (namespace != null && !namespace.equals(regNamespace) || packageId == null || !registry.contains(packageId)) continue;
                result = Pair.of((Object)RegistryUtil.namespace(registry), (Object)packageId);
                break;
            }
            return result;
        }

        protected void add(@Nullable PackageRegistry registry) {
            if (registry != null) {
                this.registries.put(RegistryUtil.namespace(registry), registry);
            }
        }
    }
}

