/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.tree;

import com.composum.sling.core.pckgmgr.jcrpckg.tree.TreeItem;
import com.composum.sling.core.pckgmgr.regpckg.tree.GroupNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.PackageNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryItem;
import com.composum.sling.core.util.JsonUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNode
extends LinkedHashMap<String, Object>
implements RegistryItem {
    private static final Logger LOG = LoggerFactory.getLogger(PackageNode.class);
    public static final String KEY_NAME = "name";
    public static final String KEY_PATH = "path";
    public static final String KEY_TEXT = "text";
    public static final String KEY_TYPE = "type";
    public static final String KEY_STATE = "state";
    public static final String KEY_LOADED = "loaded";
    public static final String KEY_ITEMS = "items";
    private boolean loaded = false;
    private final RegistryItem parent;

    protected AbstractNode(RegistryItem parent) {
        this.parent = parent;
    }

    @Override
    @Nullable
    public RegistryItem getParent() {
        return this.parent;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Override
    @Nonnull
    public Iterable<RegistryItem> getItems() {
        Map<String, RegistryItem> items = this.getItemsMap();
        return items != null ? items.values() : Collections.emptyList();
    }

    @Override
    @Nullable
    public RegistryItem getItem(@Nonnull String name) {
        Map<String, RegistryItem> items = this.getItemsMap();
        return items != null ? items.get(name) : null;
    }

    @Nullable
    protected Map<String, RegistryItem> getItemsMap() {
        return (Map)this.get(KEY_ITEMS);
    }

    @Override
    public String getName() {
        return (String)this.get(KEY_NAME);
    }

    @Override
    public String getPath() {
        return (String)this.get(KEY_PATH);
    }

    @Override
    public String getText() {
        return (String)this.get(KEY_TEXT);
    }

    @Override
    public String getType() {
        return (String)this.get(KEY_TYPE);
    }

    @Override
    public void toTree(@Nonnull JsonWriter writer, boolean children, boolean showRoot) throws IOException {
        if (showRoot) {
            writer.beginObject();
            this.toTreeProperties(writer);
            writer.name(KEY_STATE).beginObject();
            this.toTreeState(writer);
            writer.endObject();
            if (children) {
                writer.name("children");
                this.toTreeChildren(writer);
            }
            writer.endObject();
        } else {
            this.toTreeChildren(writer);
        }
    }

    protected void toTreeChildren(@Nonnull JsonWriter writer) throws IOException {
        writer.beginArray();
        Map<String, RegistryItem> items = this.getItemsMap();
        if (items != null) {
            for (RegistryItem item : items.values()) {
                item.toTree(writer, false, true);
            }
        }
        writer.endArray();
    }

    protected void toTreeProperties(@Nonnull JsonWriter writer) throws IOException {
        writer.name(KEY_NAME).value(this.getName());
        writer.name(KEY_PATH).value(this.getPath());
        writer.name(KEY_TEXT).value(this.getText());
        writer.name(KEY_TYPE).value(this.getType());
    }

    protected void toTreeState(@Nonnull JsonWriter writer) throws IOException {
        writer.name(KEY_LOADED).value(this.isLoaded());
    }

    @Override
    public void toJson(@Nonnull JsonWriter writer) throws IOException {
        writer.beginObject();
        JsonUtil.jsonMapEntries((JsonWriter)writer, (Map)this);
        Map<String, RegistryItem> items = this.getItemsMap();
        if (items != null) {
            writer.name("children").beginArray();
            for (RegistryItem item : items.values()) {
                try {
                    item.toJson(writer);
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    throw new IOException(ex.getMessage());
                }
            }
        }
        writer.endArray();
        writer.endObject();
    }

    @Override
    public void compactSubTree() {
        Map<String, RegistryItem> children = this.getItemsMap();
        if (children == null) {
            return;
        }
        HashMap<String, String> nameToKey = new HashMap<String, String>();
        ArrayList<String> keysToRemove = new ArrayList<String>();
        Iterator<Map.Entry<String, RegistryItem>> it = children.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, RegistryItem> entry = it.next();
            entry.getValue().compactSubTree();
            String name = entry.getValue().getName();
            String otherEntryKey = (String)nameToKey.get(name);
            if (otherEntryKey != null) {
                RegistryItem other = children.get(otherEntryKey);
                if (entry.getValue() instanceof AbstractNode && other instanceof AbstractNode) {
                    AbstractNode entryNode = (AbstractNode)entry.getValue();
                    AbstractNode otherNode = (AbstractNode)other;
                    if (entryNode instanceof GroupNode) {
                        otherNode.combineChildren((GroupNode)entryNode);
                        it.remove();
                    } else if (otherNode instanceof GroupNode) {
                        entryNode.combineChildren((GroupNode)otherNode);
                        keysToRemove.add(otherEntryKey);
                    } else {
                        LOG.warn("Found two not combineable items with the same name: {} and {}", (Object)entry.getValue(), (Object)other);
                    }
                }
            }
            nameToKey.put(name, entry.getKey());
        }
        keysToRemove.forEach(children::remove);
    }

    protected void combineChildren(GroupNode otherNode) {
        Collection duplicatedKeys = CollectionUtils.intersection((Collection)this.getItemsMap().values().stream().map(RegistryItem::getName).collect(Collectors.toSet()), (Collection)otherNode.getItemsMap().values().stream().map(RegistryItem::getName).collect(Collectors.toSet()));
        if (!duplicatedKeys.isEmpty()) {
            LOG.error("Found duplicated keys in children of {}: {}", (Object)this.getPath(), (Object)duplicatedKeys);
        }
        this.getItemsMap().putAll(otherNode.getItemsMap().values().stream().collect(Collectors.toMap(RegistryItem::getName, Function.identity())));
    }

    @Override
    public RegistryItem compactTree() {
        if (this.parent != null) {
            this.parent.compactSubTree();
            return Objects.requireNonNull(this.parent.getItem(this.getName()));
        }
        this.compactSubTree();
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof TreeItem && this.getPath().equals(((TreeItem)other).getPath());
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }
}

