/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.tree;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.pckgmgr.regpckg.tree.AbstractNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.PackageNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryItem;
import com.composum.sling.core.util.SlingResourceUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.packaging.PackageId;

public class GroupNode
extends AbstractNode {
    public GroupNode(@Nullable RegistryItem parent, @Nullable String parentPath, @Nonnull String name) {
        super(parent);
        parentPath = parentPath != null ? parentPath : parent.getPath();
        String path = SlingResourceUtil.appendPaths((String)parentPath, (String)name);
        this.put("path", path);
        this.put("name", name);
        this.put("text", name);
        this.put("type", "folder");
        TreeMap items = new TreeMap();
        this.put("items", items);
    }

    @Override
    @Nullable
    public RegistryItem getItem(@Nonnull String name) {
        Map<String, RegistryItem> items = Objects.requireNonNull(this.getItemsMap());
        RegistryItem result = items.get("1_" + name);
        return result != null ? result : items.get("0_" + name);
    }

    @Override
    public void load(@Nonnull BeanContext context) {
        this.setLoaded(true);
    }

    @Override
    public void loadForItems(@Nonnull BeanContext context) throws IOException {
    }

    @Nonnull
    public GroupNode getGroup(String name) {
        Map<String, RegistryItem> items = Objects.requireNonNull(this.getItemsMap());
        GroupNode group = (GroupNode)items.get("0_" + name);
        if (group == null) {
            group = new GroupNode(this, null, name);
            items.put("0_" + group.getName(), group);
        }
        return group;
    }

    public PackageNode addPackage(@Nonnull String registryNamespace, @Nonnull PackageId id) {
        Map<String, RegistryItem> items = Objects.requireNonNull(this.getItemsMap());
        PackageNode pckg = (PackageNode)items.get("1_" + id.getName());
        if (pckg == null) {
            pckg = new PackageNode(this, id);
            items.put("1_" + id.getName(), pckg);
        }
        pckg.addVersion(registryNamespace, id);
        return pckg;
    }

    @Override
    protected void combineChildren(GroupNode otherNode) {
        throw new UnsupportedOperationException("BUG: this shouldn't be called.");
    }
}

