/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.jcrpckg.view;

import com.composum.sling.core.Restricted;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.pckgmgr.Packages;
import com.composum.sling.core.pckgmgr.jcrpckg.util.PackageUtil;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.util.VersionComparator;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
public class PackageManagerBean
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(PackageManagerBean.class);
    private transient String path;
    private transient PackageUtil.ViewType type;
    private transient List<String> pathsToVersionsOfThisPackage;
    private transient List<String> pathsToHighestVersionOfEachPackage;
    private transient Map<String, String> registriesMap;

    public String getPath() {
        if (this.path == null) {
            this.path = PackageUtil.getPath((SlingHttpServletRequest)this.getRequest());
        }
        return this.path;
    }

    public Packages.Mode getMode() {
        return Packages.getMode((SlingHttpServletRequest)this.getRequest());
    }

    public String getViewType() {
        if (this.type == null) {
            this.type = PackageUtil.getViewType(this.context, (SlingHttpServletRequest)this.getRequest(), this.getPath());
        }
        return this.type != null ? this.type.name() : "";
    }

    public String getTabType() {
        String selector = this.getRequest().getSelectors((StringFilter)new StringFilter.BlackList("^tab$"));
        return StringUtils.isNotBlank((CharSequence)selector) ? selector.substring(1) : "general";
    }

    public List<String> getPathsToVersionsOfThisPackage() {
        if (this.pathsToVersionsOfThisPackage == null) {
            try {
                JcrPackageManager manager = PackageUtil.getPackageManager((Packaging)this.context.getService(Packaging.class), (SlingHttpServletRequest)this.getRequest());
                String group = StringUtils.removeStart((String)ResourceUtil.getParent((String)this.getPath()), (String)"/");
                String name = ResourceUtil.getName((String)this.getPath());
                this.pathsToVersionsOfThisPackage = manager.listPackages(group, false).stream().filter(p -> name.equals(PackageUtil.getPackageId(p).getName())).map(p -> PackageUtil.getPackagePath(manager, p)).sorted(Comparator.naturalOrder().reversed()).collect(Collectors.toList());
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.pathsToVersionsOfThisPackage;
    }

    public List<String> getPathsToHighestVersionOfEachPackage() {
        if (this.pathsToHighestVersionOfEachPackage == null) {
            try {
                JcrPackageManager manager = PackageUtil.getPackageManager((Packaging)this.context.getService(Packaging.class), (SlingHttpServletRequest)this.getRequest());
                Map<Pair, List<JcrPackage>> packageGrouped = manager.listPackages().stream().filter(p -> PackageUtil.getPackagePath(manager, p).startsWith(this.getPath() + "/")).collect(Collectors.groupingBy(pckg -> Pair.of((Object)PackageUtil.getPackageId(pckg).getGroup(), (Object)PackageUtil.getPackageId(pckg).getName())));
                List packageGroupList = packageGrouped.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(Map.Entry::getValue).map(l -> l.stream().filter(p -> PackageUtil.getPackageId(p) != null).sorted(Comparator.comparing(PackageUtil::getPackageId, new VersionComparator.PackageIdComparator(true))).collect(Collectors.toList())).collect(Collectors.toList());
                this.pathsToHighestVersionOfEachPackage = packageGroupList.stream().map(l -> (JcrPackage)l.get(0)).map(p -> PackageUtil.getPackagePath(manager, p)).collect(Collectors.toList());
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.pathsToHighestVersionOfEachPackage;
    }

    public boolean isRegistriesAvailable() {
        return this.getRegistries().size() > 0;
    }

    public Map<String, String> getRegistries() {
        if (this.registriesMap == null) {
            this.registriesMap = new TreeMap<String, String>();
            PackageRegistries packageRegistries = (PackageRegistries)this.context.getService(PackageRegistries.class);
            if (packageRegistries != null) {
                PackageRegistries.Registries registries = packageRegistries.getRegistries(this.getResolver());
                for (String namespace : registries.getNamespaces()) {
                    PackageRegistry registry = registries.getRegistry(namespace);
                    if (registry == null) continue;
                    this.registriesMap.put(namespace, registry.getClass().getSimpleName());
                }
            }
        }
        return this.registriesMap;
    }
}

