/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.tree;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.tree.AbstractNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.GroupNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryItem;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;

public class RegistryNode
extends AbstractNode {
    public RegistryNode(String namespace, PackageRegistry registry) {
        super((RegistryItem)null);
        String name = registry.getClass().getSimpleName();
        this.put("path", "/@" + namespace);
        this.put("name", namespace);
        this.put("text", name);
        this.put("type", "registry");
    }

    @Override
    @Nullable
    public RegistryItem getItem(@Nonnull String name) {
        Map<String, RegistryItem> items = Objects.requireNonNull(this.getItemsMap());
        RegistryItem result = items.get("1_" + name);
        return result != null ? result : items.get("0_" + name);
    }

    @Override
    public void load(@Nonnull BeanContext context) throws IOException {
        if (!this.isLoaded()) {
            PackageRegistries service = (PackageRegistries)context.getService(PackageRegistries.class);
            PackageRegistry registry = service.getRegistries(context.getResolver()).getRegistry(this.getName());
            TreeMap items = new TreeMap();
            this.put("items", items);
            if (registry != null) {
                for (PackageId pckgId : registry.packages()) {
                    GroupNode group = RegistryNode.getGroup(this, pckgId.getGroup());
                    group.addPackage(this.getName(), pckgId);
                }
            }
            this.setLoaded(true);
        }
    }

    @Override
    public void loadForItems(@Nonnull BeanContext context) throws IOException {
        this.load(context);
    }

    protected static GroupNode getGroup(@Nonnull AbstractNode parent, String name) {
        String groupKey;
        String groupName;
        String[] groupPath;
        Map<String, RegistryItem> items = Objects.requireNonNull(parent.getItemsMap());
        if (StringUtils.isNotBlank((CharSequence)name)) {
            groupPath = name.split("/");
            groupName = groupPath[0];
            groupKey = "0_" + groupName;
        } else {
            groupPath = new String[]{"nogroup"};
            groupName = "nogroup";
            groupKey = "1_" + groupName;
        }
        GroupNode group = (GroupNode)items.get(groupKey);
        if (group == null) {
            group = new GroupNode(parent, null, groupName);
            items.put(groupKey, group);
        }
        for (int i = 1; i < groupPath.length; ++i) {
            group = group.getGroup(groupPath[i]);
        }
        return group;
    }
}

