/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.tree;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.tree.AbstractNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.GroupNode;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryItem;
import com.composum.sling.core.pckgmgr.regpckg.tree.RegistryNode;
import com.composum.sling.core.util.ResourceUtil;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;

public class RegistryTree
extends AbstractNode {
    protected final boolean merged;

    public RegistryTree(boolean merged) {
        super((RegistryItem)null);
        this.merged = merged;
        this.put("path", "/");
        this.put("name", "/");
        this.put("text", "Packages");
        this.put("type", "root");
    }

    @Nullable
    public RegistryItem getItem(@Nonnull BeanContext context, @Nonnull String path) throws IOException {
        RegistryItem item = this.getItemInternal(context, path);
        if (item == null) {
            this.compactTree();
            item = this.getItemInternal(context, path);
        }
        if (item == null) {
            item = new GroupNode(null, ResourceUtil.getParent((String)path), ResourceUtil.getName((String)path));
        }
        return item;
    }

    @Nullable
    protected RegistryItem getItemInternal(@Nonnull BeanContext context, @Nonnull String path) throws IOException {
        RegistryItem item = this;
        if (!"/".equals(path)) {
            String[] segments = (path.startsWith("/") ? path.substring(1) : path).split("/");
            int i = 0;
            if (this.merged) {
                if (segments.length > 0) {
                    item.loadForItems(context);
                    RegistryItem found = item.getItem("0_" + segments[i]);
                    if (found == null) {
                        found = item.getItem("1_" + segments[i]);
                    }
                    item = found;
                }
                ++i;
            }
            while (item != null && i < segments.length) {
                item.loadForItems(context);
                item = item.getItem(segments[i]);
                ++i;
            }
        }
        return item;
    }

    @Override
    public void load(@Nonnull BeanContext context) throws IOException {
        if (!this.isLoaded()) {
            TreeMap<String, RegistryNode> items = new TreeMap<String, RegistryNode>();
            this.put("items", items);
            PackageRegistries service = (PackageRegistries)context.getService(PackageRegistries.class);
            if (service != null) {
                PackageRegistries.Registries registries = service.getRegistries(context.getResolver());
                for (String namespace : registries.getNamespaces()) {
                    PackageRegistry registry = Objects.requireNonNull(registries.getRegistry(namespace));
                    if (this.merged) {
                        for (PackageId pckgId : registry.packages()) {
                            GroupNode group = RegistryNode.getGroup(this, pckgId.getGroup());
                            group.addPackage(namespace, pckgId);
                        }
                        continue;
                    }
                    RegistryNode node = new RegistryNode(namespace, registry);
                    items.put("@" + namespace, node);
                }
            }
            this.setLoaded(true);
        }
    }

    @Override
    public void loadForItems(@Nonnull BeanContext context) throws IOException {
        this.load(context);
    }

    @Override
    public void toTree(@Nonnull JsonWriter writer, boolean children, boolean showRoot) throws IOException {
        if (showRoot) {
            super.toTree(writer, children, true);
        } else {
            this.toTreeChildren(writer);
        }
    }

    @Override
    public void compactSubTree() {
        this.getItemsMap().values().forEach(RegistryItem::compactSubTree);
    }

    @Override
    @Nullable
    public RegistryItem getItem(@Nonnull String name) {
        Map<String, RegistryItem> items = Objects.requireNonNull(this.getItemsMap());
        RegistryItem result = items.get(name);
        if (result == null) {
            result = items.get("1_" + name);
        }
        if (result == null) {
            result = items.get("0_" + name);
        }
        return result;
    }
}

