/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.util;

import com.composum.sling.core.pckgmgr.regpckg.util.ComparableVersion;
import java.util.Comparator;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.jackrabbit.vault.packaging.PackageId;

public class VersionComparator
implements Comparator<String> {
    @Override
    public int compare(String o1, String o2) {
        ComparableVersion v1 = new ComparableVersion(o1);
        ComparableVersion v2 = new ComparableVersion(o2);
        return v1.compareTo(v2);
    }

    public static class PackageIdByGroupAndNameComparator
    implements Comparator<PackageId> {
        @Override
        public int compare(PackageId o1, PackageId o2) {
            CompareToBuilder builder = new CompareToBuilder();
            builder.append((Object)o1.getGroup(), (Object)o2.getGroup());
            builder.append((Object)o1.getName(), (Object)o2.getName());
            return builder.toComparison();
        }
    }

    public static class PackageIdComparator
    implements Comparator<PackageId> {
        protected final Comparator<String> myVersionComparator;

        public PackageIdComparator(boolean reverseVersionComparison) {
            this.myVersionComparator = reverseVersionComparison ? new VersionComparator().reversed() : new VersionComparator();
        }

        @Override
        public int compare(PackageId o1, PackageId o2) {
            CompareToBuilder builder = new CompareToBuilder();
            builder.append((Object)o1.getGroup(), (Object)o2.getGroup());
            builder.append((Object)o1.getName(), (Object)o2.getName());
            builder.appendSuper(this.myVersionComparator.compare(o1.getVersionString(), o2.getVersionString()));
            return builder.toComparison();
        }
    }
}

