/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.pckgmgr.regpckg.view;

import com.composum.sling.core.BeanContext;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.pckgmgr.regpckg.service.PackageRegistries;
import com.composum.sling.core.pckgmgr.regpckg.util.RegistryUtil;
import com.composum.sling.core.pckgmgr.regpckg.util.VersionComparator;
import com.composum.sling.core.util.ResourceUtil;
import com.composum.sling.core.util.SlingResourceUtil;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.jackrabbit.vault.packaging.PackageId;
import org.apache.jackrabbit.vault.packaging.registry.PackageRegistry;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/packages/manager")
public class GroupBean
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(GroupBean.class);
    protected transient PackageRegistries.Registries registries;
    protected String namespace;
    protected List<String> packages = Collections.emptyList();
    private List<String> multiVersionPackages = Collections.emptyList();

    public void initialize(BeanContext context, Resource resource) {
        SlingHttpServletRequest request = context.getRequest();
        String path = RegistryUtil.requestPath(request);
        this.namespace = RegistryUtil.namespace(path);
        super.initialize(context, (Resource)new SyntheticResource(context.getResolver(), path, ""));
        try {
            this.load(context);
        }
        catch (IOException ex) {
            LOG.error("Error loading {}", (Object)resource.getPath(), (Object)ex);
        }
    }

    protected void load(BeanContext context) throws IOException {
        if (this.registries == null) {
            PackageRegistries service = (PackageRegistries)context.getService(PackageRegistries.class);
            this.registries = service.getRegistries(context.getResolver());
        }
        PackageRegistry singleRegistry = StringUtils.isNotBlank((CharSequence)this.namespace) ? this.registries.getRegistry(this.namespace) : null;
        Collection<PackageRegistry> regs = this.registries.iterable();
        if (singleRegistry != null) {
            regs = Collections.singletonList(singleRegistry);
        }
        ArrayList<PackageId> registeredpackages = new ArrayList<PackageId>();
        for (PackageRegistry reg : regs) {
            registeredpackages.addAll(reg.packages());
        }
        Map<Pair, List<PackageId>> grouped = registeredpackages.stream().distinct().collect(Collectors.groupingBy(pkg -> Pair.of((Object)pkg.getGroup(), (Object)pkg.getName())));
        VersionComparator.PackageIdComparator comparator = new VersionComparator.PackageIdComparator(false);
        this.packages = this.pathsToHighestVersion(this.getPath(), singleRegistry, comparator, grouped.entrySet().stream());
        String multiVersionSearchPath = this.getPackagePathIfVersion(this.getPath(), registeredpackages, singleRegistry);
        this.multiVersionPackages = this.pathsToHighestVersion(multiVersionSearchPath, singleRegistry, comparator, grouped.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1));
    }

    protected String getPackagePathIfVersion(String path, List<PackageId> registeredpackage, PackageRegistry singleRegistry) {
        Optional<PackageId> correspondingVersion = registeredpackage.stream().filter(pkg -> RegistryUtil.toPath(singleRegistry, pkg).equals(path) || RegistryUtil.toPath((String)null, pkg).equals(path)).findFirst();
        return correspondingVersion.isPresent() ? ResourceUtil.getParent((String)RegistryUtil.toPath(singleRegistry, correspondingVersion.get())) : path;
    }

    protected List<String> pathsToHighestVersion(String path, PackageRegistry singleRegistry, Comparator<PackageId> comparator, Stream<Map.Entry<Pair<String, String>, List<PackageId>>> versionsPackageGrouped) {
        return versionsPackageGrouped.map(entry -> ((List)entry.getValue()).stream().max(comparator)).filter(Optional::isPresent).map(Optional::get).map(pkg -> RegistryUtil.toPath(singleRegistry, pkg)).filter(pkgpath -> SlingResourceUtil.isSameOrDescendant((String)path, (String)pkgpath)).sorted().collect(Collectors.toList());
    }

    public List<String> getPackagePaths() {
        return this.packages;
    }

    public List<String> getMultiVersionPackagePaths() {
        return this.multiVersionPackages;
    }
}

