/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.core;

import com.composum.sling.core.ResourceHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.mapping.MappingRules;
import com.composum.sling.core.servlet.AbstractServiceServlet;
import com.composum.sling.core.servlet.ServletOperation;
import com.composum.sling.core.servlet.ServletOperationSet;
import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.AuthorizablesTree;
import com.composum.sling.core.usermanagement.model.AuthorizablesView;
import com.composum.sling.core.usermanagement.model.GroupModel;
import com.composum.sling.core.usermanagement.model.TreeNode;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.util.ResponseUtil;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.NodesConfiguration;
import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/users/manager")
@Component(service={Servlet.class}, property={"service.description=Composum Nodes User Management Servlet", "sling.servlet.paths=/bin/cpm/usermanagement", "sling.servlet.methods=GET", "sling.servlet.methods=PUT", "sling.servlet.methods=POST", "sling.servlet.methods=DELETE", "sling.auth.requirements=/bin/cpm/usermanagement"})
public class UserManagementServlet
extends AbstractServiceServlet {
    private static final Logger LOG = LoggerFactory.getLogger(UserManagementServlet.class);
    public static final String SERVICE_KEY = "nodes/users/manager";
    public static final String SERVLET_PATH = "/bin/cpm/usermanagement";
    protected ServletOperationSet<Extension, Operation> operations = new ServletOperationSet((Enum)Extension.json);
    @Reference
    private NodesConfiguration coreConfig;
    @Reference
    protected Authorizables authorizablesService;

    public void init() throws ServletException {
        super.init();
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.authorizables, (ServletOperation)new GetAllAuthorizables());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.users, (ServletOperation)new GetUsers());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.user, (ServletOperation)new GetUser());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.groups, (ServletOperation)new GetGroups());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.group, (ServletOperation)new GetGroup());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.tree, (ServletOperation)new GetTree());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.properties, (ServletOperation)new GetProperties());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.groupsofauthorizable, (ServletOperation)new GetGroupsOfAuthorizable());
        this.operations.setOperation(ServletOperationSet.Method.GET, (Enum)Extension.json, (Enum)Operation.query, (ServletOperation)new QueryAuthorizables());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.user, (ServletOperation)new CreateUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.systemuser, (ServletOperation)new CreateSystemUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.group, (ServletOperation)new CreateGroup());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.disable, (ServletOperation)new DisableUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.enable, (ServletOperation)new EnableUser());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.password, (ServletOperation)new ChangePassword());
        this.operations.setOperation(ServletOperationSet.Method.PUT, (Enum)Extension.json, (Enum)Operation.removefromgroup, (ServletOperation)new RemoveFromGroup());
        this.operations.setOperation(ServletOperationSet.Method.POST, (Enum)Extension.json, (Enum)Operation.addtogroup, (ServletOperation)new AddToGroup());
        this.operations.setOperation(ServletOperationSet.Method.DELETE, (Enum)Extension.json, (Enum)Operation.authorizable, (ServletOperation)new DeleteAuthorizable());
    }

    protected ServletOperationSet<Extension, Operation> getOperations() {
        return this.operations;
    }

    public class GetGroup
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
                if (authorizable == null) {
                    ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                } else {
                    Group group = (Group)authorizable;
                    GroupModel groupModel = new GroupModel(context, group);
                    response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                    response.setCharacterEncoding(MappingRules.CHARSET.name());
                    try (JsonWriter writer = new JsonWriter((Writer)response.getWriter());){
                        groupModel.toJson(writer);
                        writer.flush();
                    }
                }
            } else {
                response.sendError(500);
            }
        }
    }

    public class CreateGroup
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String name = XSS.filter((String)request.getParameter("groupname"));
                String intermediatePath = XSS.filter((String)request.getParameter("intermediatePath"));
                Group newGroup = StringUtils.isEmpty((CharSequence)intermediatePath) ? userManager.createGroup(name) : userManager.createGroup(name, () -> name, intermediatePath);
                context.commit();
                GroupModel groupModel = new GroupModel(context, newGroup);
                response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                response.setCharacterEncoding(MappingRules.CHARSET.name());
                try (JsonWriter writer = new JsonWriter((Writer)response.getWriter());){
                    groupModel.toJson(writer);
                    writer.flush();
                }
            } else {
                response.sendError(500);
            }
        }
    }

    public class DeleteAuthorizable
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                String authorizableName = path.substring(path.lastIndexOf(47) + 1);
                if (authorizableName.equals("admin") || authorizableName.equals("anonymous")) {
                    response.sendError(400, authorizableName + " deletion denied. System would have been destroyed.");
                } else {
                    Authorizable authorizable = userManager.getAuthorizable(authorizableName);
                    if (authorizable == null) {
                        authorizable = userManager.getAuthorizableByPath(path);
                    }
                    if (authorizable != null) {
                        Iterator groupIterator = authorizable.declaredMemberOf();
                        while (groupIterator.hasNext()) {
                            Group group = (Group)groupIterator.next();
                            group.removeMember(authorizable);
                        }
                        authorizable.remove();
                        context.commit();
                        ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                    } else {
                        response.sendError(404, authorizableName + " not found.");
                    }
                }
            } else {
                response.sendError(500);
            }
        }
    }

    public class CreateUser
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            block8: {
                try {
                    Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
                    UserManager userManager = context.getUserManager();
                    if (userManager != null) {
                        String username = XSS.filter((String)request.getParameter("username"));
                        String password = XSS.filter((String)request.getParameter("password"));
                        String intermediatePath = XSS.filter((String)request.getParameter("intermediatePath"));
                        User newUser = StringUtils.isEmpty((CharSequence)intermediatePath) ? userManager.createUser(username, password) : userManager.createUser(username, password, () -> username, intermediatePath);
                        context.commit();
                        UserModel userModel = new UserModel(context, newUser);
                        response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                        response.setCharacterEncoding(MappingRules.CHARSET.name());
                        try (JsonWriter writer = new JsonWriter((Writer)response.getWriter());){
                            userModel.toJson(writer);
                            writer.flush();
                            break block8;
                        }
                    }
                    response.sendError(500);
                }
                catch (IllegalArgumentException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    response.sendError(400, e.getMessage());
                }
            }
        }
    }

    public class CreateSystemUser
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException, ServletException {
            block11: {
                try {
                    Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
                    UserManager userManager = context.getUserManager();
                    if (userManager != null) {
                        String username = XSS.filter((String)request.getParameter("username"));
                        String intermediatePath = XSS.filter((String)request.getParameter("intermediatePath"));
                        if (StringUtils.isBlank((CharSequence)intermediatePath)) {
                            intermediatePath = null;
                        }
                        Method method = userManager.getClass().getMethod("createSystemUser", String.class, String.class);
                        Object newUser = method.invoke((Object)userManager, username, intermediatePath);
                        context.commit();
                        UserModel userModel = new UserModel(context, (User)newUser);
                        response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                        response.setCharacterEncoding(MappingRules.CHARSET.name());
                        try (JsonWriter writer = new JsonWriter((Writer)response.getWriter());){
                            userModel.toJson(writer);
                            writer.flush();
                            break block11;
                        }
                    }
                    response.sendError(500);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    response.sendError(400, "createSystemUser is not supported on your system");
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RepositoryException) {
                        throw (RepositoryException)cause;
                    }
                    throw new ServletException(cause);
                }
            }
        }
    }

    public class GetUser
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
                if (authorizable == null) {
                    ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                } else {
                    User user = (User)authorizable;
                    UserModel userModel = new UserModel(context, user);
                    response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
                    response.setCharacterEncoding(MappingRules.CHARSET.name());
                    try (JsonWriter writer = new JsonWriter((Writer)response.getWriter());){
                        userModel.toJson(writer);
                        writer.flush();
                    }
                }
            } else {
                response.sendError(500);
            }
        }
    }

    public class EnableUser
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
                User user = (User)authorizable;
                user.disable(null);
                context.commit();
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            } else {
                response.sendError(500);
            }
        }
    }

    public class DisableUser
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String username = XSS.filter((String)request.getParameter("username"));
                String reason = XSS.filter((String)request.getParameter("reason"));
                Authorizable authorizable = userManager.getAuthorizable(username);
                User user = (User)authorizable;
                user.disable(reason);
                context.commit();
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            } else {
                response.sendError(500);
            }
        }
    }

    public class ChangePassword
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String username = XSS.filter((String)request.getParameter("username"));
                String password = XSS.filter((String)request.getParameter("password"));
                Authorizable authorizable = userManager.getAuthorizable(username);
                User target = (User)authorizable;
                Authorizable agent = userManager.getAuthorizable(context.getResolver().getUserID());
                if (agent instanceof User && ((User)agent).isAdmin()) {
                    target.changePassword(password);
                } else {
                    String oldPassword = XSS.filter((String)request.getParameter("oldPassword"));
                    target.changePassword(password, oldPassword);
                }
                context.commit();
                ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
            } else {
                response.sendError(500);
            }
        }
    }

    public class GetProperties
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                String[] split = path.split("/");
                String userid = split[1];
                String propPath = split[2];
                Authorizable authorizable = userManager.getAuthorizable(userid);
                try {
                    Iterator propertyNames = authorizable.getPropertyNames(propPath);
                    HashMap<String, String> p = new HashMap<String, String>();
                    while (propertyNames.hasNext()) {
                        String name = (String)propertyNames.next();
                        Value[] property = authorizable.getProperty(propPath + "/" + name);
                        p.put(name, property[0].getString());
                    }
                    try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                        jsonWriter.beginArray();
                        for (Map.Entry e : p.entrySet()) {
                            jsonWriter.beginObject().name("name").value((String)e.getKey()).name("value").value((String)e.getValue()).endObject();
                        }
                        jsonWriter.endArray();
                        jsonWriter.flush();
                    }
                }
                catch (RepositoryException e) {
                    ResponseUtil.writeEmptyArray((SlingHttpServletResponse)response);
                }
            } else {
                response.sendError(500);
            }
        }
    }

    public class RemoveFromGroup
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                Gson gson = new Gson();
                Map p = (Map)gson.fromJson((Reader)new InputStreamReader((InputStream)request.getInputStream(), MappingRules.CHARSET.name()), Map.class);
                String authorizableName = XSS.filter((String)((String)p.get("authorizable")));
                String groupName = XSS.filter((String)((String)p.get("group")));
                Authorizable authorizable = userManager.getAuthorizable(authorizableName);
                Group group = (Group)userManager.getAuthorizable(groupName);
                group.removeMember(authorizable);
                context.commit();
            } else {
                response.sendError(500);
            }
        }
    }

    public class AddToGroup
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String authorizableName = XSS.filter((String)request.getParameter("authorizable"));
                String groupName = XSS.filter((String)request.getParameter("group"));
                Authorizable authorizable = userManager.getAuthorizable(authorizableName);
                Group group = (Group)userManager.getAuthorizable(groupName);
                boolean b = group.addMember(authorizable);
                context.commit();
            } else {
                response.sendError(500);
            }
        }
    }

    public class GetGroupsOfAuthorizable
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
                Authorizable authorizable = userManager.getAuthorizable(path.startsWith("/") ? path.substring(1) : path);
                Iterator groupIterator = authorizable.declaredMemberOf();
                try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                    jsonWriter.beginArray();
                    while (groupIterator.hasNext()) {
                        Group group = (Group)groupIterator.next();
                        jsonWriter.value(group.getID());
                    }
                    jsonWriter.endArray();
                    jsonWriter.flush();
                }
            } else {
                response.sendError(500);
            }
        }
    }

    public class QueryAuthorizables
    extends GetAuthorizables<Authorizable, AuthorizableModel> {
        public QueryAuthorizables() {
            super(null);
        }

        @Override
        protected AuthorizablesView createView(Authorizables.Context context) throws RepositoryException {
            SlingHttpServletRequest request = context.getRequest();
            return new AuthorizablesView(context, XSS.filter((String)request.getParameter("type")), XSS.filter((String)request.getParameter("name")), XSS.filter((String)request.getParameter("path")));
        }
    }

    public class GetGroups
    extends GetAuthorizables<Group, GroupModel> {
        public GetGroups() {
            super(Group.class);
        }
    }

    public class GetUsers
    extends GetAuthorizables<User, UserModel> {
        public GetUsers() {
            super(User.class);
        }
    }

    public class GetAllAuthorizables
    extends GetAuthorizables<Authorizable, AuthorizableModel> {
        public GetAllAuthorizables() {
            super(Authorizable.class);
        }
    }

    public abstract class GetAuthorizables<A extends Authorizable, E extends AuthorizableModel>
    implements ServletOperation {
        protected final Class<A> authorizableClass;

        public GetAuthorizables(Class<A> authorizableClass) {
            this.authorizableClass = authorizableClass;
        }

        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            AuthorizablesView view = this.createView(new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response));
            response.setContentType(ResponseUtil.JSON_CONTENT_TYPE);
            response.setCharacterEncoding(MappingRules.CHARSET.name());
            try (JsonWriter writer = new JsonWriter((Writer)response.getWriter());){
                writer.beginArray();
                for (AuthorizableModel model : view.getAuthorizableModels()) {
                    model.toJson(writer);
                }
                writer.endArray();
                writer.flush();
            }
        }

        protected AuthorizablesView createView(Authorizables.Context context) throws RepositoryException {
            return new AuthorizablesView(context, this.authorizableClass, null, null);
        }
    }

    public class GetTree
    implements ServletOperation {
        public void doIt(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, ResourceHandle resource) throws RepositoryException, IOException {
            AuthorizablesTree tree;
            TreeNode node;
            ResourceResolver resolver = request.getResourceResolver();
            Authorizables.Context context = new Authorizables.Context(UserManagementServlet.this.authorizablesService, request, response);
            String path = AbstractServiceServlet.getPath((SlingHttpServletRequest)request);
            if (StringUtils.isBlank((CharSequence)path) || "/".equals(path)) {
                path = "/home";
            }
            if ((node = (tree = new AuthorizablesTree(context, null, null, "^" + path + "(/.*)?")).getRootNode().getNode(path)) != null) {
                try (JsonWriter jsonWriter = ResponseUtil.getJsonWriter((SlingHttpServletResponse)response);){
                    node.toJson(jsonWriter, false);
                }
            }
        }
    }

    public static enum Operation {
        users,
        user,
        groups,
        tree,
        group,
        authorizable,
        disable,
        enable,
        password,
        groupsofauthorizable,
        removefromgroup,
        addtogroup,
        query,
        systemuser,
        authorizables,
        properties;

    }

    public static enum Extension {
        json,
        html;

    }
}

