/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.core.impl;

import com.composum.sling.core.usermanagement.core.UserManagementService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class UserMgmtServiceImpl
implements UserManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(UserMgmtServiceImpl.class);

    @Override
    public Authorizable getOrCreateUser(JackrabbitSession session, UserManager userManager, String path, boolean systemUser) throws RepositoryException {
        String[] pathAndName = this.pathAndName(path);
        Authorizable user = userManager.getAuthorizable(pathAndName[1]);
        LOG.debug("user.check: " + pathAndName[1] + " - " + user);
        if (user == null) {
            LOG.info("user.create: " + pathAndName[1]);
            NamePrincipal principal = new NamePrincipal(pathAndName[1]);
            if (systemUser) {
                try {
                    Method createSystemUser = userManager.getClass().getMethod("createSystemUser", String.class, String.class);
                    user = (User)createSystemUser.invoke((Object)userManager, pathAndName[1], pathAndName[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                    LOG.error(ex.toString());
                }
            } else {
                user = userManager.createUser(pathAndName[1], pathAndName[1], (Principal)principal, pathAndName[0]);
            }
        }
        return user;
    }

    @Override
    public Group getOrCreateGroup(JackrabbitSession session, UserManager userManager, String path) throws RepositoryException {
        String[] pathAndName = this.pathAndName(path);
        Group group = (Group)userManager.getAuthorizable(pathAndName[1]);
        LOG.debug("group.check: " + pathAndName[1] + " - " + group);
        if (group == null) {
            LOG.info("group.create: " + pathAndName[1]);
            group = userManager.createGroup((Principal)new NamePrincipal(pathAndName[1]), pathAndName[0]);
        }
        return group;
    }

    @Override
    public void assignToGroup(JackrabbitSession session, UserManager userManager, Authorizable authorizable, String groupName) throws RepositoryException {
        if (authorizable != null) {
            Group group = (Group)userManager.getAuthorizable(groupName);
            if (group != null) {
                if (!group.isMember(authorizable)) {
                    LOG.info("assign.member: " + authorizable.getID() + " to group: " + groupName);
                    group.addMember(authorizable);
                }
            } else {
                LOG.error("group not found: " + groupName);
            }
        }
    }

    @Override
    public void assignToGroup(JackrabbitSession session, UserManager userManager, String memberName, Group group) throws RepositoryException {
        Authorizable authorizable;
        if (group != null && (authorizable = userManager.getAuthorizable(memberName)) != null && !group.isMember(authorizable)) {
            LOG.info("assign.member: " + authorizable.getID() + " to group: " + group.getID());
            group.addMember(authorizable);
        }
    }

    protected String[] pathAndName(String pathAndName) {
        int pathEnd = pathAndName.lastIndexOf(47);
        String[] result = new String[]{pathEnd > 0 ? pathAndName.substring(0, pathEnd) : "", pathAndName.substring(pathEnd + 1)};
        return result;
    }

    protected class NamePrincipal
    implements Principal {
        private final String name;

        public NamePrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

