/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.AuthorizablesMap;
import com.composum.sling.core.usermanagement.model.AuthorizablesView;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.service.Authorizables;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthorizablesGraph
extends AuthorizablesMap {
    public static final Map<String, Object> DEFAULT_NODE_CFG = new HashMap<String, Object>(){
        {
            this.put("style", "filled");
            this.put("fontname", "sans-serif");
            this.put("fontsize", "10.0");
        }
    };

    public AuthorizablesGraph(@NotNull Authorizables.Context context, @Nullable String selector, @Nullable String nameQueryPattern, @Nullable String pathPattern) throws RepositoryException {
        this(context, Authorizables.selector(selector), nameQueryPattern, StringUtils.isNotBlank((CharSequence)pathPattern) ? new Authorizables.Filter.Path(pathPattern) : null);
    }

    public AuthorizablesGraph(@NotNull Authorizables.Context context, @Nullable Class<? extends Authorizable> selector, @Nullable String nameQueryPattern, @Nullable Authorizables.Filter filter) throws RepositoryException {
        super(context, selector, nameQueryPattern, filter);
    }

    @Override
    protected void extendedScan(@Nullable Class<? extends Authorizable> selector, @Nullable Authorizables.Filter filter, @Nullable Set<String> singleFocusDone) throws RepositoryException {
        if (this.singleFocus != null && singleFocusDone != null) {
            this.addSourceRelations(selector, filter, this.singleFocus, singleFocusDone);
        }
    }

    public void toGraphviz(@NotNull Writer writer, @Nullable Resource config, @Nullable AuthorizablesView.NodeUrlBuilder urlBuilder) throws IOException {
        writer.append("digraph {\n");
        this.writeConfig(writer, config, "graph", null);
        this.writeConfig(writer, config, "node", DEFAULT_NODE_CFG);
        for (AuthorizableModel node : this.nodes.values()) {
            String id = node.getId();
            String path = node.getPath();
            String name = node.getPrincipalName();
            String label = !id.equals(name) ? id + "\n" + name : id;
            String url = urlBuilder != null ? urlBuilder.buildUrl(node) : null;
            writer.append("    ").append(((Integer)this.indexes.get(node.getId())).toString()).append(" [");
            writer.append(" id=\"").append(id).append("\"");
            if (this.singleFocus != null && this.singleFocus.getId().equals(node.getId())) {
                writer.append(" root=\"true\"");
            }
            writer.append(" label=\"").append(label).append("\"");
            writer.append(" tooltip=\"").append(path).append("\"");
            if (StringUtils.isNotBlank((CharSequence)url)) {
                writer.append(" href=\"").append(url).append("\"");
            }
            writer.append(" fillcolor=\"").append(this.getColor(node)).append("\"");
            writer.append(" ]\n");
        }
        for (AuthorizablesMap.Relation relation : this.sourceRelations) {
            writer.append("    ").append(((Integer)this.indexes.get(relation.source.getId())).toString()).append(" -> ").append(((Integer)this.indexes.get(relation.target.getId())).toString()).append("\n");
        }
        for (AuthorizablesMap.Relation relation : this.targetRelations) {
            writer.append("    ").append(((Integer)this.indexes.get(relation.source.getId())).toString()).append(" -> ").append(((Integer)this.indexes.get(relation.target.getId())).toString()).append("\n");
        }
        writer.append("}\n");
    }

    protected void writeConfig(@NotNull Writer writer, @Nullable Resource configResource, @NotNull String type, @Nullable Map<String, Object> defaultCfg) throws IOException {
        ValueMap config;
        Resource cfgNode = configResource != null ? configResource.getChild(type) : null;
        ValueMap valueMap = config = cfgNode != null ? cfgNode.getValueMap() : defaultCfg;
        if (config != null) {
            writer.append("    ").append(type).append(" [");
            for (Map.Entry entry : config.entrySet()) {
                Object value;
                String key = (String)entry.getKey();
                if (key.startsWith("jcr:") || (value = entry.getValue()) == null) continue;
                writer.append(" ").append(key).append("=");
                if (value instanceof String) {
                    writer.append("\"").append(value.toString()).append("\"");
                    continue;
                }
                writer.append(value.toString());
            }
            writer.append(" ]\n");
        }
    }

    protected String getColor(AuthorizableModel node) {
        boolean isFocussed;
        boolean bl = isFocussed = this.singleFocus != null && this.singleFocus.getId().equals(node.getId());
        if (node.isGroup()) {
            return isFocussed ? "#cccccc" : "#eeeeee";
        }
        UserModel user = (UserModel)node;
        if (user.isDisabled()) {
            return isFocussed ? "#d4a5a4" : "#e0c6c6";
        }
        if (user.isAdmin()) {
            return isFocussed ? "#abd5ab" : "#d6f1d7";
        }
        if (user.isServiceUser()) {
            return isFocussed ? "#b5a3ce" : "#d8cfe5";
        }
        if (user.isSystemUser()) {
            return isFocussed ? "#96b6c6" : "#c7dbe5";
        }
        return isFocussed ? "#aac9aa" : "#d3e3d3";
    }
}

