/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.AuthorizablesView;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AuthorizablesMap
extends AuthorizablesView {
    protected final Set<Relation> targetRelations = new HashSet<Relation>();
    protected final Set<Relation> sourceRelations = new HashSet<Relation>();

    public AuthorizablesMap(@NotNull Authorizables.Context context, @Nullable Class<? extends Authorizable> selector, @Nullable String nameQueryPattern, @Nullable Authorizables.Filter filter) throws RepositoryException {
        super(context, selector, nameQueryPattern, filter);
        this.scanRelations(selector, filter);
    }

    protected void scanRelations(@Nullable Class<? extends Authorizable> selector, @Nullable Authorizables.Filter filter) throws RepositoryException {
        HashSet<String> singleFocusDone = this.singleFocus != null ? new HashSet<String>() : null;
        for (AuthorizableModel source : this.nodes.values()) {
            this.addTargetRelations(source, singleFocusDone);
        }
        this.extendedScan(selector, filter, singleFocusDone);
    }

    protected void extendedScan(@Nullable Class<? extends Authorizable> selector, @Nullable Authorizables.Filter filter, @Nullable Set<String> singleFocusDone) throws RepositoryException {
    }

    protected void addTargetRelations(@NotNull AuthorizableModel source, @Nullable Set<String> done) throws RepositoryException {
        String id = source.getId();
        if (done != null && !done.add(id)) {
            return;
        }
        for (String targetId : source.getDeclaredMemberOf()) {
            AuthorizableModel target = (AuthorizableModel)this.nodes.get(targetId);
            if (target == null && done != null) {
                target = this.addNode(this.context.getService().getAuthorizable(this.context, targetId));
            }
            if (target == null) continue;
            this.targetRelations.add(new Relation(source, target));
            if (done == null) continue;
            this.addTargetRelations(target, done);
        }
    }

    protected void addSourceRelations(@Nullable Class<? extends Authorizable> selector, @Nullable Authorizables.Filter filter, @NotNull AuthorizableModel target, @NotNull Set<String> done) throws RepositoryException {
        Set<Authorizable> sources = this.context.getService().findAuthorizables(this.context, selector, null, authorizable -> (filter == null || filter.accept(authorizable)) && this.isSourceOfTarget(authorizable, target.getId()));
        for (Authorizable source : sources) {
            if (!done.add(source.getID())) continue;
            this.sourceRelations.add(new Relation(this.addNode(source), target));
        }
    }

    protected boolean isSourceOfTarget(Authorizable source, String targetId) throws RepositoryException {
        Iterator targets = source.declaredMemberOf();
        while (targets.hasNext()) {
            if (!targetId.equals(((Group)targets.next()).getID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toJson(@NotNull JsonWriter writer) throws IOException {
        writer.beginObject();
        if (this.singleFocus != null) {
            writer.name("focus");
            this.singleFocus.toJson(writer);
            writer.name("sources").beginArray();
            for (Relation relation : this.sourceRelations) {
                relation.source.toJson(writer);
            }
            writer.endArray();
            writer.name("targets").beginArray();
            for (Relation relation : this.targetRelations) {
                relation.target.toJson(writer);
            }
            writer.endArray();
        } else {
            writer.name("nodes").beginArray();
            for (AuthorizableModel node : this.nodes.values()) {
                node.toJson(writer);
            }
            writer.endArray();
            writer.name("relations").beginArray();
            for (Relation relation : this.targetRelations) {
                writer.beginObject();
                writer.name("source").value(relation.source.getId());
                writer.name("target").value(relation.target.getId());
                writer.endObject();
            }
            writer.endArray();
        }
        writer.endObject();
    }

    protected class Relation {
        protected final AuthorizableModel source;
        protected final AuthorizableModel target;

        public Relation(@NotNull AuthorizableModel source, AuthorizableModel target) {
            this.source = source;
            this.target = target;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            if (!(other instanceof Relation)) return false;
            Relation otherRel = (Relation)other;
            if (!otherRel.target.equals(this.target)) return false;
            if (!otherRel.source.equals(this.source)) return false;
            return true;
        }

        public int hashCode() {
            return this.source.hashCode() + this.target.hashCode();
        }
    }
}

