/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.jetbrains.annotations.NotNull;

public class GroupModel
extends AuthorizableModel {
    protected final Set<String> members;
    protected final Set<String> declaredMembers;
    private transient Collection<UserModel> users;
    private transient Collection<UserModel> declaredUsers;
    private transient Collection<GroupModel> groups;
    private transient Collection<GroupModel> declaredGroups;

    public GroupModel(@NotNull Authorizables.Context context, @NotNull Group jcrGroup) throws RepositoryException {
        super(context, (Authorizable)jcrGroup);
        this.members = GroupModel.stripIDs(jcrGroup.getMembers());
        this.declaredMembers = GroupModel.stripIDs(jcrGroup.getDeclaredMembers());
    }

    @Override
    protected int getRank() {
        return 3;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @NotNull
    public Set<String> getMembers() {
        return this.members;
    }

    @NotNull
    public Set<String> getDeclaredMembers() {
        return this.declaredMembers;
    }

    @NotNull
    public Collection<UserModel> getUsers() throws RepositoryException {
        if (this.users == null) {
            this.users = GroupModel.getUsers(this.context, this.getMembers());
        }
        return this.users;
    }

    @NotNull
    public Collection<UserModel> getDeclaredUsers() throws RepositoryException {
        if (this.declaredUsers == null) {
            this.declaredUsers = GroupModel.getUsers(this.context, this.getDeclaredMembers());
        }
        return this.declaredUsers;
    }

    @NotNull
    public Collection<GroupModel> getGroups() throws RepositoryException {
        if (this.groups == null) {
            this.groups = GroupModel.getGroups(this.context, this.getMembers());
        }
        return this.groups;
    }

    @NotNull
    public Collection<GroupModel> getDeclaredGroups() throws RepositoryException {
        if (this.declaredGroups == null) {
            this.declaredGroups = GroupModel.getGroups(this.context, this.getDeclaredMembers());
        }
        return this.declaredGroups;
    }

    @Override
    protected void toJsonData(JsonWriter writer) throws IOException {
        super.toJsonData(writer);
        writer.name("declaredMembers").beginArray();
        for (String id : this.getDeclaredMembers()) {
            writer.value(id);
        }
        writer.endArray();
        writer.name("members").beginArray();
        for (String id : this.getMembers()) {
            writer.value(id);
        }
        writer.endArray();
    }
}

