/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.AuthorizablesMap;
import com.composum.sling.core.usermanagement.model.AuthorizablesRefs;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserModel
extends AuthorizableModel {
    private static final Logger LOG = LoggerFactory.getLogger(UserModel.class);
    protected final ValueMap values;
    protected final boolean admin;
    protected final boolean systemUser;
    protected final boolean disabled;
    protected final String disabledReason;
    private transient Collection<AuthorizableModel> serviceUsers;

    public UserModel(@NotNull Authorizables.Context context, @NotNull User jcrUser) throws RepositoryException {
        this(context, (Authorizable)jcrUser);
    }

    protected UserModel(@NotNull Authorizables.Context context, @NotNull Authorizable authorizable) throws RepositoryException {
        super(context, authorizable);
        if (authorizable instanceof User) {
            User jcrUser = (User)authorizable;
            this.admin = jcrUser.isAdmin();
            this.systemUser = jcrUser.isSystemUser();
            this.disabled = jcrUser.isDisabled();
            this.disabledReason = jcrUser.getDisabledReason();
        } else {
            this.admin = false;
            this.systemUser = true;
            this.disabled = false;
            this.disabledReason = null;
        }
        TreeMap<String, String[]> properties = new TreeMap<String, String[]>();
        Iterator propertyNames = authorizable.getPropertyNames();
        while (propertyNames.hasNext()) {
            String name = (String)propertyNames.next();
            Value[] property = authorizable.getProperty(name);
            String[] vs = new String[property.length];
            for (int i = 0; i < property.length; ++i) {
                vs[i] = property[i].getString();
            }
            properties.put(name, vs);
        }
        this.values = new ValueMapDecorator(properties);
    }

    @Override
    protected int getRank() {
        return 1;
    }

    @Override
    public boolean isGroup() {
        return false;
    }

    @Override
    @NotNull
    public String getTypeIcon() {
        return this.isSystemUser() && !this.isServiceUser() ? "user-o" : (String)TYPE_TO_ICON.get(this.getType());
    }

    public boolean isAdmin() {
        return this.admin;
    }

    public boolean isSystemUser() {
        return this.systemUser;
    }

    public boolean isServiceUser() {
        return false;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @Nullable
    public String getDisabledReason() {
        return this.disabledReason;
    }

    public Collection<AuthorizableModel> getServiceUsers() {
        if (this.serviceUsers == null) {
            this.serviceUsers = new ArrayList<AuthorizableModel>();
            try {
                AuthorizablesRefs refs = new AuthorizablesRefs(this.context, null, this.getId());
                for (AuthorizablesMap.Relation relation : refs.sourceRelations) {
                    this.serviceUsers.add(relation.source);
                }
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return this.serviceUsers;
    }

    @Override
    protected void toJsonData(JsonWriter writer) throws IOException {
        super.toJsonData(writer);
        writer.name("admin").value(this.isAdmin());
        writer.name("system").value(this.isSystemUser());
        writer.name("disabled").value(this.isDisabled());
        if (StringUtils.isNotBlank((CharSequence)this.getDisabledReason())) {
            writer.name("reason").value(this.getDisabledReason());
        }
        for (Map.Entry property : this.values.entrySet()) {
            Object value = property.getValue();
            if (value == null) continue;
            writer.name((String)property.getKey()).value(value.toString());
        }
        writer.name("systemUser").value(this.isSystemUser());
    }
}

