/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.service;

import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.usermanagement.service.GroupFacade;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.sling.serviceusermapping.Mapping;

public class ServiceUser
implements Authorizable {
    public static final String SERVICE_USER_ROOT = "/home/services";
    protected final String serviceName;
    protected final String serviceInfo;
    protected final String id;
    protected final String path;
    protected final Mapping mapping;
    protected final Principal principal;
    private transient Set<Group> declaredMemberOf;
    private transient Set<Group> memberOf;

    public ServiceUser(Authorizables.Context context, Mapping mapping) throws RepositoryException {
        this.mapping = mapping;
        this.serviceName = mapping.getServiceName();
        this.serviceInfo = mapping.getSubServiceName();
        if (StringUtils.isNotBlank((CharSequence)this.serviceInfo)) {
            this.id = this.serviceName + ":" + this.serviceInfo;
            this.path = "/home/services/" + this.serviceName.replace('.', '/') + "/" + this.serviceInfo;
        } else {
            this.id = this.serviceName;
            this.path = "/home/services/" + this.serviceName.replace('.', '/');
        }
        this.principal = new ServicePrincipal();
    }

    public void initialize(Authorizables.Context context) throws RepositoryException {
        if (this.declaredMemberOf == null) {
            Iterable principals;
            Authorizable authorizable;
            this.declaredMemberOf = new LinkedHashSet<Group>();
            this.memberOf = new LinkedHashSet<Group>();
            String user = this.mapping.map(this.mapping.getServiceName(), this.mapping.getSubServiceName());
            if (StringUtils.isNotBlank((CharSequence)user) && (authorizable = context.getService().getAuthorizable(context, user)) != null) {
                this.declaredMemberOf.add(new GroupFacade(authorizable, this));
            }
            if ((principals = this.mapping.mapPrincipals(this.mapping.getServiceName(), this.mapping.getSubServiceName())) != null) {
                for (String principal : principals) {
                    authorizable = context.getService().getAuthorizable(context, principal);
                    if (authorizable == null) continue;
                    this.declaredMemberOf.add(new GroupFacade(authorizable, this));
                }
            }
            for (Group group : this.declaredMemberOf) {
                this.memberOf.add(group);
                Iterator groups = group.memberOf();
                while (groups.hasNext()) {
                    this.memberOf.add((Group)groups.next());
                }
            }
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceInfo() {
        return this.serviceInfo;
    }

    public String getID() {
        return this.id;
    }

    public boolean isGroup() {
        return false;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Iterator<Group> declaredMemberOf() {
        return this.declaredMemberOf.iterator();
    }

    public Iterator<Group> memberOf() {
        return this.memberOf.iterator();
    }

    public void remove() throws RepositoryException {
    }

    public Iterator<String> getPropertyNames() {
        return Collections.emptyIterator();
    }

    public Iterator<String> getPropertyNames(String relPath) {
        return Collections.emptyIterator();
    }

    public boolean hasProperty(String relPath) {
        return false;
    }

    public void setProperty(String relPath, Value value) {
    }

    public void setProperty(String relPath, Value[] value) {
    }

    public Value[] getProperty(String relPath) {
        return new Value[0];
    }

    public boolean removeProperty(String relPath) {
        return false;
    }

    public String getPath() {
        return this.path;
    }

    public class ServicePrincipal
    implements Principal {
        @Override
        public String getName() {
            return ServiceUser.this.getID();
        }
    }
}

