/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.service.impl;

import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.usermanagement.service.ServiceUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.serviceusermapping.Mapping;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AuthorizablesImpl
implements Authorizables {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizablesImpl.class);
    @Reference
    protected ServiceUserMapper serviceUserMapper;
    private boolean incompatibleServiceMapper = false;

    @Activate
    protected void activate() {
        this.incompatibleServiceMapper = false;
    }

    @Override
    @Nullable
    public Authorizable getAuthorizable(@NotNull Authorizables.Context context, @NotNull String id) throws RepositoryException {
        Authorizable authorizable = context.getAuthorizables().get(id);
        if (authorizable == null) {
            UserManager userManager = context.getUserManager();
            if (userManager != null) {
                authorizable = userManager.getAuthorizable(id);
            }
            if (authorizable == null) {
                authorizable = this.getServiceUser(context, id);
            }
            if (authorizable != null) {
                context.getAuthorizables().put(id, authorizable);
            }
            if (authorizable instanceof ServiceUser) {
                ((ServiceUser)authorizable).initialize(context);
            }
        }
        return authorizable;
    }

    @Override
    @NotNull
    public Set<Authorizable> findAuthorizables(@NotNull Authorizables.Context context, @Nullable Class<? extends Authorizable> selector, @Nullable String nameQueryPattern, @Nullable Authorizables.Filter filter) throws RepositoryException {
        UserManager userManager;
        HashSet<Authorizable> result = new HashSet<Authorizable>();
        if (StringUtils.isNotBlank((CharSequence)nameQueryPattern)) {
            nameQueryPattern = nameQueryPattern.replaceAll("\\.\\*", "%").replace('*', '%');
        }
        if ((userManager = context.getUserManager()) != null) {
            Iterator<Authorizable> iterator = this.findAuthorizables(context, selector, nameQueryPattern);
            while (iterator.hasNext()) {
                Authorizable authorizable = iterator.next();
                if (filter != null && !filter.accept(authorizable)) continue;
                result.add(authorizable);
            }
        }
        for (Authorizable authorizable : this.findServiceUsers(context, selector, nameQueryPattern)) {
            if (filter != null && !filter.accept(authorizable)) continue;
            result.add(authorizable);
        }
        return result;
    }

    @Override
    @NotNull
    public <T extends Authorizable> Collection<T> loadAuthorizables(@NotNull Authorizables.Context context, @NotNull Class<T> selector, @NotNull Set<String> idSet) throws RepositoryException {
        ArrayList<Authorizable> result = new ArrayList<Authorizable>();
        UserManager userManager = context.getUserManager();
        for (String id : idSet) {
            Authorizable authorizable = this.getAuthorizable(context, id);
            if (!selector.isInstance(authorizable)) continue;
            result.add((Authorizable)selector.cast(authorizable));
        }
        return result;
    }

    @NotNull
    protected Iterator<Authorizable> findAuthorizables(@NotNull Authorizables.Context context, final @Nullable Class<? extends Authorizable> selector, final @Nullable String nameQueryPattern) throws RepositoryException {
        UserManager userManager;
        if (!(selector != null && selector.equals(ServiceUser.class) || (userManager = context.getUserManager()) == null)) {
            Query authorizableQuery = new Query(){

                public <T> void build(QueryBuilder<T> builder) {
                    builder.setCondition(builder.nameMatches(StringUtils.isNotBlank((CharSequence)nameQueryPattern) ? nameQueryPattern : "%"));
                    builder.setSortOrder("@name", QueryBuilder.Direction.ASCENDING);
                    if (selector != null) {
                        builder.setSelector(selector);
                    }
                }
            };
            return userManager.findAuthorizables(authorizableQuery);
        }
        return Collections.emptyIterator();
    }

    @NotNull
    protected List<ServiceUser> findServiceUsers(@NotNull Authorizables.Context context, @Nullable Class<? extends Authorizable> selector, @Nullable String nameQueryPattern) throws RepositoryException {
        ArrayList<ServiceUser> serviceUsers = new ArrayList<ServiceUser>();
        if (!this.incompatibleServiceMapper && (selector == null || selector.equals(ServiceUser.class))) {
            Pattern namePattern = StringUtils.isNotBlank((CharSequence)nameQueryPattern) ? Pattern.compile("^" + nameQueryPattern.replaceAll("%", ".*") + "$") : null;
            try {
                List mappings = this.serviceUserMapper.getActiveMappings();
                for (Mapping mapping : mappings) {
                    ServiceUser service = new ServiceUser(context, mapping);
                    if (namePattern != null && !namePattern.matcher(service.getID()).matches()) continue;
                    service.initialize(context);
                    serviceUsers.add(service);
                }
            }
            catch (NoSuchMethodError nsme) {
                this.incompatibleServiceMapper = true;
                LOG.warn("incompatible ServiceUserMapper - no service user support (" + nsme + ")");
            }
        }
        return serviceUsers;
    }

    @Nullable
    protected ServiceUser getServiceUser(@NotNull Authorizables.Context context, @NotNull String id) throws RepositoryException {
        List mappings = this.serviceUserMapper.getActiveMappings();
        for (Mapping mapping : mappings) {
            ServiceUser service = new ServiceUser(context, mapping);
            if (!id.equals(service.getID())) continue;
            return service;
        }
        return null;
    }
}

