/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.view;

import com.composum.sling.core.user.UserProfile;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.view.View;
import java.util.Objects;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.jetbrains.annotations.NotNull;

public class User
extends View {
    private transient Boolean isAdmin;
    private transient UserProfile profile;

    @Override
    @NotNull
    protected Class<? extends Authorizable> getSelector() {
        return org.apache.jackrabbit.api.security.user.User.class;
    }

    @NotNull
    public UserModel getUser() {
        return (UserModel)Objects.requireNonNull(this.getModel());
    }

    public boolean getHasProfile() {
        return this.getProfile().isValid();
    }

    @NotNull
    public UserProfile getProfile() {
        if (this.profile == null) {
            String profilePath = this.getPath() + "/" + "profile";
            Resource profileRes = this.getResolver().getResource(profilePath);
            this.profile = new UserProfile(this.context, (Resource)(profileRes != null ? profileRes : new SyntheticResource(this.getResolver(), profilePath, null)));
        }
        return this.profile;
    }

    public String getUserLabel() {
        if (this.isAdmin()) {
            return "Administrator";
        }
        if (this.isSystemUser()) {
            return "System User";
        }
        return "User";
    }

    public boolean isSystemUser() {
        return this.getUser().isSystemUser();
    }

    public boolean isAdmin() {
        return this.getUser().isAdmin();
    }

    public boolean isDisabled() {
        return this.getUser().isDisabled();
    }

    public String getDisabledReason() {
        return this.getUser().getDisabledReason();
    }

    public boolean isCurrentUserAdmin() throws RepositoryException {
        if (this.isAdmin == null) {
            this.isAdmin = false;
            JackrabbitSession session = (JackrabbitSession)this.getSession();
            UserManager userManager = session.getUserManager();
            Authorizable a = userManager.getAuthorizable(this.getRequest().getUserPrincipal());
            if (a instanceof org.apache.jackrabbit.api.security.user.User) {
                this.isAdmin = ((org.apache.jackrabbit.api.security.user.User)a).isAdmin();
            }
        }
        return this.isAdmin;
    }
}

