/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.model;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.ServiceUserModel;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeNode {
    public static final String TYPE_ROOT = "root";
    public static final String TYPE_FOLDER = "folder";
    public static final Map<String, String> PATH_TO_TYPE = new HashMap<String, String>(){
        {
            this.put("/home/groups", "group");
            this.put("/home/services", "service");
            this.put("/home/users", "user");
        }
    };
    public static final Comparator<TreeNode> NODE_COMPARATOR = new Comparator<TreeNode>(){

        @Override
        public int compare(TreeNode node1, TreeNode node2) {
            return this.getKey(node1).compareTo(this.getKey(node2));
        }

        protected String getKey(TreeNode node) {
            return node.getType().charAt(0) + ":" + node.getName();
        }
    };
    protected final String type;
    protected final String name;
    protected final String path;
    protected final AuthorizableModel model;
    protected final Map<String, TreeNode> children = new HashMap<String, TreeNode>();
    private transient List<TreeNode> nodes;

    public TreeNode(@NotNull String type, @NotNull String path) {
        this.model = null;
        this.type = type;
        this.path = path;
        this.name = TreeNode.getName(path);
    }

    public TreeNode(AuthorizableModel model) {
        this.model = model;
        this.type = model.getType();
        this.name = model.getId();
        this.path = model.path;
    }

    public boolean isAuthorizable() {
        return this.getModel() != null;
    }

    @Nullable
    public AuthorizableModel getModel() {
        return this.model;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public TreeNode getNode(@NotNull String nodePath) {
        String path = this.getPath();
        if (path.equals(nodePath)) {
            return this;
        }
        if (nodePath.startsWith(path + "/")) {
            String name;
            String[] segments = StringUtils.split((String)nodePath.substring(path.length() + 1), (String)"/");
            TreeNode found = this;
            String[] stringArray = segments;
            int n = stringArray.length;
            for (int i = 0; i < n && (found = found.children.get(name = stringArray[i])) != null; ++i) {
            }
            return found;
        }
        return null;
    }

    public void addNode(@NotNull TreeNode treeNode) {
        String path;
        String nodePath = treeNode.getPath();
        if (nodePath.startsWith((path = this.getPath()) + "/")) {
            this.nodes = null;
            String relativePath = nodePath.substring(path.length() + 1);
            int nextPathSep = relativePath.indexOf(47);
            if (nextPathSep < 0) {
                TreeNode current = this.children.get(relativePath);
                if (current != null) {
                    treeNode.children.putAll(current.children);
                }
                this.children.put(relativePath, treeNode);
            } else {
                String parentName = relativePath.substring(0, nextPathSep);
                TreeNode parentNode = this.children.get(parentName);
                if (parentNode == null) {
                    parentNode = this.createFolder(path + "/" + parentName);
                    this.children.put(parentName, parentNode);
                }
                parentNode.addNode(treeNode);
            }
        }
    }

    public Collection<TreeNode> getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<TreeNode>();
            this.nodes.addAll(this.children.values());
            this.nodes.sort(NODE_COMPARATOR);
        }
        return this.nodes;
    }

    public void toJson(@NotNull JsonWriter writer, boolean recursive) throws IOException {
        AuthorizableModel model = this.getModel();
        writer.beginObject();
        this.toJsonData(writer, true);
        writer.name("children").beginArray();
        for (TreeNode child : this.getNodes()) {
            if (recursive) {
                child.toJson(writer, true);
                continue;
            }
            writer.beginObject();
            child.toJsonData(writer, false);
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    protected void toJsonData(@NotNull JsonWriter writer, boolean loaded) throws IOException {
        AuthorizableModel model = this.getModel();
        writer.name("id").value(this.getPath()).name("text").value(this.getName()).name("name").value(this.getName()).name("path").value(this.getPath()).name("type").value(this.getType());
        if (model instanceof UserModel && !(model instanceof ServiceUserModel)) {
            UserModel user = (UserModel)model;
            writer.name("disabled").value(user.isDisabled()).name("systemUser").value(user.isSystemUser());
        }
        writer.name("state").beginObject().name("loaded").value(loaded).endObject();
    }

    @NotNull
    protected TreeNode createFolder(@NotNull String path) {
        String type = PATH_TO_TYPE.get(path);
        return new TreeNode(type != null ? type : TYPE_FOLDER, path);
    }

    @NotNull
    public static String getName(@NotNull String path) {
        String name = StringUtils.substringAfterLast((String)path, (String)"/");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "/";
        }
        return name;
    }
}

