/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.service;

import com.composum.sling.core.usermanagement.service.GroupWrapper;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.jetbrains.annotations.NotNull;

public class AuthorizableWrapper {
    private final Authorizable authorizable;

    public AuthorizableWrapper(Authorizable authorizable) {
        this.authorizable = authorizable;
    }

    public String getID() throws RepositoryException {
        return this.authorizable.getID();
    }

    public boolean isGroup() {
        return this.authorizable.isGroup();
    }

    public Principal getPrincipal() throws RepositoryException {
        return this.authorizable.getPrincipal();
    }

    public Iterator<GroupWrapper> declaredMemberOf() throws RepositoryException {
        Iterator jcrGroupIterator = this.authorizable.declaredMemberOf();
        return AuthorizableWrapper.getGroupWrapperIterator(jcrGroupIterator);
    }

    public Iterator<GroupWrapper> memberOf() throws RepositoryException {
        Iterator jcrGroupIterator = this.authorizable.memberOf();
        return AuthorizableWrapper.getGroupWrapperIterator(jcrGroupIterator);
    }

    public void remove() throws RepositoryException {
        this.authorizable.remove();
    }

    public Iterator<String> getPropertyNames() throws RepositoryException {
        return this.authorizable.getPropertyNames();
    }

    public Iterator<String> getPropertyNames(String relPath) throws RepositoryException {
        return this.authorizable.getPropertyNames(relPath);
    }

    public boolean hasProperty(String relPath) throws RepositoryException {
        return this.authorizable.hasProperty(relPath);
    }

    public void setProperty(String relPath, Value value) throws RepositoryException {
        this.authorizable.setProperty(relPath, value);
    }

    public void setProperty(String relPath, Value[] value) throws RepositoryException {
        this.authorizable.setProperty(relPath, value);
    }

    public Value[] getProperty(String relPath) throws RepositoryException {
        return this.authorizable.getProperty(relPath);
    }

    public boolean removeProperty(String relPath) throws RepositoryException {
        return this.authorizable.removeProperty(relPath);
    }

    public String getPath() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.authorizable.getPath();
    }

    @NotNull
    protected static Iterator<GroupWrapper> getGroupWrapperIterator(Iterator<Group> jcrGroupIterator) {
        ArrayList<GroupWrapper> groupWrapperList = new ArrayList<GroupWrapper>();
        while (jcrGroupIterator.hasNext()) {
            groupWrapperList.add(new GroupWrapper(jcrGroupIterator.next()));
        }
        return groupWrapperList.iterator();
    }

    @NotNull
    protected static Iterator<AuthorizableWrapper> getAuthorizableWrapperIterator(Iterator<Authorizable> jcrAuthorizableIterator) {
        ArrayList<AuthorizableWrapper> authorizableWrapperList = new ArrayList<AuthorizableWrapper>();
        while (jcrAuthorizableIterator.hasNext()) {
            authorizableWrapperList.add(new AuthorizableWrapper(jcrAuthorizableIterator.next()));
        }
        return authorizableWrapperList.iterator();
    }

    public Authorizable getAuthorizable() {
        return this.authorizable;
    }
}

