/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.service;

import com.composum.sling.core.usermanagement.service.AuthorizableWrapper;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.usermanagement.service.GroupFacade;
import com.composum.sling.core.usermanagement.service.GroupWrapper;
import java.security.Principal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.serviceusermapping.Mapping;

public class ServiceUserWrapper
extends AuthorizableWrapper {
    public static final String SERVICE_USER_ROOT = "/home/services";
    protected final String serviceName;
    protected final String serviceInfo;
    protected final String id;
    protected final String path;
    protected final Mapping mapping;
    protected final Principal principal;
    private transient Set<GroupWrapper> declaredMemberOf;
    private transient Set<GroupWrapper> memberOf;

    public ServiceUserWrapper(Mapping mapping) {
        super(null);
        this.mapping = mapping;
        this.serviceName = mapping.getServiceName();
        this.serviceInfo = mapping.getSubServiceName();
        if (StringUtils.isNotBlank((CharSequence)this.serviceInfo)) {
            this.id = this.serviceName + ":" + this.serviceInfo;
            this.path = "/home/services/" + this.serviceName.replace('.', '/') + "/" + this.serviceInfo;
        } else {
            this.id = this.serviceName;
            this.path = "/home/services/" + this.serviceName.replace('.', '/');
        }
        this.principal = new ServicePrincipal();
    }

    public void initialize(Authorizables.Context context) throws RepositoryException {
        if (this.declaredMemberOf == null) {
            Iterable principals;
            AuthorizableWrapper authorizable;
            this.declaredMemberOf = new LinkedHashSet<GroupWrapper>();
            this.memberOf = new LinkedHashSet<GroupWrapper>();
            String user = this.mapping.map(this.mapping.getServiceName(), this.mapping.getSubServiceName());
            if (StringUtils.isNotBlank((CharSequence)user) && (authorizable = context.getService().getAuthorizable(context, user)) != null) {
                this.declaredMemberOf.add(new GroupFacade(authorizable, this));
            }
            if ((principals = this.mapping.mapPrincipals(this.mapping.getServiceName(), this.mapping.getSubServiceName())) != null) {
                for (String principal : principals) {
                    authorizable = context.getService().getAuthorizable(context, principal);
                    if (authorizable == null) continue;
                    this.declaredMemberOf.add(new GroupFacade(authorizable, this));
                }
            }
            for (GroupWrapper group : this.declaredMemberOf) {
                this.memberOf.add(group);
                Iterator<GroupWrapper> groups = group.memberOf();
                while (groups.hasNext()) {
                    this.memberOf.add(groups.next());
                }
            }
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceInfo() {
        return this.serviceInfo;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Principal getPrincipal() {
        return this.principal;
    }

    @Override
    public Iterator<GroupWrapper> declaredMemberOf() {
        return this.declaredMemberOf.iterator();
    }

    @Override
    public Iterator<GroupWrapper> memberOf() {
        return this.memberOf.iterator();
    }

    @Override
    public void remove() throws RepositoryException {
    }

    @Override
    public Iterator<String> getPropertyNames() {
        return Collections.emptyIterator();
    }

    @Override
    public Iterator<String> getPropertyNames(String relPath) {
        return Collections.emptyIterator();
    }

    @Override
    public boolean hasProperty(String relPath) {
        return false;
    }

    @Override
    public void setProperty(String relPath, Value value) {
    }

    @Override
    public void setProperty(String relPath, Value[] value) {
    }

    @Override
    public Value[] getProperty(String relPath) {
        return new Value[0];
    }

    @Override
    public boolean removeProperty(String relPath) {
        return false;
    }

    public class ServicePrincipal
    implements Principal {
        @Override
        public String getName() {
            return ServiceUserWrapper.this.getID();
        }
    }
}

