/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.servlet;

import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.AuthorizablesGraph;
import com.composum.sling.core.usermanagement.model.AuthorizablesPaths;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import javax.jcr.RepositoryException;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.xss.XSSFilter;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"service.description=Composum Nodes Authorizable Graph Servlet", "sling.servlet.paths=/bin/cpm/users/graph", "sling.servlet.methods=GET", "sling.servlet.extensions=html", "sling.servlet.extensions=json", "sling.auth.requirements=/bin/cpm/users/graph"})
public class GraphServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(GraphServlet.class);
    public static final String BROWSER_PATH = "/bin/browser.html";
    public static final String MANAGER_PATH = "/bin/users.html";
    public static final String SERVLET_PATH = "/bin/cpm/users/graph";
    public static final String COMPONENT_BASE = "/usermgnt/graph/";
    public static final URLCodec URL_CODEC = new URLCodec();
    @Reference
    protected XSSFilter xssFilter;
    @Reference
    protected Authorizables authorizablesService;

    @NotNull
    protected String getComponentBase(@NotNull ResourceResolver resolver) {
        String applicationPath = "/libs/composum/nodes";
        if (resolver.getResource(applicationPath) == null) {
            applicationPath = "/apps/composum/nodes";
        }
        return applicationPath + COMPONENT_BASE;
    }

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        ResourceResolver resolver = request.getResourceResolver();
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        String ext = pathInfo.getExtension();
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            switch (ext) {
                default: {
                    String option;
                    String[] selectors = pathInfo.getSelectors();
                    switch (option = (selectors.length > 0 ? selectors[0] : "").toLowerCase()) {
                        case "graphviz": {
                            try {
                                String context = selectors.length > 1 ? selectors[1] : "page";
                                Resource config = resolver.getResource(this.getComponentBase(resolver) + context + "/" + "jcr:content");
                                AuthorizablesGraph graph = this.getGraph(request, response);
                                response.setContentType("text/html;charset=UTF-8");
                                graph.toGraphviz(response.getWriter(), config, node -> this.nodeUrl(request, context, node));
                            }
                            catch (RepositoryException ex) {
                                LOG.error(ex.getMessage(), (Throwable)ex);
                                response.sendError(400, ex.getMessage());
                            }
                            return;
                        }
                        case "paths": {
                            try {
                                String context = selectors.length > 1 ? selectors[1] : "page";
                                Resource config = resolver.getResource(this.getComponentBase(resolver) + context + "/" + "jcr:content");
                                AuthorizablesPaths paths = this.getPaths(request, response);
                                response.setContentType("text/html;charset=UTF-8");
                                paths.toPathsTable(resolver, response.getWriter(), config, node -> this.nodeUrl(request, context, node), (node, path) -> this.pathUrl(request, context, node, path));
                            }
                            catch (RepositoryException ex) {
                                LOG.error(ex.getMessage(), (Throwable)ex);
                                response.sendError(400, ex.getMessage());
                            }
                            return;
                        }
                        default: {
                            option = "page";
                        }
                        case "page": 
                        case "view": 
                    }
                    String context = selectors.length > 1 ? selectors[1] : "";
                    RequestDispatcherOptions options = new RequestDispatcherOptions();
                    options.setForceResourceType("composum/nodes/usermgnt/graph/" + option);
                    options.setReplaceSelectors(context);
                    RequestDispatcher dispatcher = request.getRequestDispatcher(request.getResource(), options);
                    if (dispatcher == null) break;
                    dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                case "json": 
            }
            try {
                AuthorizablesGraph graph = this.getGraph(request, response);
                response.setContentType("text/html;charset=UTF-8");
                graph.toJson(new JsonWriter((Writer)response.getWriter()));
            }
            catch (RepositoryException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
            }
            return;
        }
        response.sendError(400);
    }

    protected AuthorizablesGraph getGraph(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws RepositoryException {
        String type = this.xssFilter.filter(request.getParameter("type"));
        String name = this.xssFilter.filter(request.getParameter("name"));
        String path = this.xssFilter.filter(request.getParameter("path"));
        return new AuthorizablesGraph(new Authorizables.Context(this.authorizablesService, request, response), type, name, path);
    }

    protected AuthorizablesPaths getPaths(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws RepositoryException {
        String type = this.xssFilter.filter(request.getParameter("type"));
        String name = this.xssFilter.filter(request.getParameter("name"));
        String path = this.xssFilter.filter(request.getParameter("path"));
        String text = this.xssFilter.filter(request.getParameter("text"));
        return new AuthorizablesPaths(new Authorizables.Context(this.authorizablesService, request, response), type, name, path, text);
    }

    protected String nodeUrl(@NotNull SlingHttpServletRequest request, @NotNull String option, @NotNull AuthorizableModel node) {
        StringBuilder url = new StringBuilder(request.getContextPath());
        try {
            StringBuilder params = new StringBuilder();
            switch (option) {
                default: {
                    String type = this.xssFilter.filter(request.getParameter("type"));
                    if (StringUtils.isNotBlank((CharSequence)type)) {
                        params.append(params.length() < 1 ? (char)'?' : '&').append("type=").append(URL_CODEC.encode(type));
                    }
                    params.append(params.length() < 1 ? (char)'?' : '&').append("name=").append(URL_CODEC.encode(node.getId()));
                    String path = this.xssFilter.filter(request.getParameter("path"));
                    if (StringUtils.isNotBlank((CharSequence)path)) {
                        params.append(params.length() < 1 ? (char)'?' : '&').append("path=").append(URL_CODEC.encode(path));
                    }
                    url.append(SERVLET_PATH).append(".page.html");
                    url.append((CharSequence)params);
                    break;
                }
                case "view": {
                    url.append(MANAGER_PATH).append(node.getPath());
                    break;
                }
            }
        }
        catch (EncoderException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return url.toString();
    }

    protected String pathUrl(@NotNull SlingHttpServletRequest request, @NotNull String option, @NotNull AuthorizableModel node, @NotNull String path) {
        StringBuilder url = new StringBuilder(request.getContextPath());
        switch (option) {
            default: {
                return null;
            }
            case "view": 
        }
        url.append(BROWSER_PATH).append(path);
        return url.toString();
    }
}

