/*
 * Decompiled with CFR 0.152.
 */
package com.composum.sling.core.usermanagement.view;

import com.composum.sling.core.RequestHandle;
import com.composum.sling.core.Restricted;
import com.composum.sling.core.filter.StringFilter;
import com.composum.sling.core.usermanagement.model.AuthorizableModel;
import com.composum.sling.core.usermanagement.model.AuthorizablesView;
import com.composum.sling.core.usermanagement.model.UserModel;
import com.composum.sling.core.usermanagement.service.AuthorizableWrapper;
import com.composum.sling.core.usermanagement.service.Authorizables;
import com.composum.sling.core.util.XSS;
import com.composum.sling.nodes.console.ConsoleSlingBean;
import java.util.Collections;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(key="nodes/users/manager")
public class View
extends ConsoleSlingBean {
    private static final Logger LOG = LoggerFactory.getLogger(View.class);
    public static final String RA_VIEW_BEAN = View.class.getName() + "#view";
    private transient AuthorizablesView view;
    private transient AuthorizableModel model;

    @NotNull
    public AuthorizablesView getView() {
        if (this.view == null) {
            RequestHandle request = this.getRequest();
            this.view = (AuthorizablesView)request.getAttribute(RA_VIEW_BEAN);
            if (this.view == null) {
                try {
                    String path = this.getSuffix();
                    if (StringUtils.isNotBlank((CharSequence)path)) {
                        Authorizables authorizables = (Authorizables)this.context.getService(Authorizables.class);
                        this.view = new AuthorizablesView(new Authorizables.Context(authorizables, (SlingHttpServletRequest)request, this.getResponse()), this.getSelector(), null, this.getPathFilter(path));
                        request.setAttribute(RA_VIEW_BEAN, (Object)this.view);
                    }
                }
                catch (RepositoryException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
        }
        return this.view;
    }

    @Nullable
    protected Class<? extends AuthorizableWrapper> getSelector() {
        return null;
    }

    @Nullable
    protected Authorizables.Filter.Path getPathFilter(@Nullable String path) {
        return StringUtils.isNotBlank((CharSequence)path) ? new Authorizables.Filter.Path("^" + path + "$") : null;
    }

    @Nullable
    public AuthorizableModel getModel() {
        if (this.model == null) {
            this.model = this.getView().getSingleFocus();
        }
        return this.model;
    }

    @NotNull
    public String getViewType() {
        AuthorizableModel model = this.getModel();
        String viewType = model != null ? model.getType() : "blank";
        return "user".equals(viewType) && ((UserModel)model).isSystemUser() ? "system" : viewType;
    }

    @NotNull
    public String getId() {
        AuthorizableModel model = this.getModel();
        return model != null ? model.getId() : "";
    }

    @NotNull
    public String getPath() {
        AuthorizableModel model = this.getModel();
        return model != null ? model.getPath() : "";
    }

    @NotNull
    public Set<String> getDeclaredMemberOf() {
        AuthorizableModel model = this.getModel();
        return model != null ? model.getDeclaredMemberOf() : Collections.emptySet();
    }

    @Nullable
    public String getSuffix() {
        String suffix = this.getRequest().getRequestPathInfo().getSuffix();
        return suffix != null ? XSS.filter((String)suffix) : null;
    }

    @NotNull
    public String getTabType() {
        String selector = this.getRequest().getSelectors((StringFilter)new StringFilter.BlackList("^tab$"));
        return StringUtils.isNotBlank((CharSequence)selector) ? selector.substring(1) : "general";
    }
}

