/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ParsingFailedException;
import com.configcat.RolloutEvaluator;
import com.configcat.User;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationParser.class);
    private final JsonParser parser = new JsonParser();
    private final RolloutEvaluator rolloutEvaluator = new RolloutEvaluator();

    ConfigurationParser() {
    }

    public <T> T parseValue(Class<T> classOfT, String config, String key) throws ParsingFailedException, IllegalArgumentException {
        return this.parseValue(classOfT, config, key, null);
    }

    public <T> T parseValue(Class<T> classOfT, String config, String key, User user) throws ParsingFailedException, IllegalArgumentException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key is null or empty");
        }
        if (config == null || config.isEmpty()) {
            throw new IllegalArgumentException("config is null or empty");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported");
        }
        return (T)this.parseValueInternal(classOfT, config, key, user);
    }

    public String parseVariationId(String config, String key, User user) throws ParsingFailedException {
        try {
            LOGGER.info("Evaluating getVariationId(" + key + ").");
            JsonObject root = this.parseConfigSection(config);
            JsonObject node = root.getAsJsonObject(key);
            if (node == null) {
                throw new ParsingFailedException("Variation ID not found for key " + key + ". Here are the available keys: " + String.join((CharSequence)", ", root.keySet()), config);
            }
            return this.rolloutEvaluator.evaluate(node, key, user).getValue().getAsString();
        }
        catch (ParsingFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParsingFailedException("JSON Parsing failed.", config, e);
        }
    }

    public <T> Map.Entry<String, T> parseKeyValue(Class<T> classOfT, String config, String variationId) throws ParsingFailedException {
        try {
            Set root = this.parseConfigSection(config).entrySet();
            for (Map.Entry node : root) {
                String settingKey = (String)node.getKey();
                JsonObject setting = ((JsonElement)node.getValue()).getAsJsonObject();
                if (variationId.equals(setting.get("i").getAsString())) {
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, setting.get("v")));
                }
                JsonArray rolloutRules = setting.get("r").getAsJsonArray();
                for (JsonElement rolloutElement : rolloutRules) {
                    JsonObject rolloutRule = rolloutElement.getAsJsonObject();
                    if (!variationId.equals(rolloutRule.get("i").getAsString())) continue;
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, rolloutRule.get("v")));
                }
                JsonArray persentageRules = setting.get("p").getAsJsonArray();
                for (JsonElement percentageElement : persentageRules) {
                    JsonObject percentageRule = percentageElement.getAsJsonObject();
                    if (!variationId.equals(percentageRule.get("i").getAsString())) continue;
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, percentageRule.get("v")));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ParsingFailedException("JSON Parsing failed.", config, e);
        }
    }

    public Collection<String> getAllKeys(String config) throws ParsingFailedException {
        try {
            JsonObject root = this.parseConfigSection(config);
            return root.keySet();
        }
        catch (Exception e) {
            throw new ParsingFailedException("JSON Parsing failed.", config, e);
        }
    }

    private Object parseValueInternal(Class<?> classOfT, String config, String key, User user) throws ParsingFailedException, IllegalArgumentException {
        try {
            JsonObject root = this.parseConfigSection(config);
            JsonObject node = root.getAsJsonObject(key);
            if (node == null) {
                throw new ParsingFailedException("Value not found for key " + key + ". Here are the available keys: " + String.join((CharSequence)", ", root.keySet()), config);
            }
            return this.parseObject(classOfT, this.rolloutEvaluator.evaluate(node, key, user).getKey());
        }
        catch (ParsingFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParsingFailedException("JSON Parsing failed.", config, e);
        }
    }

    private Object parseObject(Class<?> classOfT, JsonElement element) {
        if (classOfT == String.class) {
            return element.getAsString();
        }
        if (classOfT == Integer.class || classOfT == Integer.TYPE) {
            return element.getAsInt();
        }
        if (classOfT == Double.class || classOfT == Double.TYPE) {
            return element.getAsDouble();
        }
        return element.getAsBoolean();
    }

    private JsonObject parseConfigSection(String json) {
        JsonObject root = this.parser.parse(json).getAsJsonObject();
        return root.getAsJsonObject("f");
    }
}

