/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ConfigCache;
import com.configcat.ConfigFetcher;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RefreshPolicy
implements Closeable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(RefreshPolicy.class);
    private static final String CacheBase = "java_config_v5_%s";
    private final ConfigCache cache;
    private final ConfigFetcher configFetcher;
    private final String CacheKey;
    private String inMemoryConfig;

    protected String readConfigCache() {
        try {
            return this.cache.read(this.CacheKey);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during the cache read.", (Throwable)e);
            return this.inMemoryConfig;
        }
    }

    protected void writeConfigCache(String value) {
        try {
            this.inMemoryConfig = value;
            this.cache.write(this.CacheKey, value);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred during the cache write.", (Throwable)e);
        }
    }

    protected ConfigFetcher fetcher() {
        return this.configFetcher;
    }

    RefreshPolicy(ConfigFetcher configFetcher, ConfigCache cache, String sdkKey) {
        this.configFetcher = configFetcher;
        this.cache = cache;
        this.CacheKey = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)String.format(CacheBase, sdkKey))));
    }

    public abstract CompletableFuture<String> getConfigurationJsonAsync();

    public CompletableFuture<Void> refreshAsync() {
        return this.fetcher().getConfigurationJsonStringAsync().thenAcceptAsync(response -> {
            if (response.isFetched()) {
                this.writeConfigCache(response.config());
            }
        });
    }

    String getLatestCachedValue() {
        return this.inMemoryConfig;
    }

    @Override
    public void close() throws IOException {
        this.configFetcher.close();
    }
}

