/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.User;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.skuzzle.semantic.Version;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RolloutEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RolloutEvaluator.class);
    private static final String[] COMPARATOR_TEXTS = new String[]{"IS ONE OF", "IS NOT ONE OF", "CONTAINS", "DOES NOT CONTAIN", "IS ONE OF (SemVer)", "IS NOT ONE OF (SemVer)", "< (SemVer)", "<= (SemVer)", "> (SemVer)", ">= (SemVer)", "= (Number)", "<> (Number)", "< (Number)", "<= (Number)", "> (Number)", ">= (Number)", "IS ONE OF (Sensitive)", "IS NOT ONE OF (Sensitive)"};

    RolloutEvaluator() {
    }

    public Map.Entry<JsonElement, JsonElement> evaluate(JsonObject json, String key, User user) {
        JsonArray rolloutRules = json.getAsJsonArray("r");
        JsonArray percentageRules = json.getAsJsonArray("p");
        LOGGER.info("Evaluating getValue(" + key + ").");
        if (user == null) {
            if (rolloutRules.size() > 0 || percentageRules.size() > 0) {
                LOGGER.warn("UserObject missing! You should pass a UserObject to getValue() in order to make targeting work properly. Read more: https://configcat.com/docs/advanced/user-object.");
            }
            JsonElement result = json.get("v");
            LOGGER.info("Returning " + result + ".");
            return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(result, json.get("i"));
        }
        block17: for (JsonElement rule : rolloutRules) {
            JsonObject ruleObject = rule.getAsJsonObject();
            String comparisonAttribute = ruleObject.get("a").getAsString();
            String comparisonValue = ruleObject.get("c").getAsString();
            int comparator = ruleObject.get("t").getAsInt();
            JsonElement value = ruleObject.get("v");
            JsonElement variationId = ruleObject.get("i");
            String userValue = user.getAttribute(comparisonAttribute);
            if (comparisonValue == null || comparisonValue.isEmpty() || userValue == null || userValue.isEmpty()) {
                this.logNoMatch(comparisonAttribute, userValue, comparator, comparisonValue);
                continue;
            }
            switch (comparator) {
                case 0: {
                    ArrayList<String> inValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                    inValues.replaceAll(String::trim);
                    inValues.removeAll(Arrays.asList(null, ""));
                    if (!inValues.contains(userValue)) break;
                    this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                    return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                }
                case 1: {
                    ArrayList<String> notInValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                    notInValues.replaceAll(String::trim);
                    notInValues.removeAll(Arrays.asList(null, ""));
                    if (notInValues.contains(userValue)) break;
                    this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                    return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                }
                case 2: {
                    if (!userValue.contains(comparisonValue)) break;
                    this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                    return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                }
                case 3: {
                    if (userValue.contains(comparisonValue)) break;
                    this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                    return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                }
                case 4: 
                case 5: {
                    ArrayList<String> inSemVerValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                    inSemVerValues.replaceAll(String::trim);
                    inSemVerValues.removeAll(Arrays.asList(null, ""));
                    try {
                        Version userVersion = Version.parseVersion((String)userValue, (boolean)true);
                        boolean matched = false;
                        for (String semVer : inSemVerValues) {
                            matched = userVersion.compareTo(Version.parseVersion((String)semVer, (boolean)true)) == 0 || matched;
                        }
                        if (matched && comparator == 4 || !matched && comparator == 5) {
                            this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                        }
                        break;
                    }
                    catch (Exception e) {
                        this.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e);
                        continue block17;
                    }
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    try {
                        Version cmpUserVersion = Version.parseVersion((String)userValue, (boolean)true);
                        Version matchValue = Version.parseVersion((String)comparisonValue.trim(), (boolean)true);
                        if (comparator == 6 && cmpUserVersion.isLowerThan(matchValue) || comparator == 7 && cmpUserVersion.compareTo(matchValue) <= 0 || comparator == 8 && cmpUserVersion.isGreaterThan(matchValue) || comparator == 9 && cmpUserVersion.compareTo(matchValue) >= 0) {
                            this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                        }
                        break;
                    }
                    catch (Exception e) {
                        this.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e);
                        continue block17;
                    }
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    try {
                        Double userDoubleValue = Double.parseDouble(userValue.replaceAll(",", "."));
                        Double comparisonDoubleValue = Double.parseDouble(comparisonValue.replaceAll(",", "."));
                        if (comparator == 10 && userDoubleValue.equals(comparisonDoubleValue) || comparator == 11 && !userDoubleValue.equals(comparisonDoubleValue) || comparator == 12 && userDoubleValue < comparisonDoubleValue || comparator == 13 && userDoubleValue <= comparisonDoubleValue || comparator == 14 && userDoubleValue > comparisonDoubleValue || comparator == 15 && userDoubleValue >= comparisonDoubleValue) {
                            this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                        }
                        break;
                    }
                    catch (NumberFormatException e) {
                        this.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e);
                        continue block17;
                    }
                }
                case 16: {
                    ArrayList<String> inValuesSensitive = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                    inValuesSensitive.replaceAll(String::trim);
                    inValuesSensitive.removeAll(Arrays.asList(null, ""));
                    String hashValueOne = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)userValue)));
                    if (!inValuesSensitive.contains(hashValueOne)) break;
                    this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                    return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                }
                case 17: {
                    ArrayList<String> notInValuesSensitive = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                    notInValuesSensitive.replaceAll(String::trim);
                    notInValuesSensitive.removeAll(Arrays.asList(null, ""));
                    String hashValueNotOne = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)userValue)));
                    if (notInValuesSensitive.contains(hashValueNotOne)) break;
                    this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                    return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(value, variationId);
                }
            }
            this.logNoMatch(comparisonAttribute, userValue, comparator, comparisonValue);
        }
        if (percentageRules.size() > 0) {
            String hashCandidate = key + user.getIdentifier();
            int scale = 100;
            String hexHash = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)hashCandidate))).substring(0, 7);
            int longHash = Integer.parseInt(hexHash, 16);
            int scaled = longHash % scale;
            int bucket = 0;
            for (JsonElement rule : percentageRules) {
                JsonObject ruleObject = rule.getAsJsonObject();
                if (scaled >= (bucket += ruleObject.get("p").getAsInt())) continue;
                JsonElement result = ruleObject.get("v");
                LOGGER.info("Evaluating % options. Returning " + result + ".");
                return new AbstractMap.SimpleEntry<JsonElement, JsonElement>(result, ruleObject.get("i"));
            }
        }
        Iterator result = json.get("v");
        LOGGER.info("Returning " + result + ".");
        return new AbstractMap.SimpleEntry<Iterator, JsonElement>(result, json.get("i"));
    }

    private void logMatch(String comparisonAttribute, String userValue, int comparator, String comparisonValue, JsonElement value) {
        LOGGER.info("Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => match, returning: " + value + "");
    }

    private void logNoMatch(String comparisonAttribute, String userValue, int comparator, String comparisonValue) {
        LOGGER.info("Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => no match");
    }

    private void logFormatError(String comparisonAttribute, String userValue, int comparator, String comparisonValue, Exception exception) {
        LOGGER.warn("Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => SKIP rule. Validation error: " + exception + "");
    }
}

