/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.AutoPollingMode;
import com.configcat.AutoPollingPolicy;
import com.configcat.ConfigCache;
import com.configcat.ConfigFetcher;
import com.configcat.ConfigurationParser;
import com.configcat.ConfigurationProvider;
import com.configcat.DataGovernance;
import com.configcat.InMemoryConfigCache;
import com.configcat.LazyLoadingMode;
import com.configcat.LazyLoadingPolicy;
import com.configcat.ManualPollingMode;
import com.configcat.ManualPollingPolicy;
import com.configcat.PollingMode;
import com.configcat.PollingModes;
import com.configcat.RefreshPolicy;
import com.configcat.User;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigCatClient
implements ConfigurationProvider {
    private static final String BASE_URL_GLOBAL = "https://cdn-global.configcat.com";
    private static final String BASE_URL_EU = "https://cdn-eu.configcat.com";
    private final RefreshPolicy refreshPolicy;
    private final int maxWaitTimeForSyncCallsInSeconds;
    private final Logger logger;
    private final ConfigurationParser parser;

    private ConfigCatClient(String sdkKey, Builder builder) throws IllegalArgumentException {
        if (sdkKey == null || sdkKey.isEmpty()) {
            throw new IllegalArgumentException("sdkKey is null or empty");
        }
        this.logger = LoggerFactory.getLogger(ConfigCatClient.class);
        this.parser = new ConfigurationParser(this.logger);
        this.maxWaitTimeForSyncCallsInSeconds = builder.maxWaitTimeForSyncCallsInSeconds;
        PollingMode pollingMode = builder.pollingMode == null ? PollingModes.AutoPoll(60) : builder.pollingMode;
        boolean hasCustomBaseUrl = builder.baseUrl != null && !builder.baseUrl.isEmpty();
        ConfigFetcher fetcher = new ConfigFetcher(builder.httpClient == null ? new OkHttpClient.Builder().retryOnConnectionFailure(true).build() : builder.httpClient, this.logger, sdkKey, !hasCustomBaseUrl ? (builder.dataGovernance == DataGovernance.GLOBAL ? BASE_URL_GLOBAL : BASE_URL_EU) : builder.baseUrl, hasCustomBaseUrl, pollingMode.getPollingIdentifier());
        ConfigCache cache = builder.cache == null ? new InMemoryConfigCache() : builder.cache;
        this.refreshPolicy = this.selectPolicy(pollingMode, cache, fetcher, this.logger, sdkKey);
    }

    public ConfigCatClient(String sdkKey) {
        this(sdkKey, ConfigCatClient.newBuilder());
    }

    @Override
    public <T> T getValue(Class<T> classOfT, String key, T defaultValue) {
        return this.getValue(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> T getValue(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key is null or empty");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported");
        }
        try {
            return this.maxWaitTimeForSyncCallsInSeconds > 0 ? this.getValueAsync(classOfT, key, user, defaultValue).get(this.maxWaitTimeForSyncCallsInSeconds, TimeUnit.SECONDS) : this.getValueAsync(classOfT, key, user, defaultValue).get();
        }
        catch (Exception e) {
            return this.getValueFromJson(classOfT, this.refreshPolicy.getLatestCachedValue(), key, user, defaultValue);
        }
    }

    @Override
    public <T> CompletableFuture<T> getValueAsync(Class<T> classOfT, String key, T defaultValue) {
        return this.getValueAsync(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> CompletableFuture<T> getValueAsync(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key is null or empty");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported");
        }
        return this.refreshPolicy.getConfigurationJsonAsync().thenApply(config -> this.getValueFromJson(classOfT, (String)config, key, user, defaultValue));
    }

    @Override
    public String getVariationId(String key, String defaultVariationId) {
        return this.getVariationId(key, null, defaultVariationId);
    }

    @Override
    public String getVariationId(String key, User user, String defaultVariationId) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key is null or empty");
        }
        try {
            return this.maxWaitTimeForSyncCallsInSeconds > 0 ? this.getVariationIdAsync(key, user, defaultVariationId).get(this.maxWaitTimeForSyncCallsInSeconds, TimeUnit.SECONDS) : this.getVariationIdAsync(key, user, defaultVariationId).get();
        }
        catch (Exception e) {
            return this.getVariationIdFromJson(this.refreshPolicy.getLatestCachedValue(), key, user, defaultVariationId);
        }
    }

    @Override
    public CompletableFuture<String> getVariationIdAsync(String key, String defaultVariationId) {
        return this.getVariationIdAsync(key, null, defaultVariationId);
    }

    @Override
    public CompletableFuture<String> getVariationIdAsync(String key, User user, String defaultVariationId) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key is null or empty");
        }
        return this.refreshPolicy.getConfigurationJsonAsync().thenApply(config -> this.getVariationIdFromJson((String)config, key, user, defaultVariationId));
    }

    @Override
    public Collection<String> getAllVariationIds() {
        return this.getAllVariationIds(null);
    }

    @Override
    public CompletableFuture<Collection<String>> getAllVariationIdsAsync() {
        return this.getAllVariationIdsAsync(null);
    }

    @Override
    public Collection<String> getAllVariationIds(User user) {
        try {
            return this.maxWaitTimeForSyncCallsInSeconds > 0 ? this.getAllVariationIdsAsync(user).get(this.maxWaitTimeForSyncCallsInSeconds, TimeUnit.SECONDS) : this.getAllVariationIdsAsync(user).get();
        }
        catch (Exception e) {
            this.logger.error("An error occurred during getting all the variation ids.", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public CompletableFuture<Collection<String>> getAllVariationIdsAsync(User user) {
        return this.refreshPolicy.getConfigurationJsonAsync().thenApply(config -> {
            try {
                Collection<String> keys = this.parser.getAllKeys((String)config);
                ArrayList<String> result = new ArrayList<String>();
                for (String key : keys) {
                    result.add(this.getVariationIdFromJson((String)config, key, user, null));
                }
                return result;
            }
            catch (Exception e) {
                this.logger.error("An error occurred during the deserialization. Returning empty array.", (Throwable)e);
                return new ArrayList();
            }
        });
    }

    @Override
    public <T> Map.Entry<String, T> getKeyAndValue(Class<T> classOfT, String variationId) {
        if (variationId == null || variationId.isEmpty()) {
            throw new IllegalArgumentException("variationId is null or empty");
        }
        try {
            return this.maxWaitTimeForSyncCallsInSeconds > 0 ? this.getKeyAndValueAsync(classOfT, variationId).get(this.maxWaitTimeForSyncCallsInSeconds, TimeUnit.SECONDS) : this.getKeyAndValueAsync(classOfT, variationId).get();
        }
        catch (Exception e) {
            return this.getKeyAndValueFromJson(classOfT, this.refreshPolicy.getLatestCachedValue(), variationId);
        }
    }

    @Override
    public <T> CompletableFuture<Map.Entry<String, T>> getKeyAndValueAsync(Class<T> classOfT, String variationId) {
        if (variationId == null || variationId.isEmpty()) {
            throw new IllegalArgumentException("variationId is null or empty");
        }
        return this.refreshPolicy.getConfigurationJsonAsync().thenApply(config -> this.getKeyAndValueFromJson(classOfT, (String)config, variationId));
    }

    @Override
    public Collection<String> getAllKeys() {
        try {
            return this.maxWaitTimeForSyncCallsInSeconds > 0 ? this.getAllKeysAsync().get(this.maxWaitTimeForSyncCallsInSeconds, TimeUnit.SECONDS) : this.getAllKeysAsync().get();
        }
        catch (Exception e) {
            this.logger.error("An error occurred during getting all the setting keys.", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    @Override
    public CompletableFuture<Collection<String>> getAllKeysAsync() {
        return this.refreshPolicy.getConfigurationJsonAsync().thenApply(config -> {
            try {
                return this.parser.getAllKeys((String)config);
            }
            catch (Exception e) {
                this.logger.error("An error occurred during the deserialization. Returning empty array.", (Throwable)e);
                return new ArrayList();
            }
        });
    }

    @Override
    public void forceRefresh() {
        try {
            if (this.maxWaitTimeForSyncCallsInSeconds > 0) {
                this.forceRefreshAsync().get(this.maxWaitTimeForSyncCallsInSeconds, TimeUnit.SECONDS);
            } else {
                this.forceRefreshAsync().get();
            }
        }
        catch (Exception e) {
            this.logger.error("An error occurred during the refresh.", (Throwable)e);
        }
    }

    @Override
    public CompletableFuture<Void> forceRefreshAsync() {
        return this.refreshPolicy.refreshAsync();
    }

    @Override
    public void close() throws IOException {
        this.refreshPolicy.close();
    }

    private <T> T getValueFromJson(Class<T> classOfT, String config, String key, User user, T defaultValue) {
        try {
            return this.parser.parseValue(classOfT, config, key, user);
        }
        catch (Exception e) {
            this.logger.error("Evaluating getValue('" + key + "') failed. Returning defaultValue: [" + defaultValue + "]. " + e.getMessage(), (Throwable)e);
            return defaultValue;
        }
    }

    private String getVariationIdFromJson(String config, String key, User user, String defaultVariationId) {
        try {
            return this.parser.parseVariationId(config, key, user);
        }
        catch (Exception e) {
            this.logger.error("Evaluating getVariationId('" + key + "') failed. Returning defaultVariationId: [" + defaultVariationId + "]. " + e.getMessage(), (Throwable)e);
            return defaultVariationId;
        }
    }

    private <T> Map.Entry<String, T> getKeyAndValueFromJson(Class<T> classOfT, String config, String variationId) {
        try {
            return this.parser.parseKeyValue(classOfT, config, variationId);
        }
        catch (Exception e) {
            this.logger.error("Could not find the setting for the given variation ID: " + variationId);
            return null;
        }
    }

    private RefreshPolicy selectPolicy(PollingMode mode, ConfigCache cache, ConfigFetcher fetcher, Logger logger, String sdkKey) {
        if (mode instanceof AutoPollingMode) {
            return new AutoPollingPolicy(fetcher, cache, logger, sdkKey, (AutoPollingMode)mode);
        }
        if (mode instanceof LazyLoadingMode) {
            return new LazyLoadingPolicy(fetcher, cache, logger, sdkKey, (LazyLoadingMode)mode);
        }
        if (mode instanceof ManualPollingMode) {
            return new ManualPollingPolicy(fetcher, cache, logger, sdkKey);
        }
        throw new InvalidParameterException("The polling mode parameter is invalid.");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private OkHttpClient httpClient;
        private ConfigCache cache;
        private int maxWaitTimeForSyncCallsInSeconds;
        private String baseUrl;
        private PollingMode pollingMode;
        private DataGovernance dataGovernance = DataGovernance.GLOBAL;

        public Builder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder cache(ConfigCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder mode(PollingMode pollingMode) {
            this.pollingMode = pollingMode;
            return this;
        }

        public Builder dataGovernance(DataGovernance dataGovernance) {
            this.dataGovernance = dataGovernance;
            return this;
        }

        public Builder maxWaitTimeForSyncCallsInSeconds(int maxWaitTimeForSyncCallsInSeconds) {
            if (maxWaitTimeForSyncCallsInSeconds < 2) {
                throw new IllegalArgumentException("maxWaitTimeForSyncCallsInSeconds cannot be less than 2 seconds");
            }
            this.maxWaitTimeForSyncCallsInSeconds = maxWaitTimeForSyncCallsInSeconds;
            return this;
        }

        public ConfigCatClient build(String sdkKey) {
            return new ConfigCatClient(sdkKey, this);
        }
    }
}

