/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.FetchResponse;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;

class ConfigFetcher
implements Closeable {
    public static final String CONFIG_JSON_NAME = "config_v5";
    private final Logger logger;
    private final JsonParser parser = new JsonParser();
    private final OkHttpClient httpClient;
    private final String mode;
    private final String version;
    private final String sdkKey;
    private final boolean urlIsCustom;
    private String url;
    private String eTag;

    ConfigFetcher(OkHttpClient httpClient, Logger logger, String sdkKey, String url, boolean urlIsCustom, String pollingIdentifier) {
        this.logger = logger;
        this.sdkKey = sdkKey;
        this.urlIsCustom = urlIsCustom;
        this.url = url;
        this.httpClient = httpClient;
        this.version = this.getClass().getPackage().getImplementationVersion();
        this.mode = pollingIdentifier;
    }

    public CompletableFuture<FetchResponse> getConfigurationJsonStringAsync() {
        return this.executeFetchAsync(2);
    }

    private CompletableFuture<FetchResponse> executeFetchAsync(int executionCount) {
        return this.getResponseAsync().thenComposeAsync(fetchResponse -> {
            if (!fetchResponse.isFetched()) {
                return CompletableFuture.completedFuture(fetchResponse);
            }
            try {
                JsonObject json = this.parser.parse(fetchResponse.config()).getAsJsonObject();
                JsonObject preferences = json.getAsJsonObject("p");
                if (preferences == null) {
                    return CompletableFuture.completedFuture(fetchResponse);
                }
                String newUrl = preferences.get("u").getAsString();
                if (newUrl == null || newUrl.isEmpty() || newUrl.equals(this.url)) {
                    return CompletableFuture.completedFuture(fetchResponse);
                }
                int redirect = preferences.get("r").getAsInt();
                if (this.urlIsCustom && redirect != RedirectMode.ForceRedirect.ordinal()) {
                    return CompletableFuture.completedFuture(fetchResponse);
                }
                this.url = newUrl;
                if (redirect == RedirectMode.NoRedirect.ordinal()) {
                    return CompletableFuture.completedFuture(fetchResponse);
                }
                if (redirect == RedirectMode.ShouldRedirect.ordinal()) {
                    this.logger.warn("Your builder.dataGovernance() parameter at ConfigCatClient initialization is not in sync with your preferences on the ConfigCat Dashboard: https://app.configcat.com/organization/data-governance. Only Organization Admins can access this preference.");
                }
                if (executionCount > 0) {
                    return this.executeFetchAsync(executionCount - 1);
                }
            }
            catch (Exception exception) {
                this.logger.error("Exception in ConfigFetcher.executeFetchAsync", (Throwable)exception);
                return CompletableFuture.completedFuture(fetchResponse);
            }
            this.logger.error("Redirect loop during config.json fetch. Please contact support@configcat.com.");
            return CompletableFuture.completedFuture(fetchResponse);
        });
    }

    private CompletableFuture<FetchResponse> getResponseAsync() {
        Request request = this.getRequest();
        final CompletableFuture<FetchResponse> future = new CompletableFuture<FetchResponse>();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                ConfigFetcher.this.logger.error("An error occurred during fetching the latest configuration.", (Throwable)e);
                future.complete(new FetchResponse(FetchResponse.Status.FAILED, null));
            }

            public void onResponse(Call call, Response response) {
                try (ResponseBody body = response.body();){
                    if (response.isSuccessful() && body != null) {
                        ConfigFetcher.this.logger.debug("Fetch was successful: new config fetched.");
                        ConfigFetcher.this.eTag = response.header("ETag");
                        future.complete(new FetchResponse(FetchResponse.Status.FETCHED, body.string()));
                    } else if (response.code() == 304) {
                        ConfigFetcher.this.logger.debug("Fetch was successful: config not modified.");
                        future.complete(new FetchResponse(FetchResponse.Status.NOTMODIFIED, null));
                    } else {
                        ConfigFetcher.this.logger.error("Double-check your API KEY at https://app.configcat.com/apikey. Received unexpected response: " + response.code());
                        future.complete(new FetchResponse(FetchResponse.Status.FAILED, null));
                    }
                }
                catch (Exception e) {
                    ConfigFetcher.this.logger.error("Exception in ConfigFetcher.getResponseAsync", (Throwable)e);
                    future.complete(new FetchResponse(FetchResponse.Status.FAILED, null));
                }
            }
        });
        return future;
    }

    @Override
    public void close() throws IOException {
        if (this.httpClient != null) {
            if (this.httpClient.dispatcher() != null && this.httpClient.dispatcher().executorService() != null) {
                this.httpClient.dispatcher().executorService().shutdownNow();
            }
            if (this.httpClient.connectionPool() != null) {
                this.httpClient.connectionPool().evictAll();
            }
            if (this.httpClient.cache() != null) {
                this.httpClient.cache().close();
            }
        }
    }

    Request getRequest() {
        String url = this.url + "/configuration-files/" + this.sdkKey + "/" + CONFIG_JSON_NAME + ".json";
        Request.Builder builder = new Request.Builder().addHeader("X-ConfigCat-UserAgent", "ConfigCat-Java/" + this.mode + "-" + this.version);
        if (this.eTag != null) {
            builder.addHeader("If-None-Match", this.eTag);
        }
        return builder.url(url).build();
    }

    static enum RedirectMode {
        NoRedirect,
        ShouldRedirect,
        ForceRedirect;

    }
}

