/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ConfigCatLogger;
import com.configcat.LocalFileDataSource;
import com.configcat.LocalMapDataSource;
import com.configcat.OverrideDataSource;
import java.util.Map;

public class OverrideDataSourceBuilder {
    private String filePath;
    private boolean isResource;
    private boolean autoReload;
    private Map<String, Object> map;

    private OverrideDataSourceBuilder(String filePath, boolean isResource, boolean autoReload) {
        this.filePath = filePath;
        this.isResource = isResource;
        this.autoReload = autoReload;
    }

    private OverrideDataSourceBuilder(Map<String, Object> map) {
        this.map = map;
    }

    OverrideDataSource build(ConfigCatLogger logger) {
        if (this.map != null) {
            return new LocalMapDataSource(this.map);
        }
        if (this.filePath != null && !this.filePath.isEmpty()) {
            return new LocalFileDataSource(this.filePath, this.isResource, logger, this.autoReload);
        }
        return new OverrideDataSource();
    }

    public static OverrideDataSourceBuilder localFile(String filePath, boolean autoReload) {
        return new OverrideDataSourceBuilder(filePath, false, autoReload);
    }

    public static OverrideDataSourceBuilder classPathResource(String resourceName, boolean autoReload) {
        return new OverrideDataSourceBuilder(resourceName, true, autoReload);
    }

    public static OverrideDataSourceBuilder map(Map<String, Object> map) {
        return new OverrideDataSourceBuilder(map);
    }
}

