/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Config;
import com.configcat.ConfigCatLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import org.apache.commons.codec.digest.MurmurHash3;

class ConfigMemoryCache {
    private Config cached;
    private long[] cachedHash;
    private final Gson gson = new GsonBuilder().create();
    private final ConfigCatLogger logger;

    public ConfigMemoryCache(ConfigCatLogger logger) {
        this.logger = logger;
    }

    public Config getConfigFromJson(String json) {
        long[] hash;
        if (json == null || json.isEmpty()) {
            return null;
        }
        if (this.cachedHash != null && Arrays.equals(this.cachedHash, hash = MurmurHash3.hash128((String)json))) {
            return this.cached;
        }
        try {
            this.cached = (Config)this.gson.fromJson(json, Config.class);
            this.cached.jsonString = json;
            this.cachedHash = MurmurHash3.hash128((String)json);
            return this.cached;
        }
        catch (Exception e) {
            this.logger.error("Config JSON parsing failed.", e);
            return null;
        }
    }
}

