/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import java.util.Map;
import java.util.TreeMap;

public class User {
    private final String identifier;
    private final Map<String, String> attributes;

    private User(String identifier, String email, String country, Map<String, String> custom) {
        this.identifier = identifier == null ? "" : identifier;
        this.attributes = new TreeMap<String, String>();
        this.attributes.put("Identifier", identifier);
        if (country != null && !country.isEmpty()) {
            this.attributes.put("Country", country);
        }
        if (email != null && !email.isEmpty()) {
            this.attributes.put("Email", email);
        }
        if (custom != null) {
            this.attributes.putAll(custom);
        }
    }

    String getIdentifier() {
        return this.identifier;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    String getAttribute(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key is null or empty");
        }
        return this.attributes.getOrDefault(key, null);
    }

    public String toString() {
        return "User" + this.attributes + "";
    }

    public static class Builder {
        private String email;
        private String country;
        private Map<String, String> custom;

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder country(String country) {
            this.country = country;
            return this;
        }

        public Builder custom(Map<String, String> custom) {
            this.custom = custom;
            return this;
        }

        public User build(String identifier) {
            return new User(identifier, this.email, this.country, this.custom);
        }
    }
}

