/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Config;
import com.configcat.ConfigCache;
import com.configcat.ConfigCatLogger;
import com.configcat.ConfigFetcher;
import com.configcat.ConfigMemoryCache;
import com.configcat.RefreshPolicy;
import com.configcat.Setting;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

abstract class RefreshPolicyBase
implements RefreshPolicy {
    private static final String CACHE_BASE = "java_config_v5_%s";
    private final ConfigCache cache;
    private final ConfigFetcher configFetcher;
    protected final ConfigMemoryCache configMemoryCache;
    private final String cacheKey;
    protected final ConfigCatLogger logger;
    private Config inMemoryConfig;

    protected Config readConfigCache() {
        try {
            Config result = this.configMemoryCache.getConfigFromJson(this.cache.read(this.cacheKey));
            return result != null ? result : this.inMemoryConfig;
        }
        catch (Exception e) {
            this.logger.error("An error occurred during the cache read.", e);
            return this.inMemoryConfig;
        }
    }

    protected void writeConfigCache(Config value) {
        try {
            this.inMemoryConfig = value;
            this.cache.write(this.cacheKey, value.jsonString);
        }
        catch (Exception e) {
            this.logger.error("An error occurred during the cache write.", e);
        }
    }

    protected ConfigFetcher fetcher() {
        return this.configFetcher;
    }

    RefreshPolicyBase(ConfigFetcher configFetcher, ConfigCache cache, ConfigCatLogger logger, ConfigMemoryCache configMemoryCache, String sdkKey) {
        this.configFetcher = configFetcher;
        this.cache = cache;
        this.logger = logger;
        this.configMemoryCache = configMemoryCache;
        this.cacheKey = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)String.format(CACHE_BASE, sdkKey))));
    }

    @Override
    public CompletableFuture<Map<String, Setting>> getSettingsAsync() {
        return this.getConfigurationAsync().thenApply(config -> {
            if (config == null) {
                return new HashMap();
            }
            return config.entries;
        });
    }

    protected abstract CompletableFuture<Config> getConfigurationAsync();

    @Override
    public CompletableFuture<Void> refreshAsync() {
        return this.fetcher().fetchAsync().thenAcceptAsync(response -> {
            if (response.isFetched()) {
                this.writeConfigCache(response.config());
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.configFetcher.close();
    }
}

