/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Config;
import com.configcat.ConfigCache;
import com.configcat.ConfigCatLogger;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

class ConfigJsonCache {
    private static final String CACHE_BASE = "java_config_v5_%s";
    private Config inMemoryConfig = Config.empty;
    private String inMemoryConfigString = "";
    private final Gson gson = new GsonBuilder().create();
    private final ConfigCatLogger logger;
    private final ConfigCache cache;
    private final String cacheKey;

    public ConfigJsonCache(ConfigCatLogger logger, ConfigCache cache, String sdkKey) {
        this.logger = logger;
        this.cache = cache;
        this.cacheKey = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)String.format(CACHE_BASE, sdkKey))));
    }

    public Config readFromJson(String json, String eTag) {
        if (json == null || json.isEmpty()) {
            return Config.empty;
        }
        try {
            Config config = this.deserialize(json);
            config.eTag = eTag;
            return config;
        }
        catch (Exception e) {
            this.logger.error("Config JSON parsing failed.", e);
            return Config.empty;
        }
    }

    public Config readFromCache() {
        String fromCache = this.readCache();
        if (fromCache == null || fromCache.isEmpty() || fromCache.equals(this.inMemoryConfigString)) {
            return this.inMemoryConfig;
        }
        try {
            Config config = this.deserialize(fromCache);
            if (this.inMemoryConfig.timeStamp >= config.timeStamp) {
                return this.inMemoryConfig;
            }
            this.inMemoryConfig = config;
            this.inMemoryConfigString = fromCache;
            return config;
        }
        catch (Exception e) {
            this.logger.error("Config JSON parsing failed.", e);
            return this.inMemoryConfig;
        }
    }

    public void writeToCache(Config config) {
        try {
            config.timeStamp = Instant.now().getEpochSecond();
            String configToCache = this.gson.toJson((Object)config);
            this.inMemoryConfig = config;
            this.inMemoryConfigString = configToCache;
            this.cache.write(this.cacheKey, configToCache);
        }
        catch (Exception e) {
            this.logger.error("An error occurred during the cache write.", e);
        }
    }

    private String readCache() {
        try {
            return this.cache.read(this.cacheKey);
        }
        catch (Exception e) {
            this.logger.error("An error occurred during the cache read.", e);
            return null;
        }
    }

    private Config deserialize(String json) {
        return (Config)this.gson.fromJson(json, Config.class);
    }
}

