/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Config;
import com.configcat.ConfigCatLogger;
import com.configcat.ConfigFetcher;
import com.configcat.ConfigJsonCache;
import com.configcat.RefreshPolicy;
import com.configcat.Setting;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

abstract class RefreshPolicyBase
implements RefreshPolicy {
    private final ConfigFetcher configFetcher;
    protected final ConfigJsonCache configJsonCache;
    protected final ConfigCatLogger logger;

    protected ConfigFetcher fetcher() {
        return this.configFetcher;
    }

    RefreshPolicyBase(ConfigFetcher configFetcher, ConfigCatLogger logger, ConfigJsonCache configJsonCache) {
        this.configFetcher = configFetcher;
        this.logger = logger;
        this.configJsonCache = configJsonCache;
    }

    @Override
    public CompletableFuture<Map<String, Setting>> getSettingsAsync() {
        return this.getConfigurationAsync().thenApply(config -> config.entries);
    }

    protected abstract CompletableFuture<Config> getConfigurationAsync();

    @Override
    public CompletableFuture<Void> refreshAsync() {
        return this.fetcher().fetchAsync().thenAcceptAsync(response -> {
            if (response.isFetched()) {
                this.configJsonCache.writeToCache(response.config());
            }
        });
    }

    @Override
    public void close() throws IOException {
        this.configFetcher.close();
    }
}

