/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ConfigCatLogger;
import com.configcat.RolloutPercentageItem;
import com.configcat.RolloutRule;
import com.configcat.Setting;
import com.configcat.User;
import com.google.gson.JsonElement;
import de.skuzzle.semantic.Version;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

class RolloutEvaluator {
    private static final String[] COMPARATOR_TEXTS = new String[]{"IS ONE OF", "IS NOT ONE OF", "CONTAINS", "DOES NOT CONTAIN", "IS ONE OF (SemVer)", "IS NOT ONE OF (SemVer)", "< (SemVer)", "<= (SemVer)", "> (SemVer)", ">= (SemVer)", "= (Number)", "<> (Number)", "< (Number)", "<= (Number)", "> (Number)", ">= (Number)", "IS ONE OF (Sensitive)", "IS NOT ONE OF (Sensitive)"};
    private final ConfigCatLogger logger;

    public RolloutEvaluator(ConfigCatLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map.Entry<JsonElement, String> evaluate(Setting setting, String key, User user) {
        LogEntries logEntries = new LogEntries();
        logEntries.add("Evaluating getValue(" + key + ").");
        try {
            if (user == null) {
                if (setting.rolloutRules != null && setting.rolloutRules.length > 0 || setting.percentageItems != null && setting.percentageItems.length > 0) {
                    this.logger.warn("UserObject missing! You should pass a UserObject to getValue() in order to make targeting work properly. Read more: https://configcat.com/docs/advanced/user-object.");
                }
                logEntries.add("Returning " + setting.value + ".");
                AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(setting.value, setting.variationId);
                return simpleEntry;
            }
            logEntries.add("User object: " + user + "");
            if (setting.rolloutRules != null) {
                block31: for (RolloutRule rule : setting.rolloutRules) {
                    String comparisonAttribute = rule.comparisonAttribute;
                    String comparisonValue = rule.comparisonValue;
                    int comparator = rule.comparator;
                    JsonElement value = rule.value;
                    String variationId = rule.variationId;
                    String userValue = user.getAttribute(comparisonAttribute);
                    if (comparisonValue == null || comparisonValue.isEmpty() || userValue == null || userValue.isEmpty()) {
                        logEntries.add(this.logNoMatch(comparisonAttribute, userValue, comparator, comparisonValue));
                        continue;
                    }
                    switch (comparator) {
                        case 0: {
                            ArrayList<String> inValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            inValues.replaceAll(String::trim);
                            inValues.removeAll(Arrays.asList(null, ""));
                            if (!inValues.contains(userValue)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        case 1: {
                            ArrayList<String> notInValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            notInValues.replaceAll(String::trim);
                            notInValues.removeAll(Arrays.asList(null, ""));
                            if (notInValues.contains(userValue)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        case 2: {
                            if (!userValue.contains(comparisonValue)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        case 3: {
                            if (userValue.contains(comparisonValue)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        case 4: 
                        case 5: {
                            ArrayList<String> inSemVerValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            inSemVerValues.replaceAll(String::trim);
                            inSemVerValues.removeAll(Arrays.asList(null, ""));
                            Version userVersion = Version.parseVersion((String)userValue, (boolean)true);
                            boolean matched = false;
                            for (String semVer : inSemVerValues) {
                                matched = userVersion.compareTo(Version.parseVersion((String)semVer, (boolean)true)) == 0 || matched;
                            }
                            if ((!matched || comparator != 4) && (matched || comparator != 5)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        catch (Exception e) {
                            logEntries.add(this.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e));
                            continue block31;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            Version cmpUserVersion = Version.parseVersion((String)userValue, (boolean)true);
                            Version matchValue = Version.parseVersion((String)comparisonValue.trim(), (boolean)true);
                            if (!(comparator == 6 && cmpUserVersion.isLowerThan(matchValue) || comparator == 7 && cmpUserVersion.compareTo(matchValue) <= 0 || comparator == 8 && cmpUserVersion.isGreaterThan(matchValue)) && (comparator != 9 || cmpUserVersion.compareTo(matchValue) < 0)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        catch (Exception e) {
                            logEntries.add(this.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e));
                            continue block31;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            Double userDoubleValue = Double.parseDouble(userValue.replaceAll(",", "."));
                            Double comparisonDoubleValue = Double.parseDouble(comparisonValue.replaceAll(",", "."));
                            if (!(comparator == 10 && userDoubleValue.equals(comparisonDoubleValue) || comparator == 11 && !userDoubleValue.equals(comparisonDoubleValue) || comparator == 12 && userDoubleValue < comparisonDoubleValue || comparator == 13 && userDoubleValue <= comparisonDoubleValue || comparator == 14 && userDoubleValue > comparisonDoubleValue) && (comparator != 15 || !(userDoubleValue >= comparisonDoubleValue))) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        catch (NumberFormatException e) {
                            logEntries.add(this.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e));
                            continue block31;
                        }
                        case 16: {
                            ArrayList<String> inValuesSensitive = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            inValuesSensitive.replaceAll(String::trim);
                            inValuesSensitive.removeAll(Arrays.asList(null, ""));
                            String hashValueOne = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)userValue)));
                            if (!inValuesSensitive.contains(hashValueOne)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                        case 17: {
                            ArrayList<String> notInValuesSensitive = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            notInValuesSensitive.replaceAll(String::trim);
                            notInValuesSensitive.removeAll(Arrays.asList(null, ""));
                            String hashValueNotOne = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)userValue)));
                            if (notInValuesSensitive.contains(hashValueNotOne)) break;
                            logEntries.add(this.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value));
                            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(value, variationId);
                            return simpleEntry;
                        }
                    }
                    logEntries.add(this.logNoMatch(comparisonAttribute, userValue, comparator, comparisonValue));
                }
            }
            if (setting.percentageItems != null && setting.percentageItems.length > 0) {
                String string = key + user.getIdentifier();
                int scale = 100;
                String hexHash = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)string))).substring(0, 7);
                int longHash = Integer.parseInt(hexHash, 16);
                int scaled = longHash % scale;
                int bucket = 0;
                for (RolloutPercentageItem rule : setting.percentageItems) {
                    if (scaled >= (bucket = (int)((double)bucket + rule.percentage))) continue;
                    logEntries.add("Evaluating % options. Returning " + rule.value + ".");
                    AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(rule.value, rule.variationId);
                    return simpleEntry;
                }
            }
            logEntries.add("Returning " + setting.value + ".");
            AbstractMap.SimpleEntry<JsonElement, String> simpleEntry = new AbstractMap.SimpleEntry<JsonElement, String>(setting.value, setting.variationId);
            return simpleEntry;
        }
        finally {
            this.logger.info(logEntries.toPrint());
        }
    }

    private String logMatch(String comparisonAttribute, String userValue, int comparator, String comparisonValue, Object value) {
        return "Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => match, returning: " + value + "";
    }

    private String logNoMatch(String comparisonAttribute, String userValue, int comparator, String comparisonValue) {
        return "Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => no match";
    }

    private String logFormatError(String comparisonAttribute, String userValue, int comparator, String comparisonValue, Exception exception) {
        String message = "Evaluating rule: [" + comparisonAttribute + ":" + userValue + "] [" + COMPARATOR_TEXTS[comparator] + "] [" + comparisonValue + "] => SKIP rule. Validation error: " + exception + "";
        this.logger.warn(message);
        return message;
    }

    static class LogEntries {
        private final List<String> entries = new ArrayList<String>();

        LogEntries() {
        }

        public void add(String entry) {
            this.entries.add(entry);
        }

        public String toPrint() {
            return String.join((CharSequence)System.lineSeparator(), this.entries);
        }
    }
}

