/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.AutoPollingMode;
import com.configcat.AutoPollingPolicy;
import com.configcat.ConfigCache;
import com.configcat.ConfigCatLogger;
import com.configcat.ConfigFetcher;
import com.configcat.ConfigJsonCache;
import com.configcat.ConfigurationProvider;
import com.configcat.DataGovernance;
import com.configcat.LazyLoadingMode;
import com.configcat.LazyLoadingPolicy;
import com.configcat.LogLevel;
import com.configcat.ManualPollingMode;
import com.configcat.ManualPollingPolicy;
import com.configcat.NullConfigCache;
import com.configcat.NullRefreshPolicy;
import com.configcat.OverrideBehaviour;
import com.configcat.OverrideDataSource;
import com.configcat.OverrideDataSourceBuilder;
import com.configcat.PollingMode;
import com.configcat.PollingModes;
import com.configcat.RefreshPolicy;
import com.configcat.RefreshPolicyBase;
import com.configcat.RolloutEvaluator;
import com.configcat.RolloutPercentageItem;
import com.configcat.RolloutRule;
import com.configcat.Setting;
import com.configcat.SettingType;
import com.configcat.User;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import okhttp3.OkHttpClient;
import org.slf4j.LoggerFactory;

public final class ConfigCatClient
implements ConfigurationProvider {
    private static final String BASE_URL_GLOBAL = "https://cdn-global.configcat.com";
    private static final String BASE_URL_EU = "https://cdn-eu.configcat.com";
    private static final Set<String> SDK_KEYS = new HashSet<String>();
    private final RefreshPolicy refreshPolicy;
    private final ConfigCatLogger logger;
    private final RolloutEvaluator rolloutEvaluator;
    private final OverrideDataSource overrideDataSource;
    private final OverrideBehaviour overrideBehaviour;
    private final String sdkKey;

    private ConfigCatClient(String sdkKey, Builder builder) throws IllegalArgumentException {
        PollingMode pollingMode;
        if (sdkKey == null || sdkKey.isEmpty()) {
            throw new IllegalArgumentException("'sdkKey' cannot be null or empty.");
        }
        LogLevel logLevel = builder.logLevel == null ? LogLevel.WARNING : builder.logLevel;
        DataGovernance dataGovernance = builder.dataGovernance == null ? DataGovernance.GLOBAL : builder.dataGovernance;
        this.logger = new ConfigCatLogger(LoggerFactory.getLogger(ConfigCatClient.class), logLevel);
        if (SDK_KEYS.contains(sdkKey)) {
            this.logger.warn("A ConfigCat Client is already initialized with SDK Key '" + sdkKey + "'. We strongly recommend you to use the ConfigCat Client as a Singleton object in your application.");
        }
        SDK_KEYS.add(sdkKey);
        this.sdkKey = sdkKey;
        this.overrideDataSource = builder.localDataSourceBuilder != null ? builder.localDataSourceBuilder.build(this.logger) : new OverrideDataSource();
        this.overrideBehaviour = builder.overrideBehaviour;
        this.rolloutEvaluator = new RolloutEvaluator(this.logger);
        ConfigCache cache = builder.cache == null ? new NullConfigCache() : builder.cache;
        ConfigJsonCache configJsonCache = new ConfigJsonCache(this.logger, cache, sdkKey);
        PollingMode pollingMode2 = pollingMode = builder.pollingMode == null ? PollingModes.autoPoll(60) : builder.pollingMode;
        if (this.overrideBehaviour == OverrideBehaviour.LOCAL_ONLY) {
            this.refreshPolicy = new NullRefreshPolicy();
        } else {
            boolean hasCustomBaseUrl = builder.baseUrl != null && !builder.baseUrl.isEmpty();
            ConfigFetcher fetcher = new ConfigFetcher(builder.httpClient == null ? new OkHttpClient.Builder().retryOnConnectionFailure(true).build() : builder.httpClient, this.logger, configJsonCache, sdkKey, !hasCustomBaseUrl ? (dataGovernance == DataGovernance.GLOBAL ? BASE_URL_GLOBAL : BASE_URL_EU) : builder.baseUrl, hasCustomBaseUrl, pollingMode.getPollingIdentifier());
            this.refreshPolicy = this.selectPolicy(pollingMode, fetcher, this.logger, configJsonCache);
        }
    }

    public ConfigCatClient(String sdkKey) {
        this(sdkKey, ConfigCatClient.newBuilder());
    }

    @Override
    public <T> T getValue(Class<T> classOfT, String key, T defaultValue) {
        return this.getValue(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> T getValue(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported.");
        }
        try {
            return this.getValueAsync(classOfT, key, user, defaultValue).get();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return defaultValue;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public <T> CompletableFuture<T> getValueAsync(Class<T> classOfT, String key, T defaultValue) {
        return this.getValueAsync(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> CompletableFuture<T> getValueAsync(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported.");
        }
        return this.getSettingsAsync().thenApply(settings -> this.getValueFromSettingsMap(classOfT, (Map<String, Setting>)settings, key, user, defaultValue));
    }

    @Override
    public String getVariationId(String key, String defaultVariationId) {
        return this.getVariationId(key, null, defaultVariationId);
    }

    @Override
    public String getVariationId(String key, User user, String defaultVariationId) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        try {
            return this.getVariationIdAsync(key, user, defaultVariationId).get();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return defaultVariationId;
        }
        catch (Exception e) {
            return defaultVariationId;
        }
    }

    @Override
    public CompletableFuture<String> getVariationIdAsync(String key, String defaultVariationId) {
        return this.getVariationIdAsync(key, null, defaultVariationId);
    }

    @Override
    public CompletableFuture<String> getVariationIdAsync(String key, User user, String defaultVariationId) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        return this.getSettingsAsync().thenApply(settings -> this.getVariationIdFromSettingsMap((Map<String, Setting>)settings, key, user, defaultVariationId));
    }

    @Override
    public Collection<String> getAllVariationIds() {
        return this.getAllVariationIds(null);
    }

    @Override
    public CompletableFuture<Collection<String>> getAllVariationIdsAsync() {
        return this.getAllVariationIdsAsync(null);
    }

    @Override
    public Collection<String> getAllVariationIds(User user) {
        try {
            return this.getAllVariationIdsAsync(user).get();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return new ArrayList<String>();
        }
        catch (Exception e) {
            this.logger.error("An error occurred during getting all the variation ids. Returning empty array.", e);
            return new ArrayList<String>();
        }
    }

    @Override
    public CompletableFuture<Collection<String>> getAllVariationIdsAsync(User user) {
        return this.getSettingsAsync().thenApply(settings -> {
            try {
                Set keys = settings.keySet();
                ArrayList<String> result = new ArrayList<String>();
                for (String key : keys) {
                    result.add(this.getVariationIdFromSettingsMap((Map<String, Setting>)settings, key, user, null));
                }
                return result;
            }
            catch (Exception e) {
                this.logger.error("An error occurred during getting all the variation ids. Returning empty array.", e);
                return new ArrayList();
            }
        });
    }

    @Override
    public Map<String, Object> getAllValues(User user) {
        try {
            return this.getAllValuesAsync(user).get();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            this.logger.error("An error occurred during getting all values. Returning empty map.", e);
            return new HashMap<String, Object>();
        }
    }

    @Override
    public CompletableFuture<Map<String, Object>> getAllValuesAsync(User user) {
        return this.getSettingsAsync().thenApply(settings -> {
            try {
                Set keys = settings.keySet();
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (String key : keys) {
                    Setting setting = (Setting)settings.get(key);
                    JsonElement evaluated = this.rolloutEvaluator.evaluate(setting, key, user).getKey();
                    Object value = this.parseObject(this.classBySettingType(setting.type), evaluated);
                    result.put(key, value);
                }
                return result;
            }
            catch (Exception e) {
                this.logger.error("An error occurred during getting all values. Returning empty map.", e);
                return new HashMap();
            }
        });
    }

    @Override
    public <T> Map.Entry<String, T> getKeyAndValue(Class<T> classOfT, String variationId) {
        if (variationId == null || variationId.isEmpty()) {
            throw new IllegalArgumentException("'variationId' cannot be null or empty.");
        }
        try {
            return this.getKeyAndValueAsync(classOfT, variationId).get();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public <T> CompletableFuture<Map.Entry<String, T>> getKeyAndValueAsync(Class<T> classOfT, String variationId) {
        if (variationId == null || variationId.isEmpty()) {
            throw new IllegalArgumentException("'variationId' cannot be null or empty.");
        }
        return this.getSettingsAsync().thenApply(settings -> this.getKeyAndValueFromSettingsMap(classOfT, (Map<String, Setting>)settings, variationId));
    }

    @Override
    public Collection<String> getAllKeys() {
        try {
            return this.getAllKeysAsync().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error("Thread interrupted.", e);
            return new ArrayList<String>();
        }
        catch (Exception e) {
            this.logger.error("An error occurred during getting all the setting keys. Returning empty array.", e);
            return new ArrayList<String>();
        }
    }

    @Override
    public CompletableFuture<Collection<String>> getAllKeysAsync() {
        return this.getSettingsAsync().thenApply(settings -> {
            try {
                return settings.keySet();
            }
            catch (Exception e) {
                this.logger.error("An error occurred during getting all the setting keys. Returning empty array.", e);
                return new ArrayList();
            }
        });
    }

    @Override
    public void forceRefresh() {
        try {
            this.forceRefreshAsync().get();
        }
        catch (InterruptedException e) {
            this.logger.error("Thread interrupted.", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.logger.error("An error occurred during the refresh.", e);
        }
    }

    @Override
    public CompletableFuture<Void> forceRefreshAsync() {
        return this.refreshPolicy.refreshAsync();
    }

    @Override
    public void close() throws IOException {
        this.refreshPolicy.close();
        this.overrideDataSource.close();
        SDK_KEYS.remove(this.sdkKey);
    }

    private CompletableFuture<Map<String, Setting>> getSettingsAsync() {
        if (this.overrideBehaviour != null) {
            switch (this.overrideBehaviour) {
                case LOCAL_ONLY: {
                    return CompletableFuture.completedFuture(this.overrideDataSource.getLocalConfiguration());
                }
                case REMOTE_OVER_LOCAL: {
                    return this.refreshPolicy.getSettingsAsync().thenApply(settings -> {
                        HashMap<String, Setting> localSettings = new HashMap<String, Setting>(this.overrideDataSource.getLocalConfiguration());
                        localSettings.putAll((Map<String, Setting>)settings);
                        return localSettings;
                    });
                }
                case LOCAL_OVER_REMOTE: {
                    return this.refreshPolicy.getSettingsAsync().thenApply(settings -> {
                        Map<String, Setting> localSettings = this.overrideDataSource.getLocalConfiguration();
                        HashMap<String, Setting> remoteSettings = new HashMap<String, Setting>((Map<String, Setting>)settings);
                        remoteSettings.putAll(localSettings);
                        return remoteSettings;
                    });
                }
            }
        }
        return this.refreshPolicy.getSettingsAsync();
    }

    private <T> T getValueFromSettingsMap(Class<T> classOfT, Map<String, Setting> settings, String key, User user, T defaultValue) {
        try {
            if (settings.isEmpty()) {
                this.logger.error("Config JSON is not present. Returning defaultValue: [" + defaultValue + "].");
                return defaultValue;
            }
            Setting setting = settings.get(key);
            if (setting == null) {
                this.logger.error("Value not found for key " + key + ". Here are the available keys: " + String.join((CharSequence)", ", settings.keySet()));
                return defaultValue;
            }
            return (T)this.parseObject(classOfT, this.rolloutEvaluator.evaluate(setting, key, user).getKey());
        }
        catch (Exception e) {
            this.logger.error("Evaluating getValue('" + key + "') failed. Returning defaultValue: [" + defaultValue + "]. " + e.getMessage(), e);
            return defaultValue;
        }
    }

    private String getVariationIdFromSettingsMap(Map<String, Setting> settings, String key, User user, String defaultVariationId) {
        try {
            if (settings.isEmpty()) {
                this.logger.error("Config JSON is not present. Returning defaultVariationId: [" + defaultVariationId + "].");
                return defaultVariationId;
            }
            Setting setting = settings.get(key);
            if (setting == null) {
                this.logger.error("Variation ID not found for key " + key + ". Here are the available keys: " + String.join((CharSequence)", ", settings.keySet()));
                return defaultVariationId;
            }
            return this.rolloutEvaluator.evaluate(setting, key, user).getValue();
        }
        catch (Exception e) {
            this.logger.error("Evaluating getVariationId('" + key + "') failed. Returning defaultVariationId: [" + defaultVariationId + "]. " + e.getMessage(), e);
            return defaultVariationId;
        }
    }

    private <T> Map.Entry<String, T> getKeyAndValueFromSettingsMap(Class<T> classOfT, Map<String, Setting> settings, String variationId) {
        try {
            if (settings.isEmpty()) {
                this.logger.error("Config JSON is not present. Returning null.");
                return null;
            }
            for (Map.Entry<String, Setting> node : settings.entrySet()) {
                String settingKey = node.getKey();
                Setting setting = node.getValue();
                if (variationId.equals(setting.variationId)) {
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, setting.value));
                }
                for (RolloutRule rolloutRule : setting.rolloutRules) {
                    if (!variationId.equals(rolloutRule.variationId)) continue;
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, rolloutRule.value));
                }
                for (RolloutPercentageItem percentageRule : setting.percentageItems) {
                    if (!variationId.equals(percentageRule.variationId)) continue;
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, percentageRule.value));
                }
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error("Could not find the setting for the given variation ID: " + variationId);
            return null;
        }
    }

    private RefreshPolicyBase selectPolicy(PollingMode mode, ConfigFetcher fetcher, ConfigCatLogger logger, ConfigJsonCache configJsonCache) {
        if (mode instanceof AutoPollingMode) {
            return new AutoPollingPolicy(fetcher, logger, configJsonCache, (AutoPollingMode)mode);
        }
        if (mode instanceof LazyLoadingMode) {
            return new LazyLoadingPolicy(fetcher, logger, configJsonCache, (LazyLoadingMode)mode);
        }
        if (mode instanceof ManualPollingMode) {
            return new ManualPollingPolicy(fetcher, logger, configJsonCache);
        }
        throw new InvalidParameterException("The polling mode parameter is invalid.");
    }

    private Object parseObject(Class<?> classOfT, JsonElement element) {
        if (classOfT == String.class) {
            return element.getAsString();
        }
        if (classOfT == Integer.class || classOfT == Integer.TYPE) {
            return element.getAsInt();
        }
        if (classOfT == Double.class || classOfT == Double.TYPE) {
            return element.getAsDouble();
        }
        if (classOfT == Boolean.class || classOfT == Boolean.TYPE) {
            return element.getAsBoolean();
        }
        throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported");
    }

    private Class<?> classBySettingType(int settingType) {
        if (settingType == SettingType.BOOLEAN.ordinal()) {
            return Boolean.TYPE;
        }
        if (settingType == SettingType.STRING.ordinal()) {
            return String.class;
        }
        if (settingType == SettingType.INT.ordinal()) {
            return Integer.TYPE;
        }
        if (settingType == SettingType.DOUBLE.ordinal()) {
            return Double.TYPE;
        }
        throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private OkHttpClient httpClient;
        private ConfigCache cache;
        private String baseUrl;
        private PollingMode pollingMode;
        private LogLevel logLevel;
        private DataGovernance dataGovernance;
        private OverrideDataSourceBuilder localDataSourceBuilder;
        private OverrideBehaviour overrideBehaviour;

        public Builder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder cache(ConfigCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public Builder mode(PollingMode pollingMode) {
            this.pollingMode = pollingMode;
            return this;
        }

        public Builder dataGovernance(DataGovernance dataGovernance) {
            this.dataGovernance = dataGovernance;
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder flagOverrides(OverrideDataSourceBuilder dataSourceBuilder, OverrideBehaviour behaviour) {
            if (dataSourceBuilder == null) {
                throw new IllegalArgumentException("'dataSourceBuilder' cannot be null or empty.");
            }
            if (behaviour == null) {
                throw new IllegalArgumentException("'behaviour' cannot be null.");
            }
            this.localDataSourceBuilder = dataSourceBuilder;
            this.overrideBehaviour = behaviour;
            return this;
        }

        public ConfigCatClient build(String sdkKey) {
            return new ConfigCatClient(sdkKey, this);
        }
    }
}

