/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.Config;
import com.configcat.ConfigCatLogger;
import com.configcat.OverrideDataSource;
import com.configcat.Setting;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;

class LocalFileDataSource
extends OverrideDataSource {
    private final ConfigCatLogger logger;
    private final Gson gson = new GsonBuilder().create();
    private Map<String, Setting> loadedSettings = new HashMap<String, Setting>();
    private final FileWatcher watcher;
    private final String filePath;
    private final boolean isResource;

    public LocalFileDataSource(String filePath, boolean isResource, ConfigCatLogger logger, boolean autoReload) {
        this.isResource = isResource;
        this.logger = logger;
        this.filePath = filePath;
        this.logger.debug("Reading " + this.filePath + " for local overrides.");
        this.reloadFileContent();
        FileWatcher fileWatcher = null;
        if (autoReload && !isResource) {
            Path path = Paths.get(filePath, new String[0]);
            try {
                fileWatcher = FileWatcher.create(Paths.get(filePath, new String[0]));
                fileWatcher.start(this::reloadFileContent);
            }
            catch (IOException e) {
                this.logger.error("Error during initializing file watcher on " + path + ".", e);
            }
        }
        this.watcher = fileWatcher;
    }

    @Override
    public Map<String, Setting> getLocalConfiguration() {
        return this.loadedSettings;
    }

    @Override
    public void close() throws IOException {
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    private void reloadFileContent() {
        String content = null;
        try {
            content = this.readFile();
        }
        catch (IOException e) {
            this.logger.error("Error during reading " + this.filePath + ".", e);
        }
        if (content != null && !content.isEmpty()) {
            SimplifiedConfig simplifiedConfig = (SimplifiedConfig)this.gson.fromJson(content, SimplifiedConfig.class);
            if (simplifiedConfig != null && simplifiedConfig.entries != null && simplifiedConfig.entries.size() > 0) {
                for (Map.Entry<String, JsonElement> entry : simplifiedConfig.entries.entrySet()) {
                    Setting setting = new Setting();
                    setting.setValue(entry.getValue());
                    this.loadedSettings.put(entry.getKey(), setting);
                }
                return;
            }
            Config config = (Config)this.gson.fromJson(content, Config.class);
            this.loadedSettings = config != null ? config.getEntries() : new HashMap<String, Setting>();
        }
    }

    private String readFile() throws IOException {
        if (this.isResource) {
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.filePath);){
                int temp;
                if (stream == null) {
                    throw new IOException();
                }
                byte[] buffer = new byte[4096];
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while ((temp = stream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, temp);
                }
                String string = new String(outputStream.toByteArray(), Charset.defaultCharset());
                return string;
            }
        }
        byte[] content = Files.readAllBytes(Paths.get(this.filePath, new String[0]));
        return new String(content, Charset.defaultCharset());
    }

    private static class SimplifiedConfig {
        @SerializedName(value="flags")
        public Map<String, JsonElement> entries;

        private SimplifiedConfig() {
        }
    }

    private static final class FileWatcher
    implements Runnable {
        private final WatchService watchService;
        private final Thread watchThread;
        private volatile boolean interrupted;
        private Runnable onModifiedAction;
        private final Path filePath;

        public static FileWatcher create(Path filePath) throws IOException {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            Path path = filePath.getParent();
            path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            return new FileWatcher(watchService, filePath);
        }

        private FileWatcher(WatchService watchService, Path filePath) {
            this.watchService = watchService;
            this.filePath = filePath;
            this.watchThread = new Thread((Runnable)this, FileWatcher.class.getName());
            this.watchThread.setDaemon(true);
        }

        @Override
        public void run() {
            while (!this.interrupted) {
                try {
                    WatchKey key = this.watchService.take();
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path changed = (Path)event.context();
                        if (!changed.endsWith(this.filePath.getFileName())) continue;
                        this.onModifiedAction.run();
                    }
                    key.reset();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        public void start(Runnable onModifiedAction) {
            this.onModifiedAction = onModifiedAction;
            this.watchThread.start();
        }

        public void stop() {
            this.interrupted = true;
            this.watchThread.interrupt();
        }
    }
}

