/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ConfigCatHooks;
import com.configcat.LogLevel;
import org.slf4j.Logger;

class ConfigCatLogger {
    private final Logger logger;
    private final LogLevel logLevel;
    private final ConfigCatHooks configCatHooks;

    public ConfigCatLogger(Logger logger, LogLevel logLevel, ConfigCatHooks configCatHooks) {
        this.logger = logger;
        this.logLevel = logLevel;
        this.configCatHooks = configCatHooks;
    }

    public ConfigCatLogger(Logger logger, LogLevel logLevel) {
        this(logger, logLevel, null);
    }

    public ConfigCatLogger(Logger logger) {
        this(logger, LogLevel.WARNING);
    }

    public void warn(int eventId, String message) {
        if (this.logLevel.ordinal() <= LogLevel.WARNING.ordinal()) {
            this.logger.warn("[{}] {}", (Object)eventId, (Object)message);
        }
    }

    public void error(int eventId, String message, Exception exception) {
        if (this.configCatHooks != null) {
            this.configCatHooks.invokeOnError(message);
        }
        if (this.logLevel.ordinal() <= LogLevel.ERROR.ordinal()) {
            this.logger.error("[{}] {}", new Object[]{eventId, message, exception});
        }
    }

    public void error(int eventId, String message) {
        if (this.configCatHooks != null) {
            this.configCatHooks.invokeOnError(message);
        }
        if (this.logLevel.ordinal() <= LogLevel.ERROR.ordinal()) {
            this.logger.error("[{}] {}", (Object)eventId, (Object)message);
        }
    }

    public void info(int eventId, String message) {
        if (this.logLevel.ordinal() <= LogLevel.INFO.ordinal()) {
            this.logger.info("[{}] {}", (Object)eventId, (Object)message);
        }
    }

    public void debug(String message) {
        if (this.logLevel.ordinal() <= LogLevel.DEBUG.ordinal()) {
            this.logger.debug("[{}] {}", (Object)0, (Object)message);
        }
    }
}

