/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ConfigCatLogMessages;
import com.configcat.ConfigCatLogger;
import com.configcat.EvaluateLogger;
import com.configcat.EvaluationResult;
import com.configcat.PercentageRule;
import com.configcat.RolloutRule;
import com.configcat.Setting;
import com.configcat.User;
import com.google.gson.JsonElement;
import de.skuzzle.semantic.Version;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

class RolloutEvaluator {
    protected static final String[] COMPARATOR_TEXTS = new String[]{"IS ONE OF", "IS NOT ONE OF", "CONTAINS", "DOES NOT CONTAIN", "IS ONE OF (SemVer)", "IS NOT ONE OF (SemVer)", "< (SemVer)", "<= (SemVer)", "> (SemVer)", ">= (SemVer)", "= (Number)", "<> (Number)", "< (Number)", "<= (Number)", "> (Number)", ">= (Number)", "IS ONE OF (Sensitive)", "IS NOT ONE OF (Sensitive)"};
    private final ConfigCatLogger logger;

    public RolloutEvaluator(ConfigCatLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EvaluationResult evaluate(Setting setting, String key, User user) {
        EvaluateLogger evaluateLogger = new EvaluateLogger(key);
        try {
            if (user == null) {
                if (setting.getRolloutRules() != null && setting.getRolloutRules().length > 0 || setting.getPercentageItems() != null && setting.getPercentageItems().length > 0) {
                    this.logger.warn(3001, ConfigCatLogMessages.getTargetingIsNotPossible(key));
                }
                evaluateLogger.logReturnValue(setting.getValue().toString());
                EvaluationResult evaluationResult = new EvaluationResult(setting.getValue(), setting.getVariationId(), null, null);
                return evaluationResult;
            }
            evaluateLogger.logUserObject(user);
            if (setting.getRolloutRules() != null) {
                block31: for (RolloutRule rule : setting.getRolloutRules()) {
                    String comparisonAttribute = rule.getComparisonAttribute();
                    String comparisonValue = rule.getComparisonValue();
                    int comparator = rule.getComparator();
                    JsonElement value = rule.getValue();
                    String variationId = rule.getVariationId();
                    String userValue = user.getAttribute(comparisonAttribute);
                    if (comparisonValue == null || comparisonValue.isEmpty() || userValue == null || userValue.isEmpty()) {
                        evaluateLogger.logNoMatch(comparisonAttribute, userValue, comparator, comparisonValue);
                        continue;
                    }
                    switch (comparator) {
                        case 0: {
                            ArrayList<String> inValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            inValues.replaceAll(String::trim);
                            inValues.removeAll(Arrays.asList(null, ""));
                            if (!inValues.contains(userValue)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            EvaluationResult evaluationResult = new EvaluationResult(value, variationId, rule, null);
                            return evaluationResult;
                        }
                        case 1: {
                            ArrayList<String> notInValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            notInValues.replaceAll(String::trim);
                            notInValues.removeAll(Arrays.asList(null, ""));
                            if (notInValues.contains(userValue)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            EvaluationResult evaluationResult = new EvaluationResult(value, variationId, rule, null);
                            return evaluationResult;
                        }
                        case 2: {
                            if (!userValue.contains(comparisonValue)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            EvaluationResult evaluationResult = new EvaluationResult(value, variationId, rule, null);
                            return evaluationResult;
                        }
                        case 3: {
                            if (userValue.contains(comparisonValue)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            EvaluationResult evaluationResult = new EvaluationResult(value, variationId, rule, null);
                            return evaluationResult;
                        }
                        case 4: 
                        case 5: {
                            ArrayList<String> inSemVerValues = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            inSemVerValues.replaceAll(String::trim);
                            inSemVerValues.removeAll(Arrays.asList(null, ""));
                            Version userVersion = Version.parseVersion((String)userValue, (boolean)true);
                            boolean matched = false;
                            for (String semVer : inSemVerValues) {
                                matched = userVersion.compareTo(Version.parseVersion((String)semVer, (boolean)true)) == 0 || matched;
                            }
                            if ((!matched || comparator != 4) && (matched || comparator != 5)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            Object object = new EvaluationResult(value, variationId, rule, null);
                            return object;
                        }
                        catch (Exception e) {
                            String message = evaluateLogger.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e);
                            this.logger.warn(0, message);
                            continue block31;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: {
                            Version cmpUserVersion = Version.parseVersion((String)userValue, (boolean)true);
                            Version matchValue = Version.parseVersion((String)comparisonValue.trim(), (boolean)true);
                            if (!(comparator == 6 && cmpUserVersion.isLowerThan(matchValue) || comparator == 7 && cmpUserVersion.compareTo(matchValue) <= 0 || comparator == 8 && cmpUserVersion.isGreaterThan(matchValue)) && (comparator != 9 || cmpUserVersion.compareTo(matchValue) < 0)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            Object object = new EvaluationResult(value, variationId, rule, null);
                            return object;
                        }
                        catch (Exception e) {
                            String message = evaluateLogger.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e);
                            this.logger.warn(0, message);
                            continue block31;
                        }
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: {
                            Double userDoubleValue = Double.parseDouble(userValue.replaceAll(",", "."));
                            Double comparisonDoubleValue = Double.parseDouble(comparisonValue.replaceAll(",", "."));
                            if (!(comparator == 10 && userDoubleValue.equals(comparisonDoubleValue) || comparator == 11 && !userDoubleValue.equals(comparisonDoubleValue) || comparator == 12 && userDoubleValue < comparisonDoubleValue || comparator == 13 && userDoubleValue <= comparisonDoubleValue || comparator == 14 && userDoubleValue > comparisonDoubleValue) && (comparator != 15 || !(userDoubleValue >= comparisonDoubleValue))) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            Object object = new EvaluationResult(value, variationId, rule, null);
                            return object;
                        }
                        catch (NumberFormatException e) {
                            String message = evaluateLogger.logFormatError(comparisonAttribute, userValue, comparator, comparisonValue, e);
                            this.logger.warn(0, message);
                            continue block31;
                        }
                        case 16: {
                            ArrayList<String> inValuesSensitive = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            inValuesSensitive.replaceAll(String::trim);
                            inValuesSensitive.removeAll(Arrays.asList(null, ""));
                            String hashValueOne = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)userValue)));
                            if (!inValuesSensitive.contains(hashValueOne)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            Object object = new EvaluationResult(value, variationId, rule, null);
                            return object;
                        }
                        case 17: {
                            ArrayList<String> notInValuesSensitive = new ArrayList<String>(Arrays.asList(comparisonValue.split(",")));
                            notInValuesSensitive.replaceAll(String::trim);
                            notInValuesSensitive.removeAll(Arrays.asList(null, ""));
                            String hashValueNotOne = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)userValue)));
                            if (notInValuesSensitive.contains(hashValueNotOne)) break;
                            evaluateLogger.logMatch(comparisonAttribute, userValue, comparator, comparisonValue, value);
                            EvaluationResult evaluationResult = new EvaluationResult(value, variationId, rule, null);
                            return evaluationResult;
                        }
                    }
                    evaluateLogger.logNoMatch(comparisonAttribute, userValue, comparator, comparisonValue);
                }
            }
            if (setting.getPercentageItems() != null && setting.getPercentageItems().length > 0) {
                String string = key + user.getIdentifier();
                int scale = 100;
                String hexHash = new String(Hex.encodeHex((byte[])DigestUtils.sha1((String)string))).substring(0, 7);
                int longHash = Integer.parseInt(hexHash, 16);
                int scaled = longHash % scale;
                int bucket = 0;
                for (PercentageRule rule : setting.getPercentageItems()) {
                    if (scaled >= (bucket = (int)((double)bucket + rule.getPercentage()))) continue;
                    evaluateLogger.logPercentageEvaluationReturnValue(rule.getValue().toString());
                    EvaluationResult evaluationResult = new EvaluationResult(rule.getValue(), rule.getVariationId(), null, rule);
                    return evaluationResult;
                }
            }
            evaluateLogger.logReturnValue(setting.getValue().toString());
            EvaluationResult evaluationResult = new EvaluationResult(setting.getValue(), setting.getVariationId(), null, null);
            return evaluationResult;
        }
        finally {
            this.logger.info(5000, evaluateLogger.toPrint());
        }
    }
}

