/*
 * Decompiled with CFR 0.152.
 */
package com.configcat;

import com.configcat.ConfigCache;
import com.configcat.ConfigCatHooks;
import com.configcat.ConfigCatLogMessages;
import com.configcat.ConfigCatLogger;
import com.configcat.ConfigFetcher;
import com.configcat.ConfigService;
import com.configcat.ConfigurationProvider;
import com.configcat.DataGovernance;
import com.configcat.EvaluationDetails;
import com.configcat.EvaluationResult;
import com.configcat.LogLevel;
import com.configcat.NullConfigCache;
import com.configcat.OverrideBehaviour;
import com.configcat.OverrideDataSource;
import com.configcat.OverrideDataSourceBuilder;
import com.configcat.PercentageRule;
import com.configcat.PollingMode;
import com.configcat.PollingModes;
import com.configcat.RefreshResult;
import com.configcat.Result;
import com.configcat.RolloutEvaluator;
import com.configcat.RolloutRule;
import com.configcat.Setting;
import com.configcat.SettingResult;
import com.configcat.SettingType;
import com.configcat.User;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import org.slf4j.LoggerFactory;

public final class ConfigCatClient
implements ConfigurationProvider {
    private static final String BASE_URL_GLOBAL = "https://cdn-global.configcat.com";
    private static final String BASE_URL_EU = "https://cdn-eu.configcat.com";
    private static final Map<String, ConfigCatClient> INSTANCES = new HashMap<String, ConfigCatClient>();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final ConfigCatLogger logger;
    private final RolloutEvaluator rolloutEvaluator;
    private final OverrideDataSource overrideDataSource;
    private final OverrideBehaviour overrideBehaviour;
    private final String sdkKey;
    private User defaultUser;
    private ConfigService configService;
    private final ConfigCatHooks configCatHooks;

    private ConfigCatClient(String sdkKey, Options options) throws IllegalArgumentException {
        if (sdkKey == null || sdkKey.isEmpty()) {
            throw new IllegalArgumentException("'sdkKey' cannot be null or empty.");
        }
        this.logger = new ConfigCatLogger(LoggerFactory.getLogger(ConfigCatClient.class), options.logLevel, options.configCatHooks);
        this.sdkKey = sdkKey;
        this.overrideDataSource = options.localDataSourceBuilder != null ? options.localDataSourceBuilder.build(this.logger) : new OverrideDataSource();
        this.overrideBehaviour = options.overrideBehaviour;
        this.rolloutEvaluator = new RolloutEvaluator(this.logger);
        this.configCatHooks = options.configCatHooks;
        if (this.overrideBehaviour != OverrideBehaviour.LOCAL_ONLY) {
            boolean hasCustomBaseUrl = options.baseUrl != null && !options.baseUrl.isEmpty();
            ConfigFetcher fetcher = new ConfigFetcher(options.httpClient == null ? new OkHttpClient.Builder().build() : options.httpClient, this.logger, sdkKey, !hasCustomBaseUrl ? (options.dataGovernance == DataGovernance.GLOBAL ? BASE_URL_GLOBAL : BASE_URL_EU) : options.baseUrl, hasCustomBaseUrl, options.pollingMode.getPollingIdentifier());
            this.configService = new ConfigService(sdkKey, fetcher, options.pollingMode, options.cache, this.logger, options.offline, options.configCatHooks);
        }
        this.defaultUser = options.defaultUser;
    }

    @Override
    public <T> T getValue(Class<T> classOfT, String key, T defaultValue) {
        return this.getValue(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> T getValue(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported.");
        }
        try {
            return this.getValueAsync(classOfT, key, user, defaultValue).get();
        }
        catch (InterruptedException e) {
            this.logger.error(0, "Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return defaultValue;
        }
        catch (Exception e) {
            this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithDefaultValue("getValue", key, "defaultValue", defaultValue.toString()), e);
            return defaultValue;
        }
    }

    @Override
    public <T> CompletableFuture<T> getValueAsync(Class<T> classOfT, String key, T defaultValue) {
        return this.getValueAsync(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> CompletableFuture<T> getValueAsync(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported.");
        }
        return this.getSettingsAsync().thenApply(settingResult -> this.getValueFromSettingsMap(classOfT, (SettingResult)settingResult, key, user, defaultValue));
    }

    @Override
    public <T> EvaluationDetails<T> getValueDetails(Class<T> classOfT, String key, T defaultValue) {
        return this.getValueDetails(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> EvaluationDetails<T> getValueDetails(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported.");
        }
        try {
            return this.getValueDetailsAsync(classOfT, key, user, defaultValue).get();
        }
        catch (InterruptedException e) {
            String error = "Thread interrupted.";
            this.logger.error(0, error, e);
            Thread.currentThread().interrupt();
            return EvaluationDetails.fromError(key, defaultValue, error + ": " + e.getMessage(), user);
        }
        catch (Exception e) {
            this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithDefaultValue("getValueDetails", key, "defaultValue", defaultValue), e);
            return EvaluationDetails.fromError(key, defaultValue, e.getMessage(), user);
        }
    }

    @Override
    public <T> CompletableFuture<EvaluationDetails<T>> getValueDetailsAsync(Class<T> classOfT, String key, T defaultValue) {
        return this.getValueDetailsAsync(classOfT, key, null, defaultValue);
    }

    @Override
    public <T> CompletableFuture<EvaluationDetails<T>> getValueDetailsAsync(Class<T> classOfT, String key, User user, T defaultValue) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("'key' cannot be null or empty.");
        }
        if (classOfT != String.class && classOfT != Integer.class && classOfT != Integer.TYPE && classOfT != Double.class && classOfT != Double.TYPE && classOfT != Boolean.class && classOfT != Boolean.TYPE) {
            throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported.");
        }
        return this.getSettingsAsync().thenApply(settingsResult -> {
            Result<Setting> checkSettingResult = this.checkSettingAvailable((SettingResult)settingsResult, key, defaultValue);
            if (checkSettingResult.error() != null) {
                EvaluationDetails<Object> evaluationDetails = EvaluationDetails.fromError(key, defaultValue, checkSettingResult.error(), user);
                this.configCatHooks.invokeOnFlagEvaluated(evaluationDetails);
                return evaluationDetails.asTypeSpecific();
            }
            return this.evaluate(classOfT, checkSettingResult.value(), key, user != null ? user : this.defaultUser, settingsResult.fetchTime());
        });
    }

    @Override
    public Map<String, Object> getAllValues() {
        return this.getAllValues(null);
    }

    @Override
    public Map<String, Object> getAllValues(User user) {
        try {
            return this.getAllValuesAsync(user).get();
        }
        catch (InterruptedException e) {
            this.logger.error(0, "Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return new HashMap<String, Object>();
        }
        catch (Exception e) {
            this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getAllValues", "empty map"), e);
            return new HashMap<String, Object>();
        }
    }

    @Override
    public CompletableFuture<Map<String, Object>> getAllValuesAsync() {
        return this.getAllValuesAsync(null);
    }

    @Override
    public CompletableFuture<Map<String, Object>> getAllValuesAsync(User user) {
        return this.getSettingsAsync().thenApply(settingResult -> {
            try {
                if (!this.checkSettingsAvailable((SettingResult)settingResult, "empty map")) {
                    return new HashMap();
                }
                Map<String, Setting> settings = settingResult.settings();
                Set<String> keys = settings.keySet();
                HashMap<String, Object> result = new HashMap<String, Object>();
                for (String key : keys) {
                    Setting setting = settings.get(key);
                    JsonElement evaluated = this.rolloutEvaluator.evaluate((Setting)setting, (String)key, (User)this.getEvaluateUser((User)user)).value;
                    Object value = this.parseObject(this.classBySettingType(setting.getType()), evaluated);
                    result.put(key, value);
                }
                return result;
            }
            catch (Exception e) {
                this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getAllValuesAsync", "empty map"), e);
                return new HashMap();
            }
        });
    }

    @Override
    public List<EvaluationDetails<Object>> getAllValueDetails() {
        return this.getAllValueDetails(null);
    }

    @Override
    public List<EvaluationDetails<Object>> getAllValueDetails(User user) {
        try {
            return this.getAllValueDetailsAsync(user).get();
        }
        catch (InterruptedException e) {
            this.logger.error(0, "Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return new ArrayList<EvaluationDetails<Object>>();
        }
        catch (Exception e) {
            this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getAllValueDetails", "empty list"), e);
            return new ArrayList<EvaluationDetails<Object>>();
        }
    }

    @Override
    public CompletableFuture<List<EvaluationDetails<Object>>> getAllValueDetailsAsync() {
        return this.getAllValueDetailsAsync(null);
    }

    @Override
    public CompletableFuture<List<EvaluationDetails<Object>>> getAllValueDetailsAsync(User user) {
        return this.getSettingsAsync().thenApply(settingResult -> {
            try {
                if (!this.checkSettingsAvailable((SettingResult)settingResult, "empty list")) {
                    return new ArrayList();
                }
                Map<String, Setting> settings = settingResult.settings();
                ArrayList<EvaluationDetails<Object>> result = new ArrayList<EvaluationDetails<Object>>();
                for (String key : settings.keySet()) {
                    Setting setting = settings.get(key);
                    EvaluationDetails<Object> evaluationDetails = this.evaluateObject(this.classBySettingType(setting.getType()), setting, key, user != null ? user : this.defaultUser, settingResult.fetchTime());
                    result.add(evaluationDetails);
                }
                return result;
            }
            catch (Exception e) {
                this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getAllValueDetailsAsync", "empty list"), e);
                return new ArrayList();
            }
        });
    }

    @Override
    public <T> Map.Entry<String, T> getKeyAndValue(Class<T> classOfT, String variationId) {
        if (variationId == null || variationId.isEmpty()) {
            throw new IllegalArgumentException("'variationId' cannot be null or empty.");
        }
        try {
            return this.getKeyAndValueAsync(classOfT, variationId).get();
        }
        catch (InterruptedException e) {
            this.logger.error(0, "Thread interrupted.", e);
            Thread.currentThread().interrupt();
            return null;
        }
        catch (Exception e) {
            this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getKeyAndValue", "null"), e);
            return null;
        }
    }

    @Override
    public <T> CompletableFuture<Map.Entry<String, T>> getKeyAndValueAsync(Class<T> classOfT, String variationId) {
        if (variationId == null || variationId.isEmpty()) {
            throw new IllegalArgumentException("'variationId' cannot be null or empty.");
        }
        return this.getSettingsAsync().thenApply(settingsResult -> this.getKeyAndValueFromSettingsMap(classOfT, (SettingResult)settingsResult, variationId));
    }

    @Override
    public Collection<String> getAllKeys() {
        try {
            return this.getAllKeysAsync().get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.logger.error(0, "Thread interrupted.", e);
            return new ArrayList<String>();
        }
        catch (Exception e) {
            this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getAllKeys", "empty array"), e);
            return new ArrayList<String>();
        }
    }

    @Override
    public CompletableFuture<Collection<String>> getAllKeysAsync() {
        return this.getSettingsAsync().thenApply(settingResult -> {
            try {
                if (!this.checkSettingsAvailable((SettingResult)settingResult, "empty array")) {
                    return new ArrayList();
                }
                return settingResult.settings().keySet();
            }
            catch (Exception e) {
                this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getAllKeysAsync", "empty array"), e);
                return new ArrayList();
            }
        });
    }

    @Override
    public RefreshResult forceRefresh() {
        try {
            return this.forceRefreshAsync().get();
        }
        catch (InterruptedException e) {
            this.logger.error(0, "Thread interrupted.", e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            this.logger.error(1003, ConfigCatLogMessages.getForceRefreshError("forceRefresh"), e);
        }
        return new RefreshResult(false, "An error occurred during the refresh.");
    }

    @Override
    public CompletableFuture<RefreshResult> forceRefreshAsync() {
        return this.configService.refresh();
    }

    @Override
    public void setDefaultUser(User defaultUser) {
        if (this.isClosed()) {
            this.logger.warn(3201, ConfigCatLogMessages.getConfigServiceMethodHasNoEffectDueToClosedClient("setDefaultUser"));
            return;
        }
        this.defaultUser = defaultUser;
    }

    @Override
    public void clearDefaultUser() {
        if (this.isClosed()) {
            this.logger.warn(3201, ConfigCatLogMessages.getConfigServiceMethodHasNoEffectDueToClosedClient("clearDefaultUser"));
            return;
        }
        this.defaultUser = null;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed.get();
    }

    @Override
    public void setOnline() {
        if (this.configService != null && !this.isClosed()) {
            this.configService.setOnline();
        } else {
            this.logger.warn(3201, ConfigCatLogMessages.getConfigServiceMethodHasNoEffectDueToClosedClient("setOnline"));
        }
    }

    @Override
    public void setOffline() {
        if (this.configService != null && !this.isClosed()) {
            this.configService.setOffline();
        } else {
            this.logger.warn(3201, ConfigCatLogMessages.getConfigServiceMethodHasNoEffectDueToClosedClient("setOffline"));
        }
    }

    @Override
    public boolean isOffline() {
        if (this.configService == null) {
            return true;
        }
        return this.configService.isOffline();
    }

    @Override
    public ConfigCatHooks getHooks() {
        return this.configCatHooks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.isClosed.compareAndSet(false, true)) {
            return;
        }
        Map<String, ConfigCatClient> map = INSTANCES;
        synchronized (map) {
            ConfigCatClient client = INSTANCES.get(this.sdkKey);
            if (client != null) {
                if (!this.equals(client)) {
                    return;
                }
                this.closeResources();
                INSTANCES.remove(this.sdkKey);
            } else {
                this.closeResources();
            }
        }
    }

    private void closeResources() throws IOException {
        if (this.configService != null) {
            this.configService.close();
        }
        this.overrideDataSource.close();
        this.configCatHooks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() throws IOException {
        Map<String, ConfigCatClient> map = INSTANCES;
        synchronized (map) {
            for (ConfigCatClient client : INSTANCES.values()) {
                client.closeResources();
            }
            INSTANCES.clear();
        }
    }

    private CompletableFuture<SettingResult> getSettingsAsync() {
        if (this.overrideBehaviour != null) {
            switch (this.overrideBehaviour) {
                case LOCAL_ONLY: {
                    return CompletableFuture.completedFuture(new SettingResult(this.overrideDataSource.getLocalConfiguration(), 0L));
                }
                case REMOTE_OVER_LOCAL: {
                    if (this.configService == null) {
                        return CompletableFuture.completedFuture(new SettingResult(this.overrideDataSource.getLocalConfiguration(), 0L));
                    }
                    return this.configService.getSettings().thenApply(settingResult -> {
                        HashMap<String, Setting> localSettings = new HashMap<String, Setting>(this.overrideDataSource.getLocalConfiguration());
                        localSettings.putAll(settingResult.settings());
                        return new SettingResult(localSettings, settingResult.fetchTime());
                    });
                }
                case LOCAL_OVER_REMOTE: {
                    if (this.configService == null) {
                        return CompletableFuture.completedFuture(new SettingResult(this.overrideDataSource.getLocalConfiguration(), 0L));
                    }
                    return this.configService.getSettings().thenApply(settingResult -> {
                        Map<String, Setting> localSettings = this.overrideDataSource.getLocalConfiguration();
                        HashMap<String, Setting> remoteSettings = new HashMap<String, Setting>(settingResult.settings());
                        remoteSettings.putAll(localSettings);
                        return new SettingResult(remoteSettings, settingResult.fetchTime());
                    });
                }
            }
        }
        return this.configService == null ? CompletableFuture.completedFuture(SettingResult.EMPTY) : this.configService.getSettings();
    }

    private boolean checkSettingsAvailable(SettingResult settingResult, String emptyResult) {
        if (settingResult.isEmpty()) {
            this.logger.error(1000, ConfigCatLogMessages.getConfigJsonIsNotPresentedWithEmptyResult(emptyResult));
            return false;
        }
        return true;
    }

    private <T> Result<Setting> checkSettingAvailable(SettingResult settingResult, String key, T defaultValue) {
        if (settingResult.isEmpty()) {
            String errorMessage = ConfigCatLogMessages.getConfigJsonIsNotPresentedWithDefaultValue(key, "defaultValue", defaultValue);
            this.logger.error(1000, errorMessage);
            return Result.error(errorMessage, null);
        }
        Map<String, Setting> settings = settingResult.settings();
        Setting setting = settings.get(key);
        if (setting == null) {
            String errorMessage = ConfigCatLogMessages.getSettingEvaluationFailedDueToMissingKey(key, "defaultValue", defaultValue, settings.keySet());
            this.logger.error(1001, errorMessage);
            return Result.error(errorMessage, null);
        }
        return Result.success(setting);
    }

    private <T> T getValueFromSettingsMap(Class<T> classOfT, SettingResult settingResult, String key, User user, T defaultValue) {
        try {
            Result<Setting> checkSettingResult = this.checkSettingAvailable(settingResult, key, defaultValue);
            if (checkSettingResult.error() != null) {
                this.configCatHooks.invokeOnFlagEvaluated(EvaluationDetails.fromError(key, defaultValue, checkSettingResult.error(), user));
                return defaultValue;
            }
            return this.evaluate(classOfT, checkSettingResult.value(), key, this.getEvaluateUser(user), settingResult.fetchTime()).getValue();
        }
        catch (Exception e) {
            String errorMessage = ConfigCatLogMessages.getSettingEvaluationFailedForOtherReason(key, "defaultValue", defaultValue);
            this.logger.error(2001, errorMessage, e);
            this.configCatHooks.invokeOnFlagEvaluated(EvaluationDetails.fromError(key, defaultValue, errorMessage + " " + e.getMessage(), user));
            return defaultValue;
        }
    }

    private <T> Map.Entry<String, T> getKeyAndValueFromSettingsMap(Class<T> classOfT, SettingResult settingResult, String variationId) {
        try {
            if (!this.checkSettingsAvailable(settingResult, "null")) {
                return null;
            }
            Map<String, Setting> settings = settingResult.settings();
            for (Map.Entry<String, Setting> node : settings.entrySet()) {
                String settingKey = node.getKey();
                Setting setting = node.getValue();
                if (variationId.equals(setting.getVariationId())) {
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, setting.getValue()));
                }
                for (RolloutRule rolloutRule : setting.getRolloutRules()) {
                    if (!variationId.equals(rolloutRule.getVariationId())) continue;
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, rolloutRule.getValue()));
                }
                for (PercentageRule percentageRule : setting.getPercentageItems()) {
                    if (!variationId.equals(percentageRule.getVariationId())) continue;
                    return new AbstractMap.SimpleEntry<String, Object>(settingKey, this.parseObject(classOfT, percentageRule.getValue()));
                }
            }
            this.logger.error(2011, ConfigCatLogMessages.getSettingForVariationIdIsNotPresent(variationId));
            return null;
        }
        catch (Exception e) {
            this.logger.error(1002, ConfigCatLogMessages.getSettingEvaluationErrorWithEmptyValue("getKeyAndValueFromSettingsMap", "null"), e);
            return null;
        }
    }

    private Object parseObject(Class<?> classOfT, JsonElement element) {
        if (classOfT == String.class) {
            return element.getAsString();
        }
        if (classOfT == Integer.class || classOfT == Integer.TYPE) {
            return element.getAsInt();
        }
        if (classOfT == Double.class || classOfT == Double.TYPE) {
            return element.getAsDouble();
        }
        if (classOfT == Boolean.class || classOfT == Boolean.TYPE) {
            return element.getAsBoolean();
        }
        throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported");
    }

    private Class<?> classBySettingType(SettingType settingType) {
        if (settingType == SettingType.BOOLEAN) {
            return Boolean.TYPE;
        }
        if (settingType == SettingType.STRING) {
            return String.class;
        }
        if (settingType == SettingType.INT) {
            return Integer.TYPE;
        }
        if (settingType == SettingType.DOUBLE) {
            return Double.TYPE;
        }
        throw new IllegalArgumentException("Only String, Integer, Double or Boolean types are supported");
    }

    private User getEvaluateUser(User user) {
        return user != null ? user : this.defaultUser;
    }

    public static ConfigCatClient get(String sdkKey) {
        return ConfigCatClient.get(sdkKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigCatClient get(String sdkKey, Consumer<Options> optionsCallback) {
        if (sdkKey == null || sdkKey.isEmpty()) {
            throw new IllegalArgumentException("'sdkKey' cannot be null or empty.");
        }
        Map<String, ConfigCatClient> map = INSTANCES;
        synchronized (map) {
            Options clientOptions = new Options();
            ConfigCatClient client = INSTANCES.get(sdkKey);
            if (client != null) {
                if (optionsCallback != null) {
                    client.logger.warn(3000, ConfigCatLogMessages.getClientIsAlreadyCreated(sdkKey));
                }
                return client;
            }
            if (optionsCallback != null) {
                Options options = new Options();
                optionsCallback.accept(options);
                clientOptions = options;
            }
            client = new ConfigCatClient(sdkKey, clientOptions);
            INSTANCES.put(sdkKey, client);
            return client;
        }
    }

    private EvaluationDetails<Object> evaluateObject(Class classOfT, Setting setting, String key, User user, Long fetchTime) {
        EvaluationResult evaluationResult = this.rolloutEvaluator.evaluate(setting, key, user);
        EvaluationDetails<Object> details = new EvaluationDetails<Object>(this.parseObject(classOfT, evaluationResult.value), key, evaluationResult.variationId, user, false, null, fetchTime, evaluationResult.targetingRule, evaluationResult.percentageRule);
        this.configCatHooks.invokeOnFlagEvaluated(details);
        return details;
    }

    private <T> EvaluationDetails<T> evaluate(Class<T> classOfT, Setting setting, String key, User user, Long fetchTime) {
        return this.evaluateObject(classOfT, setting, key, user, fetchTime).asTypeSpecific();
    }

    public static class Options {
        private OkHttpClient httpClient;
        private ConfigCache cache = new NullConfigCache();
        private String baseUrl;
        private PollingMode pollingMode = PollingModes.autoPoll();
        private LogLevel logLevel = LogLevel.WARNING;
        private DataGovernance dataGovernance = DataGovernance.GLOBAL;
        private OverrideDataSourceBuilder localDataSourceBuilder;
        private OverrideBehaviour overrideBehaviour;
        private User defaultUser;
        private boolean offline = false;
        private final ConfigCatHooks configCatHooks = new ConfigCatHooks();

        public void httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public void cache(ConfigCache cache) {
            this.cache = cache;
        }

        public void baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public void pollingMode(PollingMode pollingMode) {
            this.pollingMode = pollingMode;
        }

        public void dataGovernance(DataGovernance dataGovernance) {
            this.dataGovernance = dataGovernance;
        }

        public void logLevel(LogLevel logLevel) {
            this.logLevel = logLevel;
        }

        public void flagOverrides(OverrideDataSourceBuilder dataSourceBuilder, OverrideBehaviour behaviour) {
            if (dataSourceBuilder == null) {
                throw new IllegalArgumentException("'dataSourceBuilder' cannot be null or empty.");
            }
            if (behaviour == null) {
                throw new IllegalArgumentException("'behaviour' cannot be null.");
            }
            this.localDataSourceBuilder = dataSourceBuilder;
            this.overrideBehaviour = behaviour;
        }

        public void defaultUser(User defaultUser) {
            this.defaultUser = defaultUser;
        }

        public void offline(boolean offline) {
            this.offline = offline;
        }

        public ConfigCatHooks hooks() {
            return this.configCatHooks;
        }
    }
}

